/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.URI;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.osgi.util.NLS;

public class RepositoryDescriptor {
    public static final int TYPE_BOTH = -1;
    public static final String KIND_ARTIFACT = "A";
    public static final String KIND_METADATA = "M";
    private boolean compressed = true;
    private boolean append = true;
    private String name = null;
    private URI location = null;
    private URI format = null;
    private int kind = -1;

    public void setCompressed(boolean compress) {
        this.compressed = compress;
    }

    public void setName(String repoName) {
        this.name = repoName;
    }

    public void setLocation(URI repoLocation) {
        this.location = RepositoryHelper.localRepoURIHelper((URI)repoLocation);
    }

    public void setFormat(URI format) {
        this.format = RepositoryHelper.localRepoURIHelper((URI)format);
    }

    public void setAppend(boolean appendMode) {
        this.append = appendMode;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isAppend() {
        return this.append;
    }

    public String getName() {
        return this.name;
    }

    public URI getRepoLocation() {
        return this.location;
    }

    public URI getFormat() {
        return this.format;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean isBoth() {
        return this.kind == -1;
    }

    public boolean isArtifact() {
        return this.kind == -1 || this.kind == 1;
    }

    public boolean isMetadata() {
        return this.kind == -1 || this.kind == 0;
    }

    public void setKind(String repoKind) {
        this.kind = RepositoryDescriptor.determineKind(repoKind);
    }

    public static int determineKind(String repoKind) {
        if (RepositoryDescriptor.kindMatches(repoKind, KIND_METADATA)) {
            return 0;
        }
        if (RepositoryDescriptor.kindMatches(repoKind, KIND_ARTIFACT)) {
            return 1;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.unknown_repository_type, (Object)repoKind));
    }

    public static boolean kindMatches(String repoKind, String kindIdentifier) {
        return repoKind.startsWith(kindIdentifier) || repoKind.startsWith(kindIdentifier.toLowerCase());
    }
}

