/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.threadgroups;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetProxy;
import org.eclipse.debug.internal.ui.viewers.update.StackFrameEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jdt.internal.debug.ui.threadgroups.JavaThreadEventHandler;
import org.eclipse.jface.viewers.Viewer;

public class JavaDebugTargetProxy
extends DebugTargetProxy {
    private JavaThreadEventHandler fThreadEventHandler;
    private boolean fIsScrapbook = false;

    public JavaDebugTargetProxy(IDebugTarget target) {
        super(target);
        ILaunch launch = target.getLaunch();
        if (launch != null) {
            this.fIsScrapbook = launch.getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) != null;
        }
    }

    protected DebugEventHandler[] createEventHandlers() {
        this.fThreadEventHandler = new JavaThreadEventHandler((AbstractModelProxy)this);
        return new DebugEventHandler[]{new DebugTargetEventHandler((AbstractModelProxy)this), this.fThreadEventHandler, new StackFrameEventHandler((AbstractModelProxy)this, (ThreadEventHandler)this.fThreadEventHandler)};
    }

    public void installed(Viewer viewer) {
        if (this.fIsScrapbook) {
            return;
        }
        final Viewer finalViewer = viewer;
        Job job = new Job("Initialize Java Debug Session"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!JavaDebugTargetProxy.this.isDisposed()) {
                    JavaDebugTargetProxy.super.installed(finalViewer);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(500L);
        this.fThreadEventHandler.init(viewer);
    }
}

