/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.ServiceRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ServiceReply
extends ReplyMessage {
    List urlList;

    ServiceReply(ServiceRequest serviceRequest, List list) {
        this.funcID = (byte)2;
        this.xid = serviceRequest.xid;
        this.locale = serviceRequest.locale;
        this.address = serviceRequest.address;
        this.port = serviceRequest.port;
        this.errorCode = 0;
        this.urlList = list;
    }

    ServiceReply(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        this.errorCode = dataInputStream.readShort();
        int n = dataInputStream.readShort();
        this.urlList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            this.urlList.add(ServiceURL.fromBytes(dataInputStream));
        }
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, this.toString());
        }
    }

    protected void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        dataOutputStream.writeShort(this.errorCode);
        dataOutputStream.writeShort(this.urlList.size());
        for (int i = 0; i < this.urlList.size(); ++i) {
            ((ServiceURL)this.urlList.get(i)).writeTo(dataOutputStream);
        }
    }

    int getSize() {
        int n = this.getHeaderSize() + 2 + 2;
        for (int i = 0; i < this.urlList.size(); ++i) {
            n += ((ServiceURL)this.urlList.get(i)).getLength();
        }
        return n;
    }

    List getResult() {
        return this.urlList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", errorCode " + this.errorCode);
        stringBuffer.append(", URLCount " + this.urlList.size());
        stringBuffer.append(", URLs " + this.urlList);
        return stringBuffer.toString();
    }

    void sign(String string) throws ServiceLocationException {
        List list = SLPMessage.stringToList(string, ",");
        Iterator iterator = this.urlList.iterator();
        while (iterator.hasNext()) {
            ServiceURL serviceURL = (ServiceURL)iterator.next();
            serviceURL.sign(list);
        }
    }

    boolean verify() throws ServiceLocationException {
        Iterator iterator = this.urlList.iterator();
        while (iterator.hasNext()) {
            ServiceURL serviceURL = (ServiceURL)iterator.next();
            if (serviceURL.verify()) continue;
            return false;
        }
        return true;
    }
}

