/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AttributeReply;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.DAAdvertisement;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.ServiceAcknowledgement;
import ch.ethz.iks.slp.impl.ServiceDeregistration;
import ch.ethz.iks.slp.impl.ServiceRegistration;
import ch.ethz.iks.slp.impl.ServiceReply;
import ch.ethz.iks.slp.impl.ServiceRequest;
import ch.ethz.iks.slp.impl.ServiceTypeReply;
import ch.ethz.iks.slp.impl.ServiceTypeRequest;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class SLPMessage {
    Locale locale;
    byte funcID;
    short xid;
    InetAddress address;
    int port;
    boolean tcp;
    boolean multicast;
    public static final byte SRVRQST = 1;
    public static final byte SRVRPLY = 2;
    public static final byte SRVREG = 3;
    public static final byte SRVDEREG = 4;
    public static final byte SRVACK = 5;
    public static final byte ATTRRQST = 6;
    public static final byte ATTRRPLY = 7;
    public static final byte DAADVERT = 8;
    public static final byte SRVTYPERQST = 9;
    public static final byte SRVTYPERPLY = 10;
    public static final byte SAADVERT = 11;
    private static final String[] TYPES = new String[]{"NULL", "SRVRQST", "SRVPLY", "SRVREG", "SRVDEREG", "SRVACK", "ATTRRQST", "ATTRRPLY", "DAADVERT", "SRVTYPERQST", "SRVTYPERPLY", "SAADVERT"};

    protected void writeHeader(DataOutputStream dataOutputStream, int n) throws IOException {
        int n2 = 0;
        if (this.funcID == 3) {
            n2 = (byte)(n2 | 0x40);
        }
        if (this.multicast) {
            n2 = (byte)(n2 | 0x20);
        }
        if (!this.tcp && n > SLPCore.CONFIG.getMTU()) {
            n2 = (byte)(n2 | 0x80);
        }
        dataOutputStream.write(2);
        dataOutputStream.write(this.funcID);
        dataOutputStream.write((byte)(n >> 16));
        dataOutputStream.write((byte)(n >> 8 & 0xFF));
        dataOutputStream.write((byte)(n & 0xFF));
        dataOutputStream.write(n2);
        dataOutputStream.write(0);
        dataOutputStream.write(0);
        dataOutputStream.write(0);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(this.xid);
        dataOutputStream.writeUTF(this.locale.getLanguage());
    }

    abstract void writeTo(DataOutputStream var1) throws IOException;

    byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeTo(dataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    static SLPMessage parse(InetAddress inetAddress, int n, DataInputStream dataInputStream, boolean bl) throws ServiceLocationException, ProtocolException {
        try {
            SLPMessage sLPMessage;
            short s;
            byte by = dataInputStream.readByte();
            if (by == 1) {
                dataInputStream.readByte();
                s = dataInputStream.readShort();
                byte[] byArray = new byte[s - 4];
                dataInputStream.readFully(byArray);
                if (SLPCore.platform.isWarningEnabled()) {
                    SLPCore.platform.logWarning("Dropped SLPv1 message from " + inetAddress + ":" + n);
                }
            }
            s = dataInputStream.readByte();
            int n2 = SLPMessage.readInt(dataInputStream, 3);
            byte by2 = (byte)(dataInputStream.readShort() >> 8);
            if (!bl && (by2 & 0x80) != 0) {
                throw new ProtocolException();
            }
            SLPMessage.readInt(dataInputStream, 3);
            short s2 = dataInputStream.readShort();
            Locale locale = new Locale(dataInputStream.readUTF(), "");
            switch (s) {
                case 8: {
                    sLPMessage = new DAAdvertisement(dataInputStream);
                    break;
                }
                case 1: {
                    sLPMessage = new ServiceRequest(dataInputStream);
                    break;
                }
                case 2: {
                    sLPMessage = new ServiceReply(dataInputStream);
                    break;
                }
                case 6: {
                    sLPMessage = new AttributeRequest(dataInputStream);
                    break;
                }
                case 7: {
                    sLPMessage = new AttributeReply(dataInputStream);
                    break;
                }
                case 3: {
                    sLPMessage = new ServiceRegistration(dataInputStream);
                    break;
                }
                case 4: {
                    sLPMessage = new ServiceDeregistration(dataInputStream);
                    break;
                }
                case 5: {
                    sLPMessage = new ServiceAcknowledgement(dataInputStream);
                    break;
                }
                case 9: {
                    sLPMessage = new ServiceTypeRequest(dataInputStream);
                    break;
                }
                case 10: {
                    sLPMessage = new ServiceTypeReply(dataInputStream);
                    break;
                }
                default: {
                    throw new ServiceLocationException(2, "Message type " + SLPMessage.getType(s) + " not supported");
                }
            }
            sLPMessage.address = inetAddress;
            sLPMessage.port = n;
            sLPMessage.tcp = bl;
            sLPMessage.multicast = (by2 & 0x2000) >> 13 == 1;
            sLPMessage.xid = s2;
            sLPMessage.funcID = (byte)s;
            sLPMessage.locale = locale;
            if (sLPMessage.getSize() != n2 && SLPCore.platform.isErrorEnabled()) {
                SLPCore.platform.logError("Length of " + sLPMessage + " should be " + n2 + ", read " + sLPMessage.getSize());
            }
            return sLPMessage;
        }
        catch (ProtocolException protocolException) {
            throw protocolException;
        }
        catch (IOException iOException) {
            if (SLPCore.platform.isErrorEnabled()) {
                SLPCore.platform.logError("Network Error", iOException);
            }
            throw new ServiceLocationException(19, iOException.getMessage());
        }
    }

    int getHeaderSize() {
        return 14 + this.locale.getLanguage().length();
    }

    abstract int getSize();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SLPMessage.getType(this.funcID) + " - ");
        stringBuffer.append("xid=" + this.xid);
        stringBuffer.append(", locale=" + this.locale);
        return stringBuffer.toString();
    }

    static String getType(int n) {
        if (n > -1 && n < 12) {
            return TYPES[n];
        }
        return String.valueOf(n + " - UNSUPPORTED");
    }

    private static int readInt(DataInputStream dataInputStream, int n) throws ServiceLocationException {
        try {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 <<= 8;
                n2 += dataInputStream.readByte() & 0xFF;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(2, iOException.getMessage());
        }
    }

    static String listToString(List list, String string) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0).toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = list.toArray();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(string);
        }
        stringBuffer.append(objectArray[objectArray.length - 1]);
        return stringBuffer.toString();
    }

    static List stringToList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }
}

