/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.engine.EngineSession;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;

public abstract class PhaseSet {
    private final Phase[] phases;

    public PhaseSet(Phase[] phases) {
        if (phases == null) {
            throw new IllegalArgumentException(Messages.null_phases);
        }
        this.phases = phases;
    }

    public final MultiStatus perform(EngineSession session, IProfile profile, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        int[] weights = this.getProgressWeights(operands);
        int totalWork = this.getTotalWork(weights);
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        try {
            int i = 0;
            while (i < this.phases.length) {
                if (pm.isCanceled()) {
                    result.add(Status.CANCEL_STATUS);
                    MultiStatus multiStatus = result;
                    return multiStatus;
                }
                Phase phase = this.phases[i];
                MultiStatus performResult = phase.perform(session, profile, operands, context, (IProgressMonitor)pm.newChild(weights[i]));
                if (!performResult.isOK()) {
                    result.add((IStatus)performResult);
                }
                if (result.matches(12)) {
                    MultiStatus multiStatus = result;
                    return multiStatus;
                }
                ++i;
            }
        }
        finally {
            pm.done();
        }
        return result;
    }

    private int getTotalWork(int[] weights) {
        int sum = 0;
        int i = 0;
        while (i < weights.length) {
            sum += weights[i];
            ++i;
        }
        return sum;
    }

    private int[] getProgressWeights(Operand[] operands) {
        int[] weights = new int[this.phases.length];
        int i = 0;
        while (i < this.phases.length) {
            weights[i] = operands.length > 0 ? this.phases[i].weight * this.countApplicable(this.phases[i], operands) / operands.length : this.phases[i].weight;
            ++i;
        }
        return weights;
    }

    private int countApplicable(Phase phase, Operand[] operands) {
        int count = 0;
        int i = 0;
        while (i < operands.length) {
            if (phase.isApplicable(operands[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

