/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.EEVMInstall;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;

public class EEVMType
extends AbstractVMInstallType {
    public static final String ID_EE_VM_TYPE = "org.eclipse.jdt.launching.EEVMType";
    private static Map fgProperties = new HashMap();
    private static Map fgArguments = new HashMap();
    public static final String PROP_ENDORSED_DIRS = "-Dee.endorsed.dirs";
    public static final String PROP_BOOT_CLASS_PATH = "-Dee.bootclasspath";
    public static final String PROP_SOURCE_DEFAULT = "-Dee.src";
    public static final String PROP_SOURCE_MAP = "-Dee.src.map";
    public static final String PROP_JAVADOC_LOC = "-Dee.javadoc";
    public static final String PROP_ADDITIONAL_DIRS = "-Dee.additional.dirs";
    public static final String PROP_EXTENSION_DIRS = "-Dee.ext.dirs";
    public static final String PROP_LANGUAGE_LEVEL = "-Dee.language.level";
    public static final String PROP_CLASS_LIB_LEVEL = "-Dee.class.library.level";
    public static final String PROP_EXECUTABLE = "-Dee.executable";
    public static final String PROP_EXECUTABLE_CONSOLE = "-Dee.executable.console";
    public static final String PROP_JAVA_HOME = "-Djava.home";
    public static final String PROP_DEBUG_ARGS = "-Dee.debug.args";
    public static final String PROP_NAME = "-Dee.name";
    public static final Character WILDCARD_SINGLE_CHAR = new Character('?');
    public static final Character WILDCARD_MULTI_CHAR = new Character('*');
    public static final String REGEX_SPECIAL_CHARS = "+()^$.{}[]|\\";
    private static final String EE_ARG_FILTER = "-Dee.";
    public static final String VAR_EE_HOME = "${ee.home}";
    private static final String[] REQUIRED_PROPERTIES = new String[]{"-Dee.executable", "-Dee.bootclasspath", "-Dee.language.level", "-Djava.home"};

    public static String getVMName(File eeFile) {
        String name = EEVMType.getProperty(PROP_NAME, eeFile);
        if (name == null) {
            name = eeFile.getName();
        }
        return name;
    }

    public static LibraryLocation[] getLibraryLocations(File eeFile) {
        Map properties = EEVMType.getProperties(eeFile);
        if (properties == null) {
            return new LibraryLocation[0];
        }
        ArrayList allLibs = new ArrayList();
        String dirs = EEVMType.getProperty(PROP_ENDORSED_DIRS, eeFile);
        if (dirs != null) {
            allLibs.addAll(StandardVMType.gatherAllLibraries(EEVMType.resolvePaths(dirs, eeFile)));
        }
        if ((dirs = EEVMType.getProperty(PROP_BOOT_CLASS_PATH, eeFile)) != null) {
            String[] bootpath = EEVMType.resolvePaths(dirs, eeFile);
            ArrayList<LibraryLocation> boot = new ArrayList<LibraryLocation>(bootpath.length);
            IPath src = EEVMType.getSourceLocation(eeFile);
            URL url = EEVMType.getJavadocLocation(eeFile);
            int i = 0;
            while (i < bootpath.length) {
                Path path = new Path(bootpath[i]);
                File lib = path.toFile();
                if (lib.exists() && lib.isFile()) {
                    LibraryLocation libraryLocation = new LibraryLocation((IPath)path, src, (IPath)Path.EMPTY, url);
                    boot.add(libraryLocation);
                }
                ++i;
            }
            allLibs.addAll(boot);
        }
        if ((dirs = EEVMType.getProperty(PROP_ADDITIONAL_DIRS, eeFile)) != null) {
            allLibs.addAll(StandardVMType.gatherAllLibraries(EEVMType.resolvePaths(dirs, eeFile)));
        }
        if ((dirs = EEVMType.getProperty(PROP_EXTENSION_DIRS, eeFile)) != null) {
            allLibs.addAll(StandardVMType.gatherAllLibraries(EEVMType.resolvePaths(dirs, eeFile)));
        }
        HashSet<String> set = new HashSet<String>();
        LibraryLocation lib = null;
        ListIterator liter = allLibs.listIterator();
        while (liter.hasNext()) {
            lib = (LibraryLocation)liter.next();
            if (set.add(lib.getSystemLibraryPath().toOSString())) continue;
            liter.remove();
        }
        EEVMType.addSourceLocationsToLibraries(EEVMType.getSourceMap(eeFile), allLibs);
        return allLibs.toArray(new LibraryLocation[allLibs.size()]);
    }

    protected static IPath getSourceLocation(File eeFile) {
        String src = EEVMType.getProperty(PROP_SOURCE_DEFAULT, eeFile);
        if (src != null) {
            src = EEVMType.makePathAbsolute(src, (IPath)new Path(eeFile.getParentFile().getAbsolutePath()));
            return new Path(src);
        }
        return Path.EMPTY;
    }

    private static void addSourceLocationsToLibraries(Map srcMap, List libraries) {
        Iterator patternIterator = srcMap.keySet().iterator();
        while (patternIterator.hasNext()) {
            String currentKey = (String)patternIterator.next();
            Pattern currentPattern = Pattern.compile(currentKey);
            Matcher matcher = currentPattern.matcher("");
            Iterator locationIterator = libraries.iterator();
            while (locationIterator.hasNext()) {
                String sourceLocation;
                Path sourcePath;
                LibraryLocation currentLibrary = (LibraryLocation)locationIterator.next();
                matcher.reset(currentLibrary.getSystemLibraryPath().toOSString());
                if (!matcher.find() || !(sourcePath = new Path(sourceLocation = matcher.replaceAll((String)srcMap.get(currentKey)))).toFile().exists()) continue;
                currentLibrary.setSystemLibrarySource((IPath)sourcePath);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Map getSourceMap(File eeFile) {
        block13: {
            srcMapString = EEVMType.getProperty("-Dee.src.map", eeFile);
            srcMap = new HashMap<String, String>();
            if (srcMapString == null) break block13;
            entries = srcMapString.split(File.pathSeparator);
            i = 0;
            while (i < entries.length) {
                block15: {
                    block14: {
                        index = entries[i].indexOf(61);
                        if (index <= 0 || index >= entries[i].length() - 1) break block14;
                        root = new Path(eeFile.getParentFile().getAbsolutePath());
                        key = entries[i].substring(0, index);
                        value = entries[i].substring(index + 1);
                        key = EEVMType.makePathAbsolute(key, (IPath)root);
                        value = EEVMType.makePathAbsolute(value, (IPath)root);
                        wildcards = new ArrayList<Character>();
                        keyBuffer = new StringBuffer();
                        chars = key.toCharArray();
                        j = 0;
                        while (j < chars.length) {
                            if (chars[j] == EEVMType.WILDCARD_MULTI_CHAR.charValue()) {
                                wildcards.add(EEVMType.WILDCARD_MULTI_CHAR);
                                keyBuffer.append("(.*)");
                            } else if (chars[j] == EEVMType.WILDCARD_SINGLE_CHAR.charValue()) {
                                wildcards.add(EEVMType.WILDCARD_SINGLE_CHAR);
                                keyBuffer.append("(.)");
                            } else if ("+()^$.{}[]|\\".indexOf(chars[j]) != -1) {
                                keyBuffer.append('\\').append(chars[j]);
                            } else {
                                keyBuffer.append(chars[j]);
                            }
                            ++j;
                        }
                        currentWild = 0;
                        valueBuffer = new StringBuffer();
                        chars = value.toCharArray();
                        j = 0;
                        while (j < chars.length) {
                            if (chars[j] != EEVMType.WILDCARD_MULTI_CHAR.charValue() && chars[j] != EEVMType.WILDCARD_SINGLE_CHAR.charValue()) ** GOTO lbl56
                            if (currentWild >= wildcards.size()) ** GOTO lbl54
                            wild = (Character)wildcards.get(currentWild);
                            if (chars[j] == wild.charValue()) {
                                valueBuffer.append('$').append(currentWild + 1);
                                ++currentWild;
                            } else {
                                LaunchingPlugin.log(MessageFormat.format((String)LaunchingMessages.EEVMType_5, (Object[])new String[]{entries[i]}));
                                break;
lbl54:
                                // 1 sources

                                LaunchingPlugin.log(MessageFormat.format((String)LaunchingMessages.EEVMType_5, (Object[])new String[]{entries[i]}));
                                break;
lbl56:
                                // 1 sources

                                if ("+()^$.{}[]|\\".indexOf(chars[j]) != -1) {
                                    valueBuffer.append('\\').append(chars[j]);
                                } else {
                                    valueBuffer.append(chars[j]);
                                }
                            }
                            ++j;
                        }
                        srcMap.put(keyBuffer.toString(), valueBuffer.toString());
                        break block15;
                    }
                    LaunchingPlugin.log(MessageFormat.format((String)LaunchingMessages.EEVMType_6, (Object[])new String[]{entries[i]}));
                }
                ++i;
            }
        }
        return srcMap;
    }

    public static URL getJavadocLocation(File eeFile) {
        if (EEVMType.hasProperty(PROP_JAVADOC_LOC, eeFile)) {
            String javadoc = EEVMType.getProperty(PROP_JAVADOC_LOC, eeFile);
            if (javadoc != null) {
                try {
                    URL url = new URL(javadoc);
                    if ("file".equalsIgnoreCase(url.getProtocol())) {
                        File file = new File(url.getFile());
                        url = file.getCanonicalFile().toURL();
                    }
                    return url;
                }
                catch (MalformedURLException e) {
                    LaunchingPlugin.log(e);
                    return null;
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                    return null;
                }
            }
            return null;
        }
        String version = EEVMType.getProperty(PROP_LANGUAGE_LEVEL, eeFile);
        if (version != null) {
            return StandardVMType.getDefaultJavadocLocation(version);
        }
        return null;
    }

    public static String getDebugArgs(File eeFile) {
        return EEVMType.getProperty(PROP_DEBUG_ARGS, eeFile);
    }

    public static File getDefinitionFile(IVMInstall vm) {
        AbstractVMInstall avm;
        String path;
        if (vm instanceof AbstractVMInstall && (path = (avm = (AbstractVMInstall)vm).getAttribute("ATTR_DEFINITION_FILE")) != null) {
            return new File(path);
        }
        return null;
    }

    public static String getVMArguments(File eeFile) {
        EEVMType.getProperties(eeFile);
        return (String)fgArguments.get(eeFile);
    }

    public static IStatus validateDefinitionFile(File eeFile) {
        Map properties = EEVMType.getProperties(eeFile);
        if (properties == null) {
            return new Status(4, LaunchingPlugin.getUniqueIdentifier(), MessageFormat.format((String)LaunchingMessages.EEVMType_0, (Object[])new String[]{eeFile.getName()}));
        }
        int i = 0;
        while (i < REQUIRED_PROPERTIES.length) {
            String key = REQUIRED_PROPERTIES[i];
            String property = (String)properties.get(key);
            if (property == null) {
                return new Status(4, LaunchingPlugin.getUniqueIdentifier(), MessageFormat.format((String)LaunchingMessages.EEVMType_1, (Object[])new String[]{eeFile.getName(), key}));
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public static File getExecutable(File installLocation) {
        String[] paths;
        String property = EEVMType.getProperty(PROP_EXECUTABLE, installLocation);
        if (property == null) {
            property = EEVMType.getProperty(PROP_EXECUTABLE_CONSOLE, installLocation);
        }
        if (property != null && (paths = EEVMType.resolvePaths(property, installLocation)).length == 1) {
            return new File(paths[0]);
        }
        return null;
    }

    public static String getJavaVersion(File eeFile) {
        return EEVMType.getProperty(PROP_LANGUAGE_LEVEL, eeFile);
    }

    private static synchronized Map getProperties(File eeFile) {
        HashMap<String, String> properties;
        block31: {
            properties = (HashMap<String, String>)fgProperties.get(eeFile);
            String eeHome = eeFile.getParentFile().getAbsolutePath();
            if (properties == null) {
                BufferedReader bufferedReader = null;
                try {
                    FileReader reader = new FileReader(eeFile);
                    properties = new HashMap<String, String>();
                    StringBuffer arguments = new StringBuffer();
                    bufferedReader = new BufferedReader(reader);
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        if (!line.startsWith("#") && line.trim().length() > 0) {
                            boolean appendArgument = !line.startsWith(EE_ARG_FILTER);
                            int eq = line.indexOf(61);
                            if (eq > 0) {
                                String key = line.substring(0, eq);
                                if (appendArgument) {
                                    arguments.append(key).append('=');
                                }
                                String value = null;
                                if (line.length() > eq + 1) {
                                    value = line.substring(eq + 1).trim();
                                    value = EEVMType.resolve(value, eeHome);
                                    if (appendArgument) {
                                        if (value.indexOf(32) > -1) {
                                            arguments.append('\"').append(value).append('\"');
                                        } else {
                                            arguments.append(value);
                                        }
                                    }
                                }
                                properties.put(key, value);
                                if (appendArgument) {
                                    arguments.append(' ');
                                }
                            } else if (appendArgument) {
                                arguments.append(line).append(' ');
                            }
                        }
                        line = bufferedReader.readLine();
                    }
                    if (arguments.charAt(arguments.length() - 1) == ' ') {
                        arguments.deleteCharAt(arguments.length() - 1);
                    }
                    fgProperties.put(eeFile, properties);
                    fgArguments.put(eeFile, arguments.toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    properties = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block31;
                    }
                    catch (IOException iOException) {}
                    break block31;
                }
                catch (IOException iOException) {
                    try {
                        properties = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block31;
                    }
                    catch (IOException iOException3) {}
                    break block31;
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private static String resolve(String value, String eeHome) {
        int start = 0;
        int index = value.indexOf(VAR_EE_HOME, start);
        StringBuffer replaced = null;
        while (index >= 0) {
            if (replaced == null) {
                replaced = new StringBuffer();
            }
            replaced.append(value.substring(start, index));
            replaced.append(eeHome);
            start = index + VAR_EE_HOME.length();
            index = value.indexOf(VAR_EE_HOME, start);
        }
        if (replaced != null) {
            replaced.append(value.substring(start));
            return replaced.toString();
        }
        return value;
    }

    private static String[] resolvePaths(String paths, File eeFile) {
        String[] strings = paths.split(File.pathSeparator, -1);
        Path root = new Path(eeFile.getParentFile().getAbsolutePath());
        int i = 0;
        while (i < strings.length) {
            strings[i] = EEVMType.makePathAbsolute(strings[i], (IPath)root);
            ++i;
        }
        return strings;
    }

    private static String makePathAbsolute(String pathString, IPath root) {
        Path path = new Path(pathString.trim());
        if (!path.isEmpty() && !path.isAbsolute()) {
            IPath filePath = root.append((IPath)path);
            return filePath.toOSString();
        }
        return path.toOSString();
    }

    public static String getProperty(String propertyName, File eeFile) {
        Map properties = EEVMType.getProperties(eeFile);
        if (properties != null) {
            return (String)properties.get(propertyName);
        }
        return null;
    }

    public static boolean hasProperty(String propertyName, File eeFile) {
        Map properties = EEVMType.getProperties(eeFile);
        if (properties != null) {
            return properties.containsKey(propertyName);
        }
        return false;
    }

    protected IVMInstall doCreateVMInstall(String id) {
        return new EEVMInstall(this, id);
    }

    public File detectInstallLocation() {
        return null;
    }

    public LibraryLocation[] getDefaultLibraryLocations(File installLocationOrDefinitionFile) {
        return new LibraryLocation[0];
    }

    public String getName() {
        return LaunchingMessages.EEVMType_2;
    }

    public IStatus validateInstallLocation(File installLocation) {
        if (installLocation.exists()) {
            return new Status(1, "org.eclipse.jdt.launching", LaunchingMessages.EEVMType_4);
        }
        return new Status(4, "org.eclipse.jdt.launching", MessageFormat.format((String)LaunchingMessages.EEVMType_3, (Object[])new String[]{installLocation.getPath()}));
    }

    public static synchronized void clearProperties(File eeFile) {
        fgProperties.remove(eeFile);
        fgArguments.remove(eeFile);
    }
}

