/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Options {
    public static final String PARAM_FEATUREID = "featureId";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO = "to";
    public static final String PARAM_VERIFYONLY = "verifyOnly";
    private static boolean debug = false;
    private static boolean useExe = true;
    private static File eclipseHome;
    private static File workspace;
    private static File lockFile;
    private static File hostPortFile;
    private static String vm;
    private static List vmArgs;
    private static List eclipseArgs;
    private static List helpCommand;
    private static String host;
    private static String port;
    private static String adminId;
    private static String adminPassword;
    private static String trustStoreLocation;
    private static String trustStorePassword;
    private static String[] updateParameters;

    static {
        adminId = null;
        adminPassword = null;
        trustStoreLocation = null;
        trustStorePassword = null;
    }

    public static void init(String appId, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            list.add(args[i]);
            ++i;
        }
        Options.init(appId, list);
    }

    public static void init(String appId, List options) {
        List vms;
        List trustStorePasswords;
        List trustStoreLocations;
        List adminPasswords;
        List adminIds;
        List ports;
        List homes;
        eclipseArgs = new ArrayList();
        eclipseArgs.addAll(options);
        helpCommand = Options.extractOption(eclipseArgs, "-command");
        if (helpCommand == null) {
            helpCommand = new ArrayList(0);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        List param = Options.extractOption(eclipseArgs, "-featureId");
        if (param != null) {
            parameters.add("featureId=" + (String)param.get(0));
        }
        if ((param = Options.extractOption(eclipseArgs, "-version")) != null) {
            parameters.add("version=" + (String)param.get(0));
        }
        if ((param = Options.extractOption(eclipseArgs, "-from")) != null) {
            parameters.add("from=" + (String)param.get(0));
        }
        if ((param = Options.extractOption(eclipseArgs, "-to")) != null) {
            parameters.add("to=" + (String)param.get(0));
        }
        if ((param = Options.extractOption(eclipseArgs, "-verifyOnly")) != null) {
            parameters.add("verifyOnly=" + (String)param.get(0));
        }
        updateParameters = parameters.toArray(new String[parameters.size()]);
        if (Options.getOption(eclipseArgs, "-debug") != null) {
            debug = true;
            System.out.println("Debugging is on.");
        }
        if (Options.extractOption(eclipseArgs, "-noexec") != null) {
            useExe = false;
        }
        if ((homes = Options.extractOption(eclipseArgs, "-eclipseHome")) == null || homes.isEmpty()) {
            homes = Options.extractOption(eclipseArgs, "-eclipse_Home");
        }
        eclipseHome = homes != null && !homes.isEmpty() ? new File((String)homes.get(0)) : new File(System.getProperty("user.dir"));
        List workspaces = Options.extractOption(eclipseArgs, "-data");
        if (workspaces != null && !workspaces.isEmpty()) {
            String workspacePath = (String)workspaces.get(0);
            workspace = new File(workspacePath);
            if (!workspace.isAbsolute()) {
                workspace = new File(eclipseHome, workspacePath);
            }
        } else {
            workspace = new File(eclipseHome, "workspace");
        }
        lockFile = new File(workspace, "/.metadata/.helplock");
        hostPortFile = new File(workspace, "/.metadata/.connection");
        List hosts = Options.extractOption(eclipseArgs, "-host");
        if (hosts != null && hosts.size() > 0) {
            host = (String)hosts.get(0);
        }
        if ((ports = Options.extractOption(eclipseArgs, "-port")) != null && ports.size() > 0) {
            port = (String)ports.get(0);
        }
        if ((adminIds = Options.extractOption(eclipseArgs, "-adminId")) != null && adminIds.size() > 0) {
            adminId = (String)adminIds.get(0);
        }
        if ((adminPasswords = Options.extractOption(eclipseArgs, "-adminPassword")) != null && adminPasswords.size() > 0) {
            adminPassword = (String)adminPasswords.get(0);
        }
        if ((trustStoreLocations = Options.extractOption(eclipseArgs, "-trustStoreLocation")) != null && trustStoreLocations.size() > 0) {
            trustStoreLocation = (String)trustStoreLocations.get(0);
        }
        if ((trustStorePasswords = Options.extractOption(eclipseArgs, "-trustStorePassword")) != null && trustStorePasswords.size() > 0) {
            trustStorePassword = (String)trustStorePasswords.get(0);
        }
        if ((vms = Options.extractOption(eclipseArgs, "-vm")) != null && !vms.isEmpty()) {
            vm = (String)vms.get(0);
        } else {
            String executable;
            String vmName = System.getProperty("java.vm.name");
            String string = executable = "J9".equals(vmName) ? "j9" : "java";
            if (System.getProperty("os.name").startsWith("Win")) {
                executable = !debug ? String.valueOf(executable) + "w.exe" : String.valueOf(executable) + ".exe";
            }
            vm = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + executable;
        }
        vmArgs = new ArrayList(0);
        List passedVmArgs = Options.extractOption(eclipseArgs, "-vmargs");
        if (passedVmArgs != null && passedVmArgs.size() > 0) {
            vmArgs = passedVmArgs;
        }
        eclipseArgs.add(0, "-data");
        eclipseArgs.add(1, Options.getWorkspace().getAbsolutePath());
        Options.extractOption(eclipseArgs, "-application");
        eclipseArgs.add(0, "-application");
        eclipseArgs.add(1, appId);
        Options.extractOption(eclipseArgs, "-showsplash");
        Options.extractOption(eclipseArgs, "-endsplash");
        Options.extractOption(eclipseArgs, "-nosplash");
        eclipseArgs.add(0, "-nosplash");
        if (host != null || port != null) {
            if (host != null) {
                vmArgs.add("-Dserver_host=" + host);
            }
            if (port != null) {
                vmArgs.add("-Dserver_port=" + port);
            }
        }
    }

    public static boolean isDebug() {
        return debug;
    }

    public static String getAdminId() {
        return adminId;
    }

    public static String getAdminPassword() {
        return adminPassword;
    }

    public static String getTrustStoreLocation() {
        return trustStoreLocation;
    }

    public static String getTrustStorePassword() {
        return trustStorePassword;
    }

    public static File getConnectionFile() {
        return hostPortFile;
    }

    public static File getLockFile() {
        return lockFile;
    }

    public static File getEclipseHome() {
        return eclipseHome;
    }

    public static File getWorkspace() {
        return workspace;
    }

    public static List getHelpCommand() {
        return helpCommand;
    }

    public static String[] getUpdateParameters() {
        return updateParameters;
    }

    public static List getEclipseArgs() {
        return eclipseArgs;
    }

    private static List extractOption(List options, String optionName) {
        ArrayList values = null;
        int i = 0;
        block0: while (i < options.size()) {
            if (optionName.equalsIgnoreCase((String)options.get(i))) {
                if (values == null) {
                    values = new ArrayList(1);
                }
                options.remove(i);
                while (i < options.size()) {
                    if (((String)options.get(i)).startsWith("-") && !optionName.equals("-vmargs")) continue block0;
                    values.add(options.get(i));
                    options.remove(i);
                }
                continue;
            }
            ++i;
        }
        return values;
    }

    private static List getOption(List options, String optionName) {
        ArrayList values = null;
        int i = 0;
        while (i < options.size()) {
            if (optionName.equalsIgnoreCase((String)options.get(i))) {
                if (values == null) {
                    values = new ArrayList(1);
                }
                int j = i + 1;
                while (j < options.size()) {
                    if (((String)options.get(j)).startsWith("-") && !optionName.equals("-vmargs")) {
                        i = j;
                        break;
                    }
                    values.add(options.get(j));
                    ++j;
                }
            }
            ++i;
        }
        return values;
    }

    public static String getVm() {
        return vm;
    }

    public static List getVmArgs() {
        return vmArgs;
    }

    public static boolean useExe() {
        return useExe;
    }
}

