/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.server;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class WebappManager {
    private static String host;
    private static int port;
    private static final int AUTO_SELECT_JETTY_PORT = 0;

    static {
        port = -1;
    }

    public static void start(String webappName) throws Exception {
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        WebappManager.configurePort();
        ((Dictionary)d).put("http.port", new Integer(WebappManager.getPortParameter()));
        ((Dictionary)d).put("context.path", "/help");
        ((Dictionary)d).put("other.info", "org.eclipse.help");
        Logger.getLogger("org.mortbay").setLevel(Level.WARNING);
        JettyConfigurator.startServer((String)webappName, d);
        WebappManager.checkBundle();
    }

    private static void checkBundle() throws InvalidSyntaxException, BundleException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.http.registry");
        if (bundle.getState() == 4) {
            bundle.start(1);
        }
        if (port == -1) {
            ServiceReference[] reference = bundle.getBundleContext().getServiceReferences("org.osgi.service.http.HttpService", "(other.info=org.eclipse.help)");
            Object assignedPort = reference[0].getProperty("http.port");
            port = Integer.parseInt((String)assignedPort);
        }
    }

    public static void stop(String webappName) throws CoreException {
        try {
            JettyConfigurator.stopServer((String)webappName);
        }
        catch (Exception e) {
            HelpBasePlugin.logError("An error occured while stopping the help server", e);
        }
    }

    public static int getPort() {
        return port;
    }

    private static void configurePort() {
        String portCommandLineOverride;
        if (port == -1 && (portCommandLineOverride = HelpBasePlugin.getBundleContext().getProperty("server_port")) != null && portCommandLineOverride.trim().length() > 0) {
            try {
                port = Integer.parseInt(portCommandLineOverride);
            }
            catch (NumberFormatException e) {
                String msg = "Help server port specified in VM arguments is invalid (" + portCommandLineOverride + ")";
                HelpBasePlugin.logError(msg, e);
            }
        }
    }

    private static int getPortParameter() {
        if (port == -1) {
            return 0;
        }
        return port;
    }

    public static String getHost() {
        if (host == null) {
            String hostCommandLineOverride = HelpBasePlugin.getBundleContext().getProperty("server_host");
            host = hostCommandLineOverride != null && hostCommandLineOverride.trim().length() > 0 ? hostCommandLineOverride : "127.0.0.1";
        }
        return host;
    }

    private WebappManager() {
    }
}

