/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.MemberValuePair;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class BinaryMember
extends NamedMember {
    protected BinaryMember(JavaElement parent, String name) {
        super(parent, name);
    }

    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    protected IAnnotation[] getAnnotations(IBinaryAnnotation[] binaryAnnotations) {
        if (binaryAnnotations == null) {
            return Annotation.NO_ANNOTATIONS;
        }
        int length = binaryAnnotations.length;
        IAnnotation[] annotations = new IAnnotation[length];
        int i = 0;
        while (i < length) {
            annotations[i] = this.getAnnotation(binaryAnnotations[i]);
            ++i;
        }
        return annotations;
    }

    private IAnnotation getAnnotation(IBinaryAnnotation binaryAnnotation) {
        IMemberValuePair[] members;
        IBinaryElementValuePair[] binaryElementValuePairs = binaryAnnotation.getElementValuePairs();
        int pairsLength = binaryElementValuePairs.length;
        if (pairsLength == 0) {
            members = Annotation.NO_MEMBER_VALUE_PAIRS;
        } else {
            members = new IMemberValuePair[pairsLength];
            int i = 0;
            while (i < pairsLength) {
                IBinaryElementValuePair binaryElementValuePair = binaryElementValuePairs[i];
                MemberValuePair memberValuePair = new MemberValuePair(new String(binaryElementValuePair.getName()));
                memberValuePair.value = this.getMemberValue(memberValuePair, binaryElementValuePair.getValue());
                members[i] = memberValuePair;
                ++i;
            }
        }
        char[] typeName = Signature.toCharArray(CharOperation.replaceOnCopy(binaryAnnotation.getTypeName(), '/', '.'));
        return new Annotation(this, new String(typeName)){

            public IMemberValuePair[] getMemberValuePairs() throws JavaModelException {
                return members;
            }
        };
    }

    protected Object getMemberValue(MemberValuePair memberValuePair, Object binaryValue) {
        if (binaryValue instanceof Constant) {
            return Util.getAnnotationMemberValue(memberValuePair, (Constant)binaryValue);
        }
        if (binaryValue instanceof IBinaryAnnotation) {
            memberValuePair.valueKind = 10;
            return this.getAnnotation((IBinaryAnnotation)binaryValue);
        }
        if (binaryValue instanceof ClassSignature) {
            memberValuePair.valueKind = 11;
            char[] className = Signature.toCharArray(CharOperation.replaceOnCopy(((ClassSignature)binaryValue).getTypeName(), '/', '.'));
            return new String(className);
        }
        if (binaryValue instanceof EnumConstantSignature) {
            memberValuePair.valueKind = 12;
            EnumConstantSignature enumConstant = (EnumConstantSignature)binaryValue;
            char[] enumName = Signature.toCharArray(CharOperation.replaceOnCopy(enumConstant.getTypeName(), '/', '.'));
            char[] qualifiedName = CharOperation.concat(enumName, enumConstant.getEnumConstantName(), '.');
            return new String(qualifiedName);
        }
        if (binaryValue instanceof Object[]) {
            memberValuePair.valueKind = -1;
            Object[] binaryValues = (Object[])binaryValue;
            int length = binaryValues.length;
            Object[] values = new Object[length];
            int i = 0;
            while (i < length) {
                int previousValueKind = memberValuePair.valueKind;
                Object value = this.getMemberValue(memberValuePair, binaryValues[i]);
                if (previousValueKind != -1 && memberValuePair.valueKind != previousValueKind) {
                    memberValuePair.valueKind = 14;
                }
                values[i] = value;
                ++i;
            }
            if (memberValuePair.valueKind == -1) {
                memberValuePair.valueKind = 14;
            }
            return values;
        }
        memberValuePair.valueKind = 14;
        return null;
    }

    public String[] getCategories() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            String[] categories;
            ((ClassFile)this.getClassFile()).getBuffer();
            if (mapper.categories != null && (categories = (String[])mapper.categories.get(this)) != null) {
                return categories;
            }
        }
        return CharOperation.NO_STRINGS;
    }

    public String getKey() {
        try {
            return this.getKey(false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public abstract String getKey(boolean var1) throws JavaModelException;

    public ISourceRange getNameRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            ((ClassFile)this.getClassFile()).getBuffer();
            return mapper.getNameRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            ((ClassFile)this.getClassFile()).getBuffer();
            return mapper.getSourceRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    public boolean isBinary() {
        return true;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return ((IJavaElement)((Object)this.getOpenableParent())).isStructureKnown();
    }

    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public void setContents(String contents, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }
}

