/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CodeFormatFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.IMultiLineCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jface.text.IRegion;

public class CodeFormatCleanUp
extends AbstractCleanUp {
    public CodeFormatCleanUp() {
    }

    public CodeFormatCleanUp(Map options) {
        super(options);
    }

    public ICleanUp.CleanUpRequirements getRequirements() {
        boolean requiresChangedRegions = this.isEnabled("cleanup.format_source_code") && this.isEnabled("cleanup.format_source_code_changes_only");
        return new ICleanUp.SaveActionRequirements(false, false, null, requiresChangedRegions);
    }

    public IFix createFix(ICleanUp.CleanUpContext context) throws CoreException {
        ICompilationUnit compilationUnit = context.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        IRegion[] regions = context instanceof IMultiLineCleanUp.MultiLineCleanUpContext ? ((IMultiLineCleanUp.MultiLineCleanUpContext)context).getRegions() : (IRegion[])null;
        boolean removeWhitespaces = this.isEnabled("cleanup.remove_trailing_whitespaces");
        return CodeFormatFix.createCleanUp(compilationUnit, regions, this.isEnabled("cleanup.format_source_code"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_all"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty"), this.isEnabled("cleanup.correct_indentation"));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.format_source_code")) {
            result.add(MultiFixMessages.CodeFormatCleanUp_description);
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            if (this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingAll_description);
            } else if (this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingNoEmpty_description);
            }
        }
        if (this.isEnabled("cleanup.correct_indentation")) {
            result.add(MultiFixMessages.CodeFormatCleanUp_correctIndentation_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("/**\n");
        buf.append(" *A Javadoc comment\n");
        buf.append("* @since 2007\n");
        buf.append(" */\n");
        buf.append("public class Engine {\n");
        buf.append("  public void start() {}\n");
        if (this.isEnabled("cleanup.remove_trailing_whitespaces") && this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
            buf.append("\n");
        } else {
            buf.append("    \n");
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            buf.append("    public\n");
        } else {
            buf.append("    public \n");
        }
        buf.append("        void stop() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        return buf.toString();
    }
}

