/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceParameterObjectDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.IDefaultValueAdvisor;
import org.eclipse.jdt.internal.corext.refactoring.structure.IntroduceParameterObjectProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ParameterObjectFactory;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class IntroduceParameterObjectProcessor
extends ChangeSignatureProcessor {
    private static final String PARAMETER_CLASS_APPENDIX = "Parameter";
    private static final String DEFAULT_PARAMETER_OBJECT_NAME = "parameterObject";
    private MethodDeclaration fMethodDeclaration;
    private ParameterObjectFactory fParameterObjectFactory;
    private boolean fCreateAsTopLevel = true;
    private ParameterInfo fParameterObjectReference;
    private List fOtherChanges;
    static /* synthetic */ Class class$0;

    private boolean isParameter(ParameterInfo pi, ASTNode node, List enclosingMethodParameters, String qualifier) {
        if (node instanceof Name) {
            Name name = (Name)node;
            IVariableBinding binding = ASTNodes.getVariableBinding(name);
            if (binding != null && binding.isParameter()) {
                return binding.getName().equals(this.getNameInScope(pi, enclosingMethodParameters));
            }
            if (node instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)node;
                return qn.getFullyQualifiedName().equals(JavaModelUtil.concatenateName(qualifier, this.getNameInScope(pi, enclosingMethodParameters)));
            }
        }
        return false;
    }

    public IntroduceParameterObjectProcessor(IntroduceParameterObjectDescriptor descriptor) throws JavaModelException {
        super(descriptor.getMethod());
        IMethod method = descriptor.getMethod();
        Assert.isNotNull((Object)method);
        this.initializeFields(method);
        this.setBodyUpdater(new RewriteParameterBody());
        this.setDefaultValueAdvisor(new ParameterObjectCreator());
        this.configureRefactoring(descriptor, this);
    }

    private void configureRefactoring(IntroduceParameterObjectDescriptor parameter, IntroduceParameterObjectProcessor ref) {
        ref.setCreateAsTopLevel(parameter.isTopLevel());
        ref.setCreateGetter(parameter.isGetters());
        ref.setCreateSetter(parameter.isSetters());
        ref.setDelegateUpdating(parameter.isDelegate());
        ref.setDeprecateDelegates(parameter.isDeprecateDelegate());
        if (parameter.getClassName() != null) {
            ref.setClassName(parameter.getClassName());
        }
        if (parameter.getPackageName() != null) {
            ref.setPackage(parameter.getPackageName());
        }
        if (parameter.getParameterName() != null) {
            ref.setParameterName(parameter.getParameterName());
        }
        List pis = ref.getParameterInfos();
        IntroduceParameterObjectDescriptor.Parameter[] parameters = parameter.getParameters();
        if (parameters == null) {
            parameters = IntroduceParameterObjectDescriptor.createParameters((IMethod)this.getMethod());
        }
        HashMap<Integer, ParameterInfo> paramIndex = new HashMap<Integer, ParameterInfo>();
        Iterator iter = pis.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            paramIndex.put(new Integer(pi.getOldIndex()), pi);
        }
        paramIndex.put(new Integer(-1), this.fParameterObjectReference);
        pis.clear();
        int i = 0;
        while (i < parameters.length) {
            IntroduceParameterObjectDescriptor.Parameter param = parameters[i];
            ParameterInfo pi = (ParameterInfo)paramIndex.get(new Integer(param.getIndex()));
            pis.add(pi);
            if (param != IntroduceParameterObjectDescriptor.PARAMETER_OBJECT) {
                String fieldName;
                pi.setCreateField(param.isCreateField());
                if (pi.isCreateField() && (fieldName = param.getFieldName()) != null) {
                    pi.setNewName(fieldName);
                }
            }
            ++i;
        }
    }

    private void initializeFields(IMethod method) {
        this.fParameterObjectFactory = new ParameterObjectFactory();
        String methodName = method.getElementName();
        String className = String.valueOf(Character.toUpperCase(methodName.charAt(0)));
        if (methodName.length() > 1) {
            className = String.valueOf(className) + methodName.substring(1);
        }
        className = String.valueOf(className) + PARAMETER_CLASS_APPENDIX;
        this.fParameterObjectReference = ParameterInfo.createInfoForAddedParameter(className, DEFAULT_PARAMETER_OBJECT_NAME);
        this.fParameterObjectFactory.setClassName(className);
        IType declaringType = method.getDeclaringType();
        Assert.isNotNull((Object)declaringType);
        this.fParameterObjectFactory.setPackage(declaringType.getPackageFragment().getElementName());
        this.updateReferenceType();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IMethod method = this.getMethod();
        status.merge(Checks.checkTypeName(this.fParameterObjectFactory.getClassName(), (IJavaElement)method));
        status.merge(Checks.checkIdentifier(this.getParameterName(), (IJavaElement)method));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(super.checkFinalConditions(pm, context));
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ISourceRange nameRange;
        RefactoringStatus status = new RefactoringStatus();
        status.merge(super.checkInitialConditions(pm));
        if (status.hasFatalError()) {
            return status;
        }
        CompilationUnit astRoot = this.getBaseCuRewrite().getRoot();
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (nameRange = this.getMethod().getNameRange()).getOffset(), nameRange.getLength());
        if (selectedNode == null) {
            return this.mappingErrorFound(status, selectedNode);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent(selectedNode, clazz);
        if (this.fMethodDeclaration == null) {
            return this.mappingErrorFound(status, selectedNode);
        }
        IMethodBinding resolveBinding = this.fMethodDeclaration.resolveBinding();
        if (resolveBinding == null) {
            if (!this.processCompilerError(status, selectedNode)) {
                status.addFatalError(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_error_cannot_resolve_type);
            }
            return status;
        }
        ITypeBinding declaringClass = resolveBinding.getDeclaringClass();
        if (this.fParameterObjectFactory.getPackage() == null) {
            this.fParameterObjectFactory.setPackage(declaringClass.getPackage().getName());
        }
        if (this.fParameterObjectFactory.getEnclosingType() == null) {
            this.fParameterObjectFactory.setEnclosingType(declaringClass.getQualifiedName());
        }
        List parameterInfos = super.getParameterInfos();
        Iterator iter = parameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (pi.isAdded() || !pi.getOldName().equals(pi.getNewName())) continue;
            pi.setNewName(this.getFieldName(pi));
        }
        if (!parameterInfos.contains(this.fParameterObjectReference)) {
            parameterInfos.add(0, this.fParameterObjectReference);
        }
        HashMap<String, IVariableBinding> bindingMap = new HashMap<String, IVariableBinding>();
        Iterator iter2 = this.fMethodDeclaration.parameters().iterator();
        while (iter2.hasNext()) {
            SingleVariableDeclaration sdv = (SingleVariableDeclaration)iter2.next();
            bindingMap.put(sdv.getName().getIdentifier(), sdv.resolveBinding());
        }
        iter2 = parameterInfos.iterator();
        while (iter2.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter2.next();
            if (pi == this.fParameterObjectReference) continue;
            pi.setOldBinding((IVariableBinding)bindingMap.get(pi.getOldName()));
        }
        this.fParameterObjectFactory.setVariables(parameterInfos);
        return status;
    }

    protected boolean shouldReport(IProblem problem, CompilationUnit cu) {
        if (!super.shouldReport(problem, cu)) {
            return false;
        }
        ASTNode node = ASTNodeSearchUtil.getAstNode(cu, problem.getSourceStart(), problem.getSourceEnd() - problem.getSourceStart());
        if (node instanceof Type) {
            Type type = (Type)node;
            if (problem.getID() == 0x1000002 && this.getClassName().equals(ASTNodes.getTypeName(type))) {
                return false;
            }
        }
        if (node instanceof Name) {
            Name name = (Name)node;
            if (problem.getID() == 268435846 && this.getPackage().indexOf(name.getFullyQualifiedName()) != -1) {
                return false;
            }
        }
        return true;
    }

    public String getClassName() {
        return this.fParameterObjectFactory.getClassName();
    }

    public ITypeBinding getContainingClass() {
        return this.fMethodDeclaration.resolveBinding().getDeclaringClass();
    }

    private String getMappingErrorMessage() {
        return RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotalanyzemethod_mappingerror;
    }

    public String getFieldName(ParameterInfo element) {
        IJavaProject javaProject = this.getCompilationUnit().getJavaProject();
        String stripped = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)javaProject, (String)element.getOldName());
        int dim = element.getNewTypeBinding() != null ? element.getNewTypeBinding().getDimensions() : 0;
        return StubUtility.getVariableNameSuggestions(2, javaProject, stripped, dim, null, true)[0];
    }

    public Change[] getAllChanges() {
        ArrayList<Change> changes = new ArrayList<Change>();
        changes.addAll(Arrays.asList(super.getAllChanges()));
        changes.addAll(this.fOtherChanges);
        return changes.toArray(new Change[changes.size()]);
    }

    protected void clearManagers() {
        super.clearManagers();
        this.fOtherChanges = new ArrayList();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.IntroduceParameterObjectRefactoring_refactoring_name;
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.introduceParameterObjectRefactoring";
    }

    public JavaRefactoringDescriptor createDescriptor() {
        IntroduceParameterObjectDescriptor ipod = new IntroduceParameterObjectDescriptor();
        ipod.setMethod(this.getMethod());
        ipod.setClassName(this.getClassName());
        ipod.setDelegate(this.getDelegateUpdating());
        ipod.setDeprecateDelegate(this.getDeprecateDelegates());
        ipod.setGetters(this.isCreateGetter());
        ipod.setSetters(this.isCreateSetter());
        ipod.setPackageName(this.getPackage());
        ipod.setParameterName(this.getParameterName());
        ipod.setTopLevel(this.isCreateAsTopLevel());
        ArrayList<IntroduceParameterObjectDescriptor.Parameter> parameters = new ArrayList<IntroduceParameterObjectDescriptor.Parameter>();
        List pis = this.getParameterInfos();
        Iterator iter = pis.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (pi.isAdded()) {
                parameters.add(IntroduceParameterObjectDescriptor.PARAMETER_OBJECT);
                continue;
            }
            IntroduceParameterObjectDescriptor.Parameter parameter = new IntroduceParameterObjectDescriptor.Parameter(pi.getOldIndex());
            if (pi.isCreateField()) {
                parameter.setCreateField(true);
                parameter.setFieldName(pi.getNewName());
            }
            parameters.add(parameter);
        }
        ipod.setParameters(parameters.toArray(new IntroduceParameterObjectDescriptor.Parameter[parameters.size()]));
        String project = this.getCompilationUnit().getJavaProject().getElementName();
        try {
            ipod.setComment(this.createComment(project).asString());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        ipod.setProject(project);
        ipod.setDescription(this.getProcessorName());
        ipod.setFlags(this.getDescriptorFlags());
        return ipod;
    }

    private JDTRefactoringDescriptorComment createComment(String project) throws JavaModelException {
        String header = Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_description, this.getOldMethodSignature());
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_object_class, BasicElementLabels.getJavaElementName(this.fParameterObjectFactory.getClassName())));
        if (this.fCreateAsTopLevel) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_package, BasicElementLabels.getJavaElementName(this.fParameterObjectFactory.getPackage())));
        } else {
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_enclosing_type, BasicElementLabels.getJavaElementName(this.fParameterObjectFactory.getEnclosingType())));
        }
        List infos = this.getParameterInfos();
        ArrayList<String> kept = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        Iterator iter = infos.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (pi.isCreateField()) {
                fields.add(pi.getNewName());
                continue;
            }
            if (pi.isAdded()) continue;
            kept.add(pi.getNewName());
        }
        comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_fields, fields.toArray(new String[0])));
        if (!kept.isEmpty()) {
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_keep_parameter, kept.toArray(new String[0])));
        }
        if (this.fParameterObjectFactory.isCreateGetter()) {
            comment.addSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_create_getter);
        }
        if (this.fParameterObjectFactory.isCreateSetter()) {
            comment.addSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_create_setter);
        }
        return comment;
    }

    protected String doGetRefactoringChangeName() {
        return this.getProcessorName();
    }

    public String getParameterName() {
        return this.fParameterObjectReference.getNewName();
    }

    public boolean isCreateGetter() {
        return this.fParameterObjectFactory.isCreateGetter();
    }

    public boolean isCreateSetter() {
        return this.fParameterObjectFactory.isCreateSetter();
    }

    public boolean isCreateAsTopLevel() {
        return this.fCreateAsTopLevel;
    }

    private boolean isValidField(ParameterInfo pi) {
        return pi.isCreateField() & !pi.isAdded();
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    public void moveFieldDown(ParameterInfo selected) {
        this.fParameterObjectFactory.moveDown(selected);
    }

    public void moveFieldUp(ParameterInfo selected) {
        this.fParameterObjectFactory.moveUp(selected);
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotanalysemethod_compilererror, new String[]{messages[0].getMessage()}));
        return true;
    }

    public void setClassName(String className) {
        this.fParameterObjectFactory.setClassName(className);
        this.updateReferenceType();
    }

    private void updateReferenceType() {
        if (this.fCreateAsTopLevel) {
            this.fParameterObjectReference.setNewTypeName(JavaModelUtil.concatenateName(this.fParameterObjectFactory.getPackage(), this.fParameterObjectFactory.getClassName()));
        } else {
            this.fParameterObjectReference.setNewTypeName(JavaModelUtil.concatenateName(this.fParameterObjectFactory.getEnclosingType(), this.fParameterObjectFactory.getClassName()));
        }
    }

    public void setCreateGetter(boolean createGetter) {
        this.fParameterObjectFactory.setCreateGetter(createGetter);
    }

    public void setCreateSetter(boolean createSetter) {
        this.fParameterObjectFactory.setCreateSetter(createSetter);
    }

    public void setPackageName(String packageName) {
        this.fParameterObjectFactory.setPackage(packageName);
        this.updateReferenceType();
    }

    public void setParameterName(String paramName) {
        this.fParameterObjectReference.setNewName(paramName);
    }

    public void setCreateAsTopLevel(boolean topLevel) {
        this.fCreateAsTopLevel = topLevel;
        this.updateReferenceType();
    }

    public void updateParameterPosition() {
        this.fParameterObjectFactory.updateParameterPosition(this.fParameterObjectReference);
    }

    private void createParameterClass(MethodDeclaration methodDeclaration, CompilationUnitRewrite cuRewrite) throws CoreException {
        if (this.fCreateAsTopLevel) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)cuRewrite.getCu().getAncestor(3);
            this.fOtherChanges.addAll(this.fParameterObjectFactory.createTopLevelParameterObject(root));
        } else {
            ASTRewrite rewriter = cuRewrite.getASTRewrite();
            TypeDeclaration enclosingType = (TypeDeclaration)methodDeclaration.getParent();
            ListRewrite bodyRewrite = rewriter.getListRewrite((ASTNode)enclosingType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            String fqn = enclosingType.getName().getFullyQualifiedName();
            TypeDeclaration classDeclaration = this.fParameterObjectFactory.createClassDeclaration(fqn, cuRewrite, null);
            classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
            bodyRewrite.insertBefore((ASTNode)classDeclaration, (ASTNode)methodDeclaration, null);
        }
    }

    public String getPackage() {
        return this.fParameterObjectFactory.getPackage();
    }

    public void setPackage(String typeQualifier) {
        this.fParameterObjectFactory.setPackage(typeQualifier);
    }

    private String getNameInScope(ParameterInfo pi, List enclosingMethodParameters) {
        boolean emptyVararg;
        Assert.isNotNull((Object)enclosingMethodParameters);
        boolean bl = emptyVararg = pi.getOldIndex() >= enclosingMethodParameters.size();
        if (!emptyVararg) {
            SingleVariableDeclaration svd = (SingleVariableDeclaration)enclosingMethodParameters.get(pi.getOldIndex());
            return svd.getName().getIdentifier();
        }
        return null;
    }

    public String getNewTypeName() {
        return this.fParameterObjectReference.getNewTypeName();
    }

    public ICompilationUnit getCompilationUnit() {
        return this.getBaseCuRewrite().getCu();
    }

    protected int getDescriptorFlags() {
        return super.getDescriptorFlags() | 0x40000;
    }

    private final class ParameterObjectCreator
    implements IDefaultValueAdvisor {
        private ParameterObjectCreator() {
        }

        public Expression createDefaultExpression(List invocationArguments, ParameterInfo addedInfo, List parameterInfos, MethodDeclaration enclosingMethod, boolean isRecursive, CompilationUnitRewrite cuRewrite) {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            if (isRecursive && this.canReuseParameterObject(invocationArguments, addedInfo, parameterInfos, enclosingMethod)) {
                return ast.newSimpleName(addedInfo.getNewName());
            }
            ClassInstanceCreation classCreation = ast.newClassInstanceCreation();
            int startPosition = enclosingMethod != null ? enclosingMethod.getStartPosition() : cuRewrite.getRoot().getStartPosition();
            classCreation.setType(IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createType(IntroduceParameterObjectProcessor.this.fCreateAsTopLevel, cuRewrite, startPosition));
            List constructorArguments = classCreation.arguments();
            Iterator iter = parameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter.next();
                if (!IntroduceParameterObjectProcessor.this.isValidField(pi)) continue;
                if (pi.isOldVarargs()) {
                    boolean isLastParameter = !iter.hasNext();
                    constructorArguments.addAll(this.computeVarargs(invocationArguments, pi, isLastParameter, cuRewrite));
                    continue;
                }
                Expression exp = (Expression)invocationArguments.get(pi.getOldIndex());
                this.importNodeTypes((ASTNode)exp, cuRewrite);
                constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode((ASTNode)exp, rewrite));
            }
            return classCreation;
        }

        public Type createType(String newTypeName, int startPosition, CompilationUnitRewrite cuRewrite) {
            return IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createType(IntroduceParameterObjectProcessor.this.fCreateAsTopLevel, cuRewrite, startPosition);
        }

        private boolean canReuseParameterObject(List invocationArguments, ParameterInfo addedInfo, List parameterInfos, MethodDeclaration enclosingMethod) {
            Assert.isNotNull((Object)enclosingMethod);
            List parameters = enclosingMethod.parameters();
            Iterator iter = parameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter.next();
                if (!IntroduceParameterObjectProcessor.this.isValidField(pi)) continue;
                if (!pi.isInlined()) {
                    return false;
                }
                ASTNode node = (ASTNode)invocationArguments.get(pi.getOldIndex());
                if (IntroduceParameterObjectProcessor.this.isParameter(pi, node, parameters, addedInfo.getNewName())) continue;
                return false;
            }
            return true;
        }

        private List computeVarargs(List invocationArguments, ParameterInfo varArgPI, boolean isLastParameter, CompilationUnitRewrite cuRewrite) {
            ArrayCreation creation;
            ITypeBinding arrayType;
            boolean isEmptyVarArg = varArgPI.getOldIndex() >= invocationArguments.size();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getAST();
            ASTNode lastNode = isEmptyVarArg ? null : (ASTNode)invocationArguments.get(varArgPI.getOldIndex());
            ArrayList<Object> constructorArguments = new ArrayList<Object>();
            if (lastNode instanceof ArrayCreation && (arrayType = (creation = (ArrayCreation)lastNode).resolveTypeBinding()) != null && arrayType.isAssignmentCompatible(varArgPI.getNewTypeBinding())) {
                constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode((ASTNode)creation, rewrite));
                return constructorArguments;
            }
            if (isLastParameter) {
                int i = varArgPI.getOldIndex();
                while (i < invocationArguments.size()) {
                    ASTNode node = (ASTNode)invocationArguments.get(i);
                    this.importNodeTypes(node, cuRewrite);
                    constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode(node, rewrite));
                    ++i;
                }
            } else if (lastNode instanceof NullLiteral) {
                NullLiteral nullLiteral = (NullLiteral)lastNode;
                constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode((ASTNode)nullLiteral, rewrite));
            } else {
                creation = ast.newArrayCreation();
                creation.setType((ArrayType)this.importBinding(varArgPI.getNewTypeBinding(), cuRewrite));
                ArrayInitializer initializer = ast.newArrayInitializer();
                List expressions = initializer.expressions();
                int i = varArgPI.getOldIndex();
                while (i < invocationArguments.size()) {
                    ASTNode node = (ASTNode)invocationArguments.get(i);
                    this.importNodeTypes(node, cuRewrite);
                    expressions.add(IntroduceParameterObjectProcessor.this.moveNode(node, rewrite));
                    ++i;
                }
                if (expressions.isEmpty()) {
                    creation.dimensions().add(ast.newNumberLiteral("0"));
                } else {
                    creation.setInitializer(initializer);
                }
                constructorArguments.add(creation);
            }
            return constructorArguments;
        }

        public Type importBinding(ITypeBinding newTypeBinding, CompilationUnitRewrite cuRewrite) {
            Type type = cuRewrite.getImportRewrite().addImport(newTypeBinding, cuRewrite.getAST());
            cuRewrite.getImportRemover().registerAddedImports(type);
            return type;
        }

        private void importNodeTypes(ASTNode node, CompilationUnitRewrite cuRewrite) {
            ASTResolving.visitAllBindings(node, new TypeBindingVisitor(this, cuRewrite){
                final /* synthetic */ ParameterObjectCreator this$1;
                private final /* synthetic */ CompilationUnitRewrite val$cuRewrite;
                {
                    this.this$1 = parameterObjectCreator;
                    this.val$cuRewrite = compilationUnitRewrite;
                }

                public boolean visit(ITypeBinding nodeBinding) {
                    this.this$1.importBinding(nodeBinding, this.val$cuRewrite);
                    return false;
                }
            });
        }
    }

    private final class RewriteParameterBody
    extends BodyUpdater {
        private boolean fParameterClassCreated = false;

        private RewriteParameterBody() {
        }

        public void updateBody(MethodDeclaration methodDeclaration, CompilationUnitRewrite cuRewrite, RefactoringStatus result) throws CoreException {
            IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createType(IntroduceParameterObjectProcessor.this.fCreateAsTopLevel, cuRewrite, methodDeclaration.getStartPosition());
            if (cuRewrite.getCu().equals(IntroduceParameterObjectProcessor.this.getCompilationUnit()) && !this.fParameterClassCreated) {
                IntroduceParameterObjectProcessor.this.createParameterClass(methodDeclaration, cuRewrite);
                this.fParameterClassCreated = true;
            }
            Block body = methodDeclaration.getBody();
            List parameters = methodDeclaration.parameters();
            if (body != null) {
                ASTRewrite rewriter = cuRewrite.getASTRewrite();
                ListRewrite bodyStatements = rewriter.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                List managedParams = IntroduceParameterObjectProcessor.this.getParameterInfos();
                Iterator iter = managedParams.iterator();
                while (iter.hasNext()) {
                    ParameterInfo pi = (ParameterInfo)iter.next();
                    if (!IntroduceParameterObjectProcessor.this.isValidField(pi)) continue;
                    if (this.isReadOnly(pi, body, parameters, null)) {
                        body.accept(new ASTVisitor(this, false, rewriter, pi, parameters, cuRewrite){
                            final /* synthetic */ RewriteParameterBody this$1;
                            private final /* synthetic */ ASTRewrite val$rewriter;
                            private final /* synthetic */ ParameterInfo val$pi;
                            private final /* synthetic */ List val$parameters;
                            private final /* synthetic */ CompilationUnitRewrite val$cuRewrite;
                            {
                                this.this$1 = rewriteParameterBody;
                                this.val$rewriter = aSTRewrite;
                                this.val$pi = parameterInfo;
                                this.val$parameters = list;
                                this.val$cuRewrite = compilationUnitRewrite;
                            }

                            public boolean visit(SimpleName node) {
                                RewriteParameterBody.access$0(this.this$1, this.val$rewriter, this.val$pi, node, this.val$parameters, this.val$cuRewrite.getCu().getJavaProject());
                                return false;
                            }
                        });
                        pi.setInlined(true);
                        continue;
                    }
                    ExpressionStatement initializer = IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createInitializer(pi, IntroduceParameterObjectProcessor.this.getParameterName(), cuRewrite);
                    bodyStatements.insertFirst((ASTNode)initializer, null);
                }
            }
        }

        private void updateSimpleName(ASTRewrite rewriter, ParameterInfo pi, SimpleName node, List enclosingParameters, IJavaProject project) {
            AST ast = rewriter.getAST();
            IBinding binding = node.resolveBinding();
            Expression replacementNode = IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createFieldReadAccess(pi, IntroduceParameterObjectProcessor.this.getParameterName(), ast, project, false, null);
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                if (variable.isParameter() && variable.getName().equals(IntroduceParameterObjectProcessor.this.getNameInScope(pi, enclosingParameters))) {
                    rewriter.replace((ASTNode)node, (ASTNode)replacementNode, null);
                }
            } else {
                ASTNode parent = node.getParent();
                if (!(parent instanceof QualifiedName) && !(parent instanceof FieldAccess) && !(parent instanceof SuperFieldAccess) && node.getIdentifier().equals(IntroduceParameterObjectProcessor.this.getNameInScope(pi, enclosingParameters))) {
                    rewriter.replace((ASTNode)node, (ASTNode)replacementNode, null);
                }
            }
        }

        private boolean isReadOnly(ParameterInfo pi, Block block, List enclosingMethodParameters, String qualifier) {
            class NotWrittenDetector
            extends ASTVisitor {
                boolean notWritten;
                final /* synthetic */ RewriteParameterBody this$1;
                private final /* synthetic */ ParameterInfo val$pi;
                private final /* synthetic */ List val$enclosingMethodParameters;
                private final /* synthetic */ String val$qualifier;

                NotWrittenDetector(RewriteParameterBody rewriteParameterBody, ParameterInfo parameterInfo, List list, String string) {
                    this.this$1 = rewriteParameterBody;
                    this.val$pi = parameterInfo;
                    this.val$enclosingMethodParameters = list;
                    this.val$qualifier = string;
                    this.notWritten = true;
                }

                public boolean visit(SimpleName node) {
                    if (IntroduceParameterObjectProcessor.access$3(RewriteParameterBody.access$2(this.this$1), this.val$pi, (ASTNode)node, this.val$enclosingMethodParameters, this.val$qualifier) && ASTResolving.isWriteAccess((Name)node)) {
                        this.notWritten = false;
                    }
                    return false;
                }

                public boolean visit(SuperFieldAccess node) {
                    return false;
                }
            }
            NotWrittenDetector visitor = new NotWrittenDetector(this, pi, enclosingMethodParameters, qualifier);
            block.accept((ASTVisitor)visitor);
            return visitor.notWritten;
        }

        public boolean needsParameterUsedCheck() {
            return false;
        }

        static /* synthetic */ void access$0(RewriteParameterBody rewriteParameterBody, ASTRewrite aSTRewrite, ParameterInfo parameterInfo, SimpleName simpleName, List list, IJavaProject iJavaProject) {
            rewriteParameterBody.updateSimpleName(aSTRewrite, parameterInfo, simpleName, list, iJavaProject);
        }

        static /* synthetic */ IntroduceParameterObjectProcessor access$2(RewriteParameterBody rewriteParameterBody) {
            return rewriteParameterBody.IntroduceParameterObjectProcessor.this;
        }
    }
}

