/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class GroupChat {
    private XMPPConnection connection;
    private String room;
    private String nickname = null;
    private boolean joined = false;
    private List participants = new ArrayList();
    private List connectionListeners = new ArrayList();
    private PacketFilter presenceFilter;
    private PacketFilter messageFilter;
    private PacketCollector messageCollector;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GroupChat(XMPPConnection connection, String room) {
        this.connection = connection;
        this.room = room;
        FromContainsFilter fromContainsFilter = new FromContainsFilter(room);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jivesoftware.smack.packet.Message");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageFilter = new AndFilter(fromContainsFilter, new PacketTypeFilter(clazz));
        this.messageFilter = new AndFilter(this.messageFilter, new PacketFilter(){

            public boolean accept(Packet packet) {
                Message msg = (Message)packet;
                return msg.getType() == Message.Type.GROUP_CHAT;
            }
        });
        this.messageCollector = connection.createPacketCollector(this.messageFilter);
        FromContainsFilter fromContainsFilter2 = new FromContainsFilter(room);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.jivesoftware.smack.packet.Presence");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.presenceFilter = new AndFilter(fromContainsFilter2, new PacketTypeFilter(clazz2));
        connection.addPacketListener(new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                String from = presence.getFrom();
                if (presence.getType() == Presence.Type.AVAILABLE) {
                    List list = GroupChat.this.participants;
                    synchronized (list) {
                        if (!GroupChat.this.participants.contains(from)) {
                            GroupChat.this.participants.add(from);
                        }
                    }
                }
                if (presence.getType() == Presence.Type.UNAVAILABLE) {
                    List list = GroupChat.this.participants;
                    synchronized (list) {
                        GroupChat.this.participants.remove(from);
                    }
                }
            }
        }, this.presenceFilter);
    }

    public String getRoom() {
        return this.room;
    }

    public synchronized void join(String nickname) throws XMPPException {
        this.join(nickname, SmackConfiguration.getPacketReplyTimeout());
    }

    public synchronized void join(String nickname, long timeout) throws XMPPException {
        if (nickname == null || nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (this.joined) {
            this.leave();
        }
        Presence joinPresence = new Presence(Presence.Type.AVAILABLE);
        joinPresence.setTo(String.valueOf(this.room) + "/" + nickname);
        FromContainsFilter fromContainsFilter = new FromContainsFilter(String.valueOf(this.room) + "/" + nickname);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jivesoftware.smack.packet.Presence");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AndFilter responseFilter = new AndFilter(fromContainsFilter, new PacketTypeFilter(clazz));
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        Presence presence = (Presence)response.nextResult(timeout);
        response.cancel();
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = nickname;
        this.joined = true;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() {
        if (!this.joined) {
            return;
        }
        Presence leavePresence = new Presence(Presence.Type.UNAVAILABLE);
        leavePresence.setTo(String.valueOf(this.room) + "/" + this.nickname);
        this.connection.sendPacket(leavePresence);
        this.participants = new ArrayList();
        this.nickname = null;
        this.joined = false;
    }

    public String getNickname() {
        return this.nickname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParticipantCount() {
        List list = this.participants;
        synchronized (list) {
            return this.participants.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getParticipants() {
        List list = this.participants;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.participants)).iterator();
        }
    }

    public void addParticipantListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.presenceFilter);
        this.connectionListeners.add(listener);
    }

    public void sendMessage(String text) throws XMPPException {
        Message message = new Message(this.room, Message.Type.GROUP_CHAT);
        message.setBody(text);
        this.connection.sendPacket(message);
    }

    public Message createMessage() {
        return new Message(this.room, Message.Type.GROUP_CHAT);
    }

    public void sendMessage(Message message) throws XMPPException {
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public void addMessageListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.messageFilter);
        this.connectionListeners.add(listener);
    }

    public void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.messageCollector != null) {
                this.messageCollector.cancel();
            }
            Iterator it = this.connectionListeners.iterator();
            while (it.hasNext()) {
                this.connection.removePacketListener((PacketListener)it.next());
            }
        }
        catch (Exception exception) {}
    }
}

