#################################################################
#
# XML_utils.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: XML_utils.py,v 1.3 2004/08/30 13:26:09 svensson Exp $
#
# Revision history:
#
# 110203: O. Svensson (svensson@esrf.fr)
#         Added header
#
#################################################################

import pyxie, dna_httplib, os, string, re

class XML_utils:

  def __init__(self):
    pass

  def __call__(self):
    return self

  def PyxieTreeToDict(self, t):
    dict = {}
    for node in t.Children():
      if isinstance(node,pyxie.xElement):
        elementTypeName = node.ElementTypeName
        t.Seek(node)
        if elementTypeName in dict.keys():
         if type(dict[elementTypeName]) == type([]):
           dict[elementTypeName].append(self.PyxieTreeToDict(t))
         else:
           dict[elementTypeName] = [dict[elementTypeName],self.PyxieTreeToDict(t)]
        else:
          dict[elementTypeName] = self.PyxieTreeToDict(t)
      else:  
        t.Down()
        return t.Data
    return dict

  def XMLStringToDict(self, xml_string):
    #
    #
    #
    if xml_string is None:
      return {}
    if xml_string == "":
      return {}
    #
    # Remove spaces between > and <
    #
    tmp_string = string.replace(xml_string, '\n', '')
    p = re.compile("\>[ ]*\<")
    xml_string_cleaned = p.sub('><', tmp_string)
    #
    #
    #
    t = pyxie.String2xTree(xml_string_cleaned)
    topnode = t[0]
    topelement = topnode.ElementTypeName
    dict = {}
    dict[topelement] = self.PyxieTreeToDict(t)
    return dict


  def DictToXML(self, dict, doctype = "", first=1):
    if first:
      XML = '<?xml version="1.0"?>'
      if doctype != "":
        if doctype[0] == "/":
          doctype = doctype[1:]
        XML += '<!DOCTYPE %s>'%(doctype)
    else:
      XML = ""
    for element in dict.keys():
      if type(dict[element]) == type({}):
         XML += '<'+element+'>'
         XML += self.DictToXML(dict[element], first=0)
         XML += '</'+element+'>'
      elif type(dict[element]) == type([]):
         for subelement in dict[element]:
            XML += '<'+element+'>'
            if type(subelement) == type({}):
               XML += self.DictToXML(subelement, first=0)
            elif type(subelement) == type("string"):
               XML += subelement
            elif type(subelement) == type(1):
               XML += '%d'%(subelement)
            elif type(subelement) == type(1.0):
               XML += '%f'%(subelement)
            XML += '</'+element+'>'
      elif type(dict[element]) == type("string"):
         XML += '<'+element+'>'+dict[element]+'</'+element+'>'
      elif type(dict[element]) == type(1):
         XML += '<'+element+'>'+'%d'%(dict[element])+'</'+element+'>'
      elif type(dict[element]) == type(1.0):
         XML += '<'+element+'>'+'%f'%(dict[element])+'</'+element+'>'
    return XML

         
  def http_post(self, server_name, port, path, message):
    h = dna_httplib.HTTP("%s:%d"%(server_name, port))
    h.putrequest("POST", path)
    h.putheader("Content-type", "text/xml")
    h.putheader("Content-length", "%d" % len(message))
    h.putheader('Accept', 'text/plain')
    if "HOSTNAME" in os.environ.keys():
      h.putheader('Host', os.environ["HOSTNAME"])
    h.endheaders()
    h.send(message)
    reply, msg, hdrs = h.getreply()
    word = hdrs.getrawheader("Content-Length")
    if word is None:
      errmsg =  "Severe error in XML_utils.http_post - no header returned for %s, host %s, port %d!" % \
               (path, server_name, port)
      print errmsg
      raise RuntimeError, errmsg
    try:
      length = string.atoi(word)
    except:
      errmsg =  "Severe error in XML_utils.http_post - cannot convert Content-Length %s to integer for %s, host %s, port %d!" % \
               (word, path, server_name, port)
      print errmsg
      raise RuntimeError, errmsg      
    data = h.getfile().read(length)
    return data


  def xml_with_indentations(self, xml_string):
    #
    # First clean the string
    #
    # Remove spaces between > and <
    #
    tmp_string = string.replace(xml_string, '\\n', '')
    p = re.compile("\\>[ ]*\\<")
    xml_string_cleaned = p.sub('><', tmp_string)
    index = 0
    len_xml_string = len(xml_string_cleaned)
    new_xml_string = ""
    no_spaces = 0
    while (index < len_xml_string):
      extra_char = ""
      if xml_string_cleaned[index:index+5] == "<?xml":
        pass
        #        no_spaces = no_spaces - 2
      elif xml_string_cleaned[index:index+2] == "</":
        pass
      elif xml_string_cleaned[index] == "<":
        no_spaces = no_spaces + 2
      elif xml_string_cleaned[index] == ">":
        index2 = index
        while (index2 < len_xml_string):
          if xml_string_cleaned[index2:index2+3] == "></":
            extra_char = "\n"
            no_spaces = no_spaces - 2
            index2 = len_xml_string
          elif xml_string_cleaned[index2:index2+2] == "</":
            extra_char = ""
            index2 = len_xml_string
            no_spaces = no_spaces - 2
          elif xml_string_cleaned[index2] == "<":
            extra_char = "\n"
            index2 = len_xml_string
          index2 = index2+1
      if extra_char != "":
        spaces = ""
        for i in range(no_spaces):
          spaces = spaces+" "
        extra_char = extra_char + spaces
      new_xml_string = new_xml_string + xml_string_cleaned[index] + extra_char
      index = index+1
    new_xml_string = new_xml_string + "\n"
    return new_xml_string
    
  



XML_utils = XML_utils()


