#################################################################
#
# WriteXSD.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: WriteXSD.py,v 1.31 2006/06/09 08:56:59 svensson Exp $
#
# This program reads XML Schema Definition files (xsd) and
# produces a file called "XSD.py" that contains objects
# that corresponds to the xsd:complexType deifinitions.
#
# Be aware that far from all XSD definitions are supported.
#
# xsd:simpleTypes are translated to basic types, i.e. the
# restrictions are not mirrored.
#
#################################################################

import string, re, pyxie, pprint

xsd_files = ["dna_common.xsd", \
             "dna_collect.xsd", \
             "dna_index.xsd", \
             "dna_strategy.xsd", \
             "dna_kappastrategy.xsd", \
             "dna_integrate.xsd", \
             "dna_gui.xsd", \
             "dna_config.xsd", \
             "dna_sortmtz.xsd", \
             "dna_scala.xsd", \
             "dna_scale.xsd", \
             "ispyb.xsd", \
             "dna_db.xsd", \
             ]

xsd_dict = {}
xsd_list = {}
xsd_simple_type_dict = {}

def capitalizeFirstLetter( _ostr ):
    value = None
    if not _ostr is None:
        if len( _ostr ) > 1:
            value = string.capitalize( _ostr[0] ) + _ostr[1:]
        else:
            value = string.capitalize( _ostr )
    return value


for xsd_file in xsd_files:
    #
    #
    #
    print 'Parsing file: %s' % xsd_file
    file = open("../%s"%(xsd_file))
    xml_string = file.read()
    file.close()
    #
    #
    #
    tmp_string = string.replace(xml_string, '\n', '')
    p = re.compile("\>[ ]*\<")
    xml_string_cleaned = p.sub('><', tmp_string)
    #
    #
    #
    t = pyxie.String2xTree(xml_string_cleaned)
    t.Down()
    flag = 1
    while flag:
        if t.ElementTypeName == "xsd:complexType":
            name = t.AttributeValues["name"]
            element_flag = 1
            element_dict = {}
            element_list = [name]
            while t.ElementTypeName != "xsd:element":
                if t.HasDown():
                    t.Down()
                else:
                    element_flag = 0
                    element_dict = {"dummy_value": ["xsd:string", "0", "1"]}
                    break
            while element_flag:
                element_name = t.AttributeValues["name"]
                element_list.append(element_name)
                if "minOccurs" in t.AttributeValues.keys():
                    minOccurs = t.AttributeValues["minOccurs"]
                else:
                    minOccurs = "0"
                if "maxOccurs" in t.AttributeValues.keys():
                    maxOccurs = t.AttributeValues["maxOccurs"]
                else:
                    maxOccurs = "1"
                type = t.AttributeValues["type"]
                element_dict[element_name] = [type, minOccurs, maxOccurs]
                if t.HasRight():
                    t.Right()
                else:
                    element_flag = 0
            xsd_dict[name] = element_dict
            xsd_list[name] = element_list
            # delete the element list so that a new one will be made
            del(element_list)
            while t.ElementTypeName != "xsd:complexType":
                t.Up()
        elif t.ElementTypeName == "xsd:simpleType":
            name = t.AttributeValues["name"]
            t.Down()
            base = t.AttributeValues["base"]
            xsd_simple_type_dict[name] = base
            t.Up()
        if t.HasRight():
            t.Right()
        else:
            flag = 0


print "-----------------------------------------------------------"
print "xsd:complexTypes:"
pprint.pprint(xsd_dict)
pprint.pprint(xsd_list)
print "-----------------------------------------------------------"
print "xsd:simpleTypes:"
pprint.pprint(xsd_simple_type_dict)
print "-----------------------------------------------------------"
        




f = open("XSD.py", "w")
f.write("""#################################################################
#
# XSD.py
#
# Automatically generated by WriteXSD.py, please don't edit this file!
#
# Version: $Id: WriteXSD.py,v 1.31 2006/06/09 08:56:59 svensson Exp $
#
#################################################################

import pprint, time, socket, re, traceback, copy
import string, sys, threading
import pyxie, os
import xml.sax.saxutils

class XSDBase:

    def __init__(self, dict=None):
        self.name = None
        if not dict is None:
            self.fromDict(dict)

    def PyxieTreeToDict(self, t):
        dict = {}
        for node in t.Children():
            if isinstance(node,pyxie.xElement):
                elementTypeName = node.ElementTypeName
                t.Seek(node)
                if elementTypeName in dict.keys():
                    if type(dict[elementTypeName]) == type([]):
                        dict[elementTypeName].append(self.PyxieTreeToDict(t))
                    else:
                        dict[elementTypeName] = [dict[elementTypeName],self.PyxieTreeToDict(t)]
                else:
                    dict[elementTypeName] = self.PyxieTreeToDict(t)
            else:  
                t.Down()
                tmp_data = str(t.Data)
                while t.HasRight():
                    t.Right()
                    tmp_data = tmp_data + str(t.Data)
                return tmp_data                
        return dict

    def UnescapeDict(self, dict):
        #
        #
        #
        for key in dict.keys():
            if type(dict[key]) == type({}):
                dict[key] = self.UnescapeDict(dict[key])
            elif type(dict[key] == type("")):
                try:
                    dict[key] = xml.sax.saxutils.unescape(dict[key])
                except:
                    pass
        return dict
        

    def XMLStringToDict(self, xml_string):
        #
        #
        #
        if xml_string is None:
            return {}
        if xml_string == "":
            return {}
        #
        # Remove spaces between > and <
        #
        tmp_string = string.replace(xml_string, '\\n', '')
        p = re.compile("\\>[ ]*\\<")
        xml_string_cleaned = p.sub('><', tmp_string)
        #
        #
        #
        t = pyxie.String2xTree(xml_string_cleaned)
        topnode = t[0]
        topelement = topnode.ElementTypeName
        dict = {}
        dict[topelement] = self.PyxieTreeToDict(t)
        #
        #
        #
        dict = self.UnescapeDict(dict)
        #
        #
        #
        return dict


    def DictToXML(self, dict, doctype = "", first=1):
        if first:
            XML = '<?xml version="1.0" encoding="ISO-8859-1"?>'
            if doctype != "":
                if doctype[0] == "/":
                    doctype = doctype[1:]
                XML += '<!DOCTYPE %s>'%(doctype)
        else:
            XML = ""
        for element in self.element_list:
            if dict.has_key(element):
                if type(dict[element]) == type({}):
                    XML += '<'+element+'>'
                    # this should not be self, but the subclass?
                    # ie self.${element}
                    if element == self.name:
                        XML += self.DictToXML(dict[element], first=0)
                    else:
                        child = eval("self." + element)
                        if child:
                            XML += child.DictToXML(dict[element], first=0)
                    XML += '</'+element+'>'
                elif type(dict[element]) == type([]):
                    for subelement in dict[element]:
                        XML += '<'+element+'>'
                        if type(subelement) == type({}):
                            if element == self.name:
                                XML += self.DictToXML(subelement, first=0)
                            else:
                                child = eval("self." + element)
                                # can take child[0] because this
                                # will have the correct element_list
                                XML += child[0].DictToXML(subelement, first=0)
                                
                        elif type(subelement) == type("string"):
                            XML += xml.sax.saxutils.escape(subelement)
                        elif type(subelement) == type(True):
                            XML += '%s'%(subelement)
                        elif type(subelement) == type(1):
                            XML += '%d'%(subelement)
                        elif type(subelement) == type(1.0):
                            XML += '%f'%(subelement)
                        XML += '</'+element+'>'
                elif type(dict[element]) == type("string"):
                    XML += '<'+element+'>'+xml.sax.saxutils.escape(dict[element])+'</'+element+'>'
                elif type(dict[element]) == type(True):
                    XML += '<'+element+'>'+'%s'%(dict[element])+'</'+element+'>'
                elif type(dict[element]) == type(1):
                    XML += '<'+element+'>'+'%d'%(dict[element])+'</'+element+'>'
                elif type(dict[element]) == type(1.0):
                    XML += '<'+element+'>'+'%f'%(dict[element])+'</'+element+'>'
        return XML

    def DictToHTML(self, dict, doctype = "", first=1):
        if first:
            HTML = '<html><head><title>'
            if doctype != "":
                if doctype[0] == "/":
                    doctype = doctype[1:]
                HTML += doctype
            else:
                HTML += "xml output"
            HTML += '</title></head><body>'
        else:
            HTML = ""
        for element in self.element_list:
            if dict.has_key(element):
                if type(dict[element]) == type({}):
                    HTML += '<p>'+element+'</p>'
                    if element == self.name:
                        HTML += self.DictToHTML(dict[element], first=0)
                    else:
                        child = eval("self." + element)
                        if child:
                            HTML += child.DictToHTML(dict[element], first=0)
                elif type(dict[element]) == type([]):
                    for subelement in dict[element]:
                        HTML += '<p>'+element+'</p>'
                        if type(subelement) == type({}):
                            if element == self.name:
                                HTML += self.DictToHTML(subelement, first=0)
                            else:
                                child = eval("self." + element)
                                # can take child[0] because this
                                # will have the correct element_list
                                HTML += child[0].DictToHTML(subelement, first=0)
                                
                        elif type(subelement) == type("string"):
                            HTML += subelement
                        elif type(subelement) == type(True):
                            HTML += '%s'%(subelement)
                        elif type(subelement) == type(1):
                            HTML += '%d'%(subelement)
                        elif type(subelement) == type(1.0):
                            HTML += '%f'%(subelement)
                elif type(dict[element]) == type("string"):
                    HTML += '<p>'+element+' '+str(dict[element]) + '</p>'
                elif type(dict[element]) == type(True):
                    HTML += '<p>'+element+' '+str(dict[element])+ '</p>'
                elif type(dict[element]) == type(1):
                    HTML += '<p>'+element+' '+str(dict[element])+ '</p>'
                elif type(dict[element]) == type(1.0):
                    HTML += '<p>'+element+' '+str(dict[element])+ '</p>'
        if first:
            HTML += '</body></html>'
        return HTML


    def toDouble( self, _object ):
        value = None
        if _object is None or _object == "" or _object == {}:
            pass
        elif type( _object ) == type( 1.0 ):
            value = _object
        else:
            value = string.atof( _object )
        return value


    def toInt(self, _object):
        value = None
        if _object is None or _object == "" or _object == {}:
            pass
        elif type( _object ) == type( 1 ) or type( _object ) == type( 1L ):
            value = _object
        else:
            value = string.atoi( _object )
        return value
   

    def toString(self, _object):
        value = None
        if _object is None:
            # return an empty string
            value = ""
        elif type( _object ) == type( 1 ) or type( _object ) == type( 1L ):
            value = "%d" % _object
        elif type( _object ) == type( True ):
            value = "%s" % _object
        elif type( _object ) == type( 1.0 ):
            value = "%f" % _object
        elif type( _object ) == type( "" ):
            value = _object
        elif _object == {}:
            pass
        else:
            print _object, type( _object )
            raise "Error in XSDBase.toString: object not a string, an int or an float "
        return value


    def toBoolean(self, _object):
        value = None
        if type( _object ) == type( True ):
            value = _object
        elif type( _object ) == type( "" ):
            if _object.lower() == "":
                value = False
            else:
                value = True
        elif type( _object ) == type( 1 ):
            if _object:
                value = True
            else:
                value = False
        return value
    
    def xml_with_indentations( self, xml_string ):        
        #
        # First clean the string
        #
        # Remove spaces between > and <
        #
        tmp_string = string.replace( xml_string, '\\n', '' )
        p = re.compile( "\\>[ ]*\\<" )
        xml_string_cleaned = p.sub( '><', tmp_string )
        index = 0
        len_xml_string = len( xml_string_cleaned )
        new_xml_string = ""
        no_spaces = 0
        while ( index < len_xml_string ):
          extra_char = ""
          if xml_string_cleaned[index:index+5] == "<?xml":
            pass
            #        no_spaces = no_spaces - 2
          elif xml_string_cleaned[index:index+2] == "</":
            pass
          elif xml_string_cleaned[index] == "<":
            no_spaces = no_spaces + 2
          elif xml_string_cleaned[index] == ">":
            index2 = index
            while ( index2 < len_xml_string ):
              if xml_string_cleaned[index2:index2+3] == "></":
                extra_char = "\\n"
                no_spaces = no_spaces - 2
                index2 = len_xml_string
              elif xml_string_cleaned[index2:index2+2] == "</":
                extra_char = ""
                index2 = len_xml_string
                no_spaces = no_spaces - 2
              elif xml_string_cleaned[index2] == "<":
                extra_char = "\\n"
                index2 = len_xml_string
              index2 = index2+1
          if extra_char != "":
            spaces = ""
            for i in range( no_spaces ):
              spaces = spaces+" "
            extra_char = extra_char + spaces
          new_xml_string = new_xml_string + xml_string_cleaned[index] + extra_char
          index = index+1
        new_xml_string = new_xml_string + "\\n"
        return new_xml_string

    def marshal(self, doctype=""):
        dict_xml = {self.name: self.toDict()}
        return self.DictToXML(dict_xml, doctype)

    def marshal_with_indentations(self, doctype=""):
        return self.xml_with_indentations( self.marshal( doctype ) )

    def unmarshal(self, xml_message):
        dict_xml = self.XMLStringToDict( unicode( xml_message, 'ISO-8859-1',errors='ignore' ) ) 
        self.fromDict(dict_xml[self.name])
        
    def copy( self ):
        return copy.deepcopy( self )

""")


xsd_convert_dict = { "xsd:string":     "String",
                     "xsd:integer":    "Int",
                     "xsd:float":      "Double",
                     "xsd:double":     "Double",
                     "xsd:boolean":    "Boolean",
                    }

xsd_python_type_dict = { "xsd:string":     "str",
                         "xsd:integer":    "int",
                         "xsd:float":      "float",
                         "xsd:double":     "float",
                         "percentage":     "float",
                         "xsd:boolean":    "bool",
                         }
                    

for xsdclass in xsd_dict.keys():
  xsdclassname = capitalizeFirstLetter( xsdclass )
  attribs = xsd_dict[xsdclass]
  f.write("class %s(XSDBase):\n\n"%(xsdclassname))  
  f.write("    def __init__(self, dict=None):\n")
  f.write("        XSDBase.__init__(self, dict)\n")
  f.write("        self.element_list = " + str(xsd_list[xsdclass]) + "\n")
  f.write("""        self.name="%s"\n"""%(xsdclass))
  for attrib_name in attribs.keys(): 
    f.write("        self.%s = None\n" % attrib_name)
    attrib_type = attribs[attrib_name][0]
    if attrib_type in xsd_python_type_dict.keys():
      f.write("        self.%s_type = %s\n" % (attrib_name, \
              xsd_python_type_dict[attrib_type]))
  f.write("        if not dict is None:\n")
  f.write("            self.fromDict(dict)\n\n")

  for attrib_name in attribs.keys():
    attrib_name_cap = capitalizeFirstLetter( attrib_name )  
    attrib_type = attribs[attrib_name][0]
    attrib_nmin = attribs[attrib_name][1]
    attrib_nmax = attribs[attrib_name][2]
    if (attrib_nmax == "unbounded"): 
      f.write("    def clear%s(self):\n"%(attrib_name_cap))
      f.write("        self.%s=None\n\n"%(attrib_name))
      f.write("    def add%s(self, %s):\n"%(attrib_name_cap, attrib_name))
      f.write("        if self.%s is None:\n"%(attrib_name))
      f.write("            self.%s = []\n"%(attrib_name))
      if attrib_type in xsd_python_type_dict.keys():
        f.write("        if not %s is None:\n" % attrib_name)
        f.write("            try:\n")
        f.write("                self.%s.append(%s(%s))\n" % (attrib_name, \
                xsd_python_type_dict[attrib_type], attrib_name))
        f.write("            except:\n")
        f.write("                raise \"Conversion error in XSD.py for class %s attribute %s\"\n" % (xsdclassname, attrib_name))
        f.write("        else:\n")
        f.write("          pass\n\n")
      else:
        f.write("        self.%s.append(%s)\n\n" % (attrib_name, attrib_name))      
    else:
      f.write("    def set%s(self, %s):\n"%(attrib_name_cap, attrib_name))
      if attrib_type in xsd_python_type_dict.keys():
        f.write("        if not %s is None:\n" % attrib_name)
        f.write("            try:\n")
        f.write("                self.%s = %s(%s)\n" % (attrib_name, \
                xsd_python_type_dict[attrib_type], attrib_name))
        f.write("            except:\n")
        f.write("                raise \"Conversion error in XSD.py for class %s attribute %s\"\n" % (xsdclassname, attrib_name))
        f.write("        else:\n")
        f.write("            self.%s=None\n\n" % attrib_name)
      else:
        f.write("        self.%s = %s\n\n"%(attrib_name, attrib_name))
    f.write("    def get%s(self):\n"%(attrib_name_cap))
    f.write("        return self.%s\n\n"%(attrib_name))

  f.write("    def toDict(self):\n")
  f.write("        dict = {}\n")
  for attrib_name in attribs.keys():
    attrib_type = attribs[attrib_name][0]
    attrib_nmin = attribs[attrib_name][1]
    attrib_nmax = attribs[attrib_name][2]
    #    print attrib_name, attrib_type, attrib_nmin, attrib_nmax
    if attrib_type in xsd_convert_dict.keys():
      dict_value = """self.toString(self.%s)"""%(attrib_name)
    else:
      if (not attrib_type in xsd_dict.keys()) and (not attrib_type in xsd_simple_type_dict.keys()):
        raise "XSD ERROR: unknown attribute type %s in %s"%(attrib_type, xsdclass)
      if attrib_type in xsd_simple_type_dict.keys():
        dict_value = """self.toString(self.%s)"""%(attrib_name)      
      else:
        dict_value = """self.%s.toDict()"""%(attrib_name)
    if (attrib_nmin == "0") and (attrib_nmax == "1"): 
      f.write("        if not self.%s is None:\n"%(attrib_name))
      f.write("""            dict["%s"] = %s\n"""%(attrib_name, dict_value))
    elif (attrib_nmin == "1") and (attrib_nmax == "1"): 
      f.write("        if self.%s is None:\n"%(attrib_name))
      f.write("""            raise "Error in %s.toDict(): %s not defined"\n"""%(xsdclassname,attrib_name))
      f.write("""        dict["%s"] = %s\n"""%(attrib_name, dict_value))
    elif (attrib_nmax == "unbounded"):
      if (attrib_nmin == "1"): 
        f.write("        if self.%s is None:\n"%(attrib_name))
        f.write("""            raise "Error in %s.toDict(): %s not defined"\n"""%(xsdclassname,attrib_name))
        f.write("        else:\n")
      elif (attrib_nmin == "0"):
        f.write("        if not self.%s is None:\n"%(attrib_name))
      else:
        raise "ERROR: nmin = %s and nmax = unbounded not supported (%s)"%(attrib_nmin, attrib_name)
      f.write("""            dict["%s"] = []\n"""%(attrib_name))
      f.write("""            for item in self.%s:\n"""%(attrib_name))
      if attrib_type in xsd_convert_dict.keys():
        f.write("""                dict["%s"].append(self.toString(item))\n"""%(attrib_name))
      else:
        if attrib_type in xsd_simple_type_dict.keys():
          f.write("""                dict["%s"].append(item.toString(item))\n"""%(attrib_name))
        else:
          f.write("""                dict["%s"].append(item.toDict())\n"""%(attrib_name))
    else:
      raise "Unknow combination %s: attrib_nmin = %s and attrib_nmax = %s"%(attrib_name, attrib_nmin, attrib_nmax)
  f.write("""        return dict\n\n""")

  f.write("    def fromDict(self, dict):\n")
  for attrib_name in attribs.keys():
    attrib_type = attribs[attrib_name][0]
    attrib_nmin = attribs[attrib_name][1]
    attrib_nmax = attribs[attrib_name][2]
    if attrib_type in xsd_convert_dict.keys():
      object_value = """self.%s = self.to%s(dict["%s"])"""%(attrib_name, xsd_convert_dict[attrib_type],attrib_name)
    elif attrib_type in xsd_simple_type_dict.keys():
      object_value = """self.%s = self.to%s(dict["%s"])"""%(attrib_name, \
        xsd_convert_dict[xsd_simple_type_dict[attrib_type]],attrib_name)
    else:
      object_value = """self.%s = %s(dict["%s"])"""%(attrib_name, capitalizeFirstLetter( attrib_type ), attrib_name )
    if (attrib_nmin == "0") and (attrib_nmax == "1"): 
      f.write("""        if "%s" in dict.keys():\n"""%(attrib_name))
      f.write("""            %s\n"""%(object_value))
    elif (attrib_nmin == "1") and (attrib_nmax == "1"): 
      f.write("""        if not "%s" in dict.keys():\n"""%(attrib_name))
      f.write("""            raise "Error in %s.fromDict(): %s not defined"\n"""%(xsdclassname,attrib_name))
      f.write("""        %s\n"""%(object_value))
    elif (attrib_nmax == "unbounded"): 
      if (attrib_nmin == "1"): 
        f.write("""        if not "%s" in dict.keys():\n"""%(attrib_name))
        f.write("""            raise "Error in %s.fromDict(): %s not defined"\n"""%(xsdclassname,attrib_name))
        f.write("""        else:\n""")
      elif (attrib_nmin == "0"): 
        f.write("""        if "%s" in dict.keys():\n"""%(attrib_name))
      else:
        raise "ERROR: nmin = %s and nmax = unbounded not supported (%s)"%(attrib_nmin, attrib_name)
      f.write("""            self.%s = []\n"""%(attrib_name))
      f.write("""            if type(dict["%s"]) == type([]):\n"""%(attrib_name))
      f.write("""                for item in dict["%s"]:\n"""%(attrib_name))
      if attrib_type in xsd_convert_dict.keys():
        f.write("""                    self.%s.append(self.to%s(item))\n"""%(attrib_name, xsd_convert_dict[attrib_type]))
      elif attrib_type in xsd_simple_type_dict.keys():
        f.write("""                    self.%s.append(self.to%s(item))\n"""%(attrib_name, \
          xsd_convert_dict[xsd_simple_type_dict[attrib_type]]))
      else:
        f.write("""                    self.%s.append(%s(item))\n"""%(attrib_name, capitalizeFirstLetter( attrib_type )))
      f.write("""            else:\n""")
      if attrib_type in xsd_convert_dict.keys():
        f.write("""                    self.%s.append(self.to%s(dict["%s"]))\n"""%(attrib_name, xsd_convert_dict[attrib_type], attrib_name))
      else:
        f.write("""                self.%s.append(%s(dict["%s"]))\n"""%(attrib_name, capitalizeFirstLetter( attrib_type ), attrib_name))
    else:
      raise
  f.write("\n")

f.close()







