#################################################################
#
# xsd2html.py
#
# First version of a python scripts that generates HTML pages
# for the xsd definitions.
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version = $ID$
#
#

import time, string, re

regexp = re.compile(".*complexType.*name")

xsd_file_list = ["dna_common.xsd", \
                 "dna_collect.xsd", \
                 "dna_index.xsd", \
		 "dna_strategy.xsd", \
		 "dna_kappastrategy.xsd", \
		 "dna_integrate.xsd", \
		 "dna_gui.xsd", \
		 "dna_config.xsd", \
		 "dna_sortmtz.xsd", \
		 "dna_scala.xsd", \
		 "dna_scale.xsd", \
		 "ispyb.xsd", \
		 "dna_db.xsd", \
                ]

#
# First write the index page
#

file = open("index.html", "w")
file.write("""<html>
<head>
<title>DNA XSD definitions</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>

<body bgcolor="#FFFFFF" text="#000000">
<h2>Current XSD definitions:</h2>
<ul>
""")
for xsd_file in xsd_file_list:
  file.write("  <li><A HREF=%s.html>%s</A></li>\n"%(xsd_file,xsd_file))
  file.write("  <ul>\n")
  xsd_def_file = open("../../../../xsd/%s"%(xsd_file),"r")
  lines = xsd_def_file.readlines()
  for line in lines:
    if re.match(regexp, line):
      index1 = string.find(line, "\"")
      index2 = string.find(line, "\"", index1+1)
      name = line[index1+1:index2]
      file.write("    <li><A HREF=%s.html#%s>%s</A></li>\n"%(xsd_file,name,name))
  file.write("  </ul>\n")
    
file.write("""</ul>
<p>Last updated: %s</p>
</body>
</html>"""%(time.ctime()))
file.close()

#
# Then write one HTML page for each file
#

for xsd_file in xsd_file_list:
  file = open("%s.html"%(xsd_file),"w")
  file.write("""<html>
<head>
<title>%s</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>

<body bgcolor="#FFFFFF" text="#000000">
<pre>
"""%(xsd_file))
  xsd_def_file = open("../../../../xsd/%s"%(xsd_file),"r")
  lines = xsd_def_file.readlines()
  for line in lines:
    if re.match(regexp, line):
      index1 = string.find(line, "\"")
      index2 = string.find(line, "\"", index1+1)
      name = line[index1+1:index2]
      file.write("<A NAME=%s>\n"%(name))
    line2 = string.replace(line, "<", "&lt;")
    line2 = string.replace(line2, ">", "&gt;");
    if string.find(line2, "$Id:") != -1:
      line2 = string.replace(line, "$", "S")  
    file.write(line2)

  xsd_def_file.close()
  file.write("""
</pre>
</body>
</html>""")
  file.close()





