#!/bin/bash

############################################################
# Introduction & Welcome
############################################################

VERSION="dna_1.0.0"
VERSION_="--------------"

echo "DNA installation script for version ${VERSION}"
echo "------------------------------------${VERSION_}"
echo "During installation this will make a script named ~/dna_setup.sh"
echo "which will contain all of the environment variables you will"
echo "need to make DNA work"
echo ""
echo "For help contact Graeme Winter at g.winter@dl.ac.uk or "
echo "on +44 1925 603228"
echo "Or Olof Svensson at svensson@esrf.fr or on +33 476 882495"
echo "or for general queries contact dna-support@esrf.fr"
echo ""

# Check for a CCP4 installation

if [ "$CCP4" = "" ]; then
    echo "To make DNA work you must have a configured CCP4 5.0 installation"
    echo "Exiting installation..."
    exit
fi

echo "Please give the location of the installation tarball"
SOURCE_FILE=`pwd`/dna_1.0.0.tar.gz
echo "(Just press enter if it is ${SOURCE_FILE})"
echo "(Don't worry if you don't have it, we can download it for you!"
echo "so just press enter anyway)"

read SOURCE_FILE_2
if [ "${SOURCE_FILE_2}" != "" ]; then
    SOURCE_FILE=${SOURCE_FILE_2}
fi

echo "Source file is ${SOURCE_FILE}"
if ! [ -e ${SOURCE_FILE} ]; then
    echo "Source file ${SOURCE_FILE} does not exist - "
    echo "shall I download it from http://www.dna.ac.uk/release/dna_1.0.0.tar.gz? [Y]/n"
    read DOWNLOAD
    if [ "$DOWNLOAD" = "" ]; then
	DOWNLOAD="Y"
    fi
    if [ "$DOWNLOAD" = "y" ]; then
	DOWNLOAD="Y"
    fi
    if [ "$DOWNLOAD" = "Y" ]; then
	wget http://www.dna.ac.uk/release/beta/dna_1.0.0.tar.gz
    else
	echo "Not downloading, and do not have tarball available, exiting..."
	exit
    fi
fi

SHELL_SETUP="${HOME}/dna_setup.sh"
rm -f ${SHELL_SETUP}

DATE=`date`

echo "# dna_setup configuration file made by " >> ${SHELL_SETUP} 
echo "# release.sh on ${DATE}" >> ${SHELL_SETUP}

DEST_DIR=""

# determine the host type - and confirm that this
# is a Linux box
SYS_TYPE=`uname -a | gawk '{print $1}'`
SYS_HOSTNAME=`uname -a | gawk '{print $2}'`
SYS_DNA_NAME=`uname -a | sed 's/\./\ /' | gawk '{print $2}'`

if [ "$SYS_TYPE" != "Linux" ]; then
    echo "System is not linux - contact program authors for support"
    echo "for system ${SYS_TYPE}"
    exit
fi

echo "The name \"${SYS_DNA_NAME}\" will be used to identify this system"

DNANAME=${SYS_DNA_NAME}

echo "export DNANAME=${DNANAME}" >> ${SHELL_SETUP}

echo "Where would you like DNA installed (default is ${HOME}/${VERSION})"
read TEMP_DIR
if [ "$TEMP_DIR" != "" ]; then
    DEST_DIR=${TEMP_DIR}
else
    DEST_DIR=${HOME}/${VERSION}
fi

echo "Will install dna in ${DEST_DIR}"

echo "export DNAHOME=${DEST_DIR}" >> ${SHELL_SETUP}
echo "export besthome=${DEST_DIR}/third_party/best_v2.0/" >> ${SHELL_SETUP}
echo "export DNALOGDIR=${DEST_DIR}/logs" >> ${SHELL_SETUP}
echo "export DNATMPDIR=/tmp/dna-${USER}" >> ${SHELL_SETUP}

echo "export PATH=${DEST_DIR}/third_party/best_v2.0/:${DEST_DIR}/scripts:${DEST_DIR}/third_party/mosflm:\${PATH}" >> ${SHELL_SETUP}

echo "export LD_LIBRARY_PATH=${DEST_DIR}/ext/lib:\${LD_LIBRARY_PATH}" >> ${SHELL_SETUP}

echo "Making DNA temporary directory /tmp/dna-${USER}"

mkdir -p ${DEST_DIR}/logs
mkdir -p /tmp/dna-${USER}

echo "Unpacking......"
gunzip < ${SOURCE_FILE} | tar xf - -C ${DEST_DIR}

echo "Now doing a bit of building"
export DNAHOME=${DEST_DIR}

echo "Building the extension libraries"
cd ${DNAHOME}/ext
bash build

echo "Building third party things"
cd ${DNAHOME}/third_party
bash build.sh
# note that these are hard quoted
echo 'export besthome=${DNAHOME}/third_party/best_v2.1' >> ${SHELL_SETUP}
echo 'export PATH=${PATH}:${besthome}' >> ${SHELL_SETUP}


echo "Now building Mosflm!"
cd ${DNAHOME}/third_party/mosflm
gunzip < mosflm625.tgz | tar xf -
cd mosflm625
./build > /dev/null
cp bin/ipmosflm ../

echo "Building things that the scheduler needs"
cd ${DNAHOME}/scheduler
bash build

echo "Building the GUI"
cd ${DNAHOME}/gui
make xml >> /dev/null
make >> /dev/null

echo "Now configuring DNA for system ${DNANAME} in ${DNAHOME}/config"
cd ${DNAHOME}/config
cp -r generic ${DNANAME}
cd ${DNANAME}
COMMAND="s/DNAHOME/${DNAHOME//\//\\/}/"
cat system_defaults.xml | sed "s/HOST_NAME/${DNANAME}/" | sed "${COMMAND}" > foo
mv foo system_defaults.xml

echo "Copying setup script to ${DEST_DIR}"
cp ${SHELL_SETUP} ${DEST_DIR}

echo "Would you like to get some test data (recommended)? [Y]/[n]"
read TEST_DATA
if [ "$TEST_DATA" == "" ]; then
    TEST_DATA="Y"
fi
if [ "$TEST_DATA" == "y" ]; then
    TEST_DATA="Y"
fi
if [ "$TEST_DATA" == "" ]; then
    echo "Getting test data (trypsin) from http://www.dna.ac.uk/release/dna_testdata.tar.gz"
    wget http://www.dna.ac.uk/release/dna_testdata.tar.gz
    echo "Unpacking in ${DEST_DIR}/../"
    tar xfz dna_testdata.tar.gz -C ${DEST_DIR}/../
else
    echo "You are not fetching the test data - this means that the DNA "
    echo "default test will not work"
fi

echo "All done, have a go!"
echo "Try this:"
echo ". ${SHELL_SETUP}"
echo "cd ${DNAHOME}/scripts"
echo "./test_dna"

