#!/bin/bash

############################################################
# Welcome script
############################################################

echo "This is the DNA release candidate no. 1 installation script"
echo "During the process, a dna_setup.sh script will be created in"
echo "your home directory. This should be sourced to set up your"
echo "DNA installation for use after installation."
echo ""
echo "For help, please email g.winter@dl.ac.uk"
echo ""

# Since this is being run from the source directory, then 
# we can obtain this useful information now
SOURCE_DIR=`pwd`

# do not assign the destination directory yet
DEST_DIR=""

# remove the dna_setup.sh file
rm -f ~/dna_setup.sh

# and add a header for a new one
echo "# dna_setup configuration file" >> ~/dna_setup.sh


# determine the host type - and confirm that this
# is a Linux box
SYS_TYPE=`uname -a | gawk '{print $1}'`
SYS_HOSTNAME=`uname -a | gawk '{print $2}'`
SYS_DNA_NAME=`uname -a | sed 's/\./\ /' | gawk '{print $2}'`

# also use this to obtain the hostname information etc for use in the 
# DNA configuration

# check the machine type
if ! [ $SYS_TYPE = "Linux" ]; then
  echo "This release will not support $SYS_TYPE"
  echo "You will need an i386 Linux box"
  exit
else
  echo "This is a Linux box. Good, that is what we are supporting."
  echo ""
fi

# phone home
echo "May I phone home? (Y/n)"
read PHONE
if [ "$PHONE" = "" ]; then
  PHONE="Y"
fi

if [ "${PHONE/y/Y}" = "Y" ]; then
  SYSTEM=`uname -a`
  echo "Phone home $USER at $SYS_HOSTNAME a $SYSTEM " | mail g.winter@dl.ac.uk
fi

# tell the user what is going on
echo "Here are a few bits of information which have been picked up"
echo "about your system - there's not a lot you can do if they're"
echo "wrong! ;o)"
echo ""

echo "Your system is $SYS_HOSTNAME and $SYS_DNA_NAME will be used as"
echo "the identifier for this system (DNANAME)"

DNANAME=$SYS_DNA_NAME

# start to write useful information to the setup file
echo "export DNANAME=$DNANAME" >> ~/dna_setup.sh

# ask where we would like DNA to be installed - 
# /opt/DNA is the default
echo "Target directory? (/opt/DNA)"
read TEMP_DIR
if [ "$TEMP_DIR" = "" ]; then
  DEST_DIR="/opt/DNA"
else
  DEST_DIR=$TEMP_DIR
fi

echo "Target directory set to $DEST_DIR"


echo "export DNAHOME=${DEST_DIR}/DNA" >> ~/dna_setup.sh
echo "export DNALOGDIR=$DEST_DIR/logs" >> ~/dna_setup.sh
echo "export DNATMPDIR=/tmp/dna" >> ~/dna_setup.sh

# check to see if there is a temporary directory for
# dna - and if not, create one
if ! [ -e /tmp/dna ]; then
  echo "Making DNA working directory in /tmp/dna"
  mkdir /tmp/dna
fi

############################################################
# Function to perform installation of CCP4
############################################################

function check_ccp4_license {

  agreed="no"


  ### has someone else we (know about) agreed to the ccp4 conditions before?
  ### and if so make sure the the home dir has agreement file
  if test -f .agree2ccp4; then
     eval touch ${HOME}/.agree2ccp4;
     if test -w .agree2ccp4; then 
        echo $user `date` >> .agree2ccp4;   
     fi
     if test -w ${HOME}/.agree2ccp4; then
        date >> ${HOME}/.agree2ccp4;
     fi
     agreed=yes
  fi

  ### has the user agreed to the ccp4 condition's before?
  if test $agreed = "no"; then
     if test -f ${HOME}/.agree2ccp4; then
        eval touch .agree2ccp4
        if test -w ${HOME}/.agree2ccp4; then
          date >> ${HOME}/.agree2ccp4;
        fi
        if test -w .agree2ccp4; then 
           echo $user `date` >> .agree2ccp4;   
        fi
        agreed=yes
     fi
  fi

  ### so if this site, as far as we know has never agreed to ccp4 
  ### conditions then they must!

  if test $agreed = "no"; then
    echo ; echo ;
    echo "    For legal reasons we must draw your attention to the"
    echo "    conditions of use and license agreement required to "
    echo "    use the CCP4 package (If you agree to the conditions"
    echo "    you should only be prompted for this information once)."
    echo ; echo ;
    echo -n "    Please press return to continue:"

    read return;

    if test -r licence.txt; then
       echo ; echo ; echo "Please read the following"; echo ;
       more $CCP4/licence.txt ;
       echo ; echo ; 
       echo "Do you agree to the above and agree (if this has not" ;
       echo "already been done) to return a completed and signed";
       echo "copy of this document found in license.txt? "
       echo "(Please note that if a copy of the previous license has been";
       echo "returned there is no need to send a copy of this new agreement)";
       echo -n "          y/n [n] ?:";

       read ans ;

       if test $ans = "y"; then 
         eval touch ${HOME}/.agree2ccp4;
         if test -w ${HOME}/.agree2ccp4; then
           date > ${HOME}/.agree2ccp4;
         else
           echo "  No record of you agreeing to the CCP4 license coditions";
           echo "  has been kept in your home area.";
         fi
         echo $user `date` > .agree2ccp4;
         chmod ugo+rw .agree2ccp4 ;   
         agreed=yes ;
         echo ; echo ; echo " Thank you. The CCP4 configure will now run as normal.";
       fi
    else
      echo " The file license.txt in the $CCP4 directory could not be found" 
      echo " Please download or contact ccp4@ccp4.ac.uk" ; echo ; echo;
      exit 1
    fi
  fi

  if test $agreed = "no"; then
      echo ; echo ; echo " You have indicated that you do not agree to the conditions";
      echo " of use for the CCP4 package. Please delete all CCP4 software";
      echo " from your system. If you have any further queries please refer ";
      echo " to the CCP4 web pages on http://www.dl.ac.uk/CCP/CCP4/ or contact" ;
      echo " ccp4@ccp4.ac.uk";
      exit 1
  fi

  ### End of licensing section.
}

function install_ccp4 {
  echo "Installing CCP4 in $1 from ftp://ftp.ccp4.ac.uk"

  # check to see if the target directory exists
  if ! [ -e $1 ]; then
    echo "Making $1"
    mkdir $1
  fi

  # if we haven't downloaded the tarball, then do so

  if ! [ -e ccp4-4.2.2.tar.gz ]; then
    wget ftp://ftp.ccp4.ac.uk/pub/ccp4/current/packed/ccp4-4.2.2.tar.gz
  fi

  # if the CCP4 distribution exists in the target directory then 
  # delete it to give a clean slate

  if [ -e $1/ccp4-4.2.2 ]; then
    echo "Deleting current CCP4 installation in $1/ccp4-4.2.2"
    rm -rf $1/ccp4-4.2.2
  fi

  echo "Unpacking and building CCP4"

  tar xfz ccp4-4.2.2.tar.gz -C $1

  export OLD_DIR=`pwd`

  cd $1 
  export HERE=`pwd`
  export SED_HERE=${HERE//\//\\\/}

  SED_COMMAND=s/\\\/xtal/$SED_HERE/

  cd ccp4-4.2.2/include

  # create the ccp4.sh command script

  cat ccp4.setup-bash | sed $SED_COMMAND > ccp4.sh

  . ccp4.sh

  # then compile and install CCP4 - note that the --with-netlib-lapack is 
  # needed on SuSE boxes.

  cd $CCP4

  # configuration cannot be piped to a file since the license must be 
  # agreed to....

  check_ccp4_license


  ./configure --with-x --with-netlib-lapack linux >> $OLD_DIR/make_ccp4.log 2>&1 

  echo "Maaking CCP4 from source - this will probably take a while"

  make >> $OLD_DIR/make_ccp4.log 2>&1 
  make install >> $OLD_DIR/make_ccp4.log 2>&1 

  cd $OLD_DIR

  echo ". $1/ccp4-4.2.2/include/ccp4.sh" >> ~/dna_setup.sh
}

function old_install_ccp4 {
  # legally worthless message
  echo "Installing CCP4 in $1 from $SOURCE_DIR"
  echo "by performing this installation you agree to the CCP4"
  echo "license."

  # check to see if the installation tarball exists
  if ! [ -f ${SOURCE_DIR}/ccp4.tar.gz ]; then
    echo "You need to download ccp4.tar.gz"
    return
  fi

  # check to see if the target directory exists
  if ! [ -e $1 ]; then
    echo "Making $1"
    mkdir $1
  fi

  echo "Unpacking CCP4"
  tar xfz ${SOURCE_DIR}/ccp4.tar.gz -C $1

  # next add something to source the setup file
  echo "export DNA_CCP4_4=$1/ccp4" >> ~/dna_setup.sh
  echo ". $1/ccp4/ccp4-4.2.2/include/ccp4.sh" >> ~/dna_setup.sh
}

############################################################
# Function to perform installation of Java
############################################################

function install_java {
  GCC_VERSION=`gcc -v 2>&1 | tail -1 | awk '{print $3}' | sed 's/\./\ /' | awk '{print $1}'`

  if [ $GCC_VERSION == '3' ]; then
    if ! [ -e j2re-1.4.1-01-linux-i586-gcc3.2.bin ] ; then
      wget ftp://ftp.mirror.ac.uk/sites/ftp.blackdown.org/java-linux/JDK-1.4.1/i386/01/j2re-1.4.1-01-linux-i586-gcc3.2.bin
    fi
    JAVA_BIN=j2re-1.4.1-01-linux-i586-gcc3.2.bin
  else
    if ! [ -e j2re-1.4.1-01-linux-i586-gcc2.95.bin ] ; then
      wget ftp://ftp.mirror.ac.uk/sites/ftp.blackdown.org/java-linux/JDK-1.4.1/i386/01/j2re-1.4.1-01-linux-i586-gcc2.95.bin
    fi
    JAVA_BIN=j2re-1.4.1-01-linux-i586-gcc2.95.bin
  fi

  OLD_DIR=`pwd`

  if ! [ -e $1 ]; then
    echo "Making $1"
    mkdir $1
  fi

  cd $1
  bash $OLD_DIR/$JAVA_BIN

  # make changes to path etc
  echo "export DNA_JAVA_PATH=$1/j2re1.4.1/bin" >> ~/dna_setup.sh

  cd $OLD_DIR
}

function old_install_java {
  echo "Installing java 2 runtime in $1 from $SOURCE_DIR"
  echo "by performing this installation you agree to the"
  echo "Sun Microsystems Java license"

  # as above

  if ! [ -f ${SOURCE_DIR}/j2re.tar.gz ]; then
    echo "You need to download j2re.tar.gz"
    return
  fi

  if ! [ -e $1 ]; then
    echo "Making $1"
    mkdir $1
  fi

  echo "Unpacking j2re"
  tar xfz ${SOURCE_DIR}/j2re.tar.gz -C $1 

  # make changes to path etc
  echo "export DNA_JAVA_PATH=$1/j2re/bin" >> ~/dna_setup.sh
}

############################################################
# Function to perform installation of Python
############################################################

function install_python {

  OLD_DIR=`pwd`

  if ! [ -e Python-2.3.2.tgz ] ; then
    wget ftp://ftp.mirror.ac.uk/sites/ftp.python.org/pub/python/2.3.2/Python-2.3.2.tgz
  fi

  if [ -e Python-2.3.2 ] ; then
    rm -rf Python-2.3.2
  fi

  if ! [ -e $1 ]; then
    echo "Making $1"
    mkdir $1
  fi

  echo "Unpacking Python-2.3.2.tgz"

  tar xfz Python-2.3.2.tgz
  cd Python-2.3.2

  rm -f $OLD_DIR/make_python.log

  echo "Configuring and making Python 2.3.2"

  ./configure --prefix=$1/python >> $OLD_DIR/make_python.log 2>&1
  make >> $OLD_DIR/make_python.log 2>&1 

  echo "Installing Python 2.3.2 in $1/python"

  make install >> $OLD_DIR/make_python.log 2>&1

  # make changes to path
  echo "export DNA_PYTHON_PATH=$1/python/bin" >> ~/dna_setup.sh

  cd $OLD_DIR
}

function old_install_python {
  echo "Installing python interpreter in $1 from $SOURCE_DIR"

  # as above

  if ! [ -f ${SOURCE_DIR}/python.tar.gz ]; then
    echo "You need to download python.tar.gz"
    return
  fi

  if ! [ -e $1 ]; then
    echo "Making $1"
    mkdir $1
  fi

  echo "Unpacking python"
  tar xfz ${SOURCE_DIR}/python.tar.gz -C $1

  # make changes to path
  echo "export DNA_PYTHON_PATH=$1/python/bin" >> ~/dna_setup.sh
}


# next I ask about which of these above function should be 
# called today. CHANGED. This will now ask you all of the questions 
# that it needs to at the beginning, so you can go and havea coffee
# while it's working.

############################################################
# Install CCP4?
############################################################

if [ "$CCP4" = "" ]; then
  echo "CCP4 is not installed"
else
  echo "CCP4 is installed in $CCP4"
fi

echo "Install CCP4? (Y/n)"
read INSTALL_CCP4

if [ "$INSTALL_CCP4" = "" ]; then
  INSTALL_CCP4="Y"
fi

############################################################
# Install Java?
############################################################

JAVA=`which java 2> /dev/null`
if ! [ "$JAVA" = "" ]; then
  echo "Current Java interpreter is $JAVA"
else
  echo "No Java interpreter found"
fi

echo "Install Java 2 runtime environment? (Y/n)"
read INSTALL_JAVA

if [ "$INSTALL_JAVA" = "" ]; then
  INSTALL_JAVA="Y"
fi

############################################################
# Install Python?
############################################################

PYTHON=`which python 2> /dev/null`

if ! [ "$PYTHON" = "" ]; then
  echo "Current Python interpreter is $PYTHON"
else
  echo "No Python interpreter found"
fi

echo "Install Python? (Y/n)"
read INSTALL_PYTHON

if [ "$INSTALL_PYTHON" = "" ]; then
  INSTALL_PYTHON="Y"
fi




if [ "${INSTALL_CCP4/y/Y}" = "Y" ]; then
  install_ccp4 $DEST_DIR
fi
if [ "${INSTALL_JAVA/y/Y}" = "Y" ]; then
  install_java $DEST_DIR
fi
if [ "${INSTALL_PYTHON/y/Y}" = "Y" ]; then
  install_python $DEST_DIR
fi

############################################################
# Next, install DNA!
############################################################

if ! [ -f DNA.tar.gz ]; then
  echo "Downloading DNA.tar.gz from www.dna.ac.uk/alpha/rc1/dist"
  wget http://www.dna.ac.uk/alpha/rc1/dist/DNA.tar.gz
  wget http://www.dna.ac.uk/alpha/rc1/dist/data.tar.gz
fi

if ! [ -e $DEST_DIR ]; then
  mkdir $DEST_DIR
fi

echo "Unpacking DNA"
tar xfz ${SOURCE_DIR}/DNA.tar.gz -C ${DEST_DIR}
cd ${DEST_DIR}/DNA/config
rm -fr $DNANAME
cp -r generic $DNANAME
cd $DNANAME

# sort out the new configuration

COMMAND1=s/HOST_NAME/$SYS_HOSTNAME/

# ain't unix great?

NEW_IMAGE=${DEST_DIR//\//\\\/}\\\/data
COMMAND2=s/IMAGE_DIR/${NEW_IMAGE}/

NEW_MOS=${DEST_DIR//\//\\\/}\\\/DNA\\\/mosflm\\\/dna_rc1_mosflm
COMMAND3=s/MOSFLM/${NEW_MOS}/


# make the new configuration file
cat dna_config | sed $COMMAND1 | sed $COMMAND2 | sed $COMMAND3 > foo
mv foo dna_config

cd $SOURCE_DIR

# copy in some test data, if available

if [ -e data.tar.gz ]; then
  echo "Copying test data"

  mkdir ${DEST_DIR}/data
  tar xfz data.tar.gz -C ${DEST_DIR}/data
fi

############################################################
# Finish off
############################################################

echo "export PATH=\${DNA_JAVA_PATH}:\${DNA_PYTHON_PATH}:\${PATH}" >> ~/dna_setup.sh

# make a log direrctory if needed
if ! [ -e $DEST_DIR/logs ]; then
  mkdir $DEST_DIR/logs
fi


echo "Installation complete: please review dna_setup.sh in $HOME"
echo "If you have installed the data, then you can test this"
echo "by doing:"
echo ""
echo ". ~/dna_setup.sh"
echo "cd \$DNAHOME/scripts"
echo "./dna"
echo ""
echo "Then going to the autoindex pane and clicking autoindex."
echo "Have fun!"
