#!/bin/bash

############################################################
# Introduction & Welcome
############################################################

VERSION="dna-DEV"
VERSION_="-------"

echo "DNA installation script for version ${VERSION}"
echo "------------------------------------${VERSION_}"

# Check for a CCP4 installation

if [ "$CCP4" = "" ]; then
    echo "To make DNA work you must have a configured CCP4 5.0 installation"
    echo "Exiting installation..."
    exit
fi

echo "Please give the location of your working copy"
DNA_DEVDIR=`pwd`
echo "(Just press enter if it is ${DNA_DEVDIR})"

read DNA_DEVDIR_2
if [ "${DNA_DEVDIR_2}" != "" ]; then
    DNA_DEVDIR=${DNA_DEVDIR_2}
fi

echo "The working copy is located at: ${DNA_DEVDIR}"

echo "Please give the location of DNA TEMP DIR"
DNATMPDIR=/tmp/dna-${USER}
echo "(Just press enter if it is OK: ${DNATMPDIR})"

read DNATMPDIR_2
if [ "${DNATMPDIR_2}" != "" ]; then
    DNATMPDIR=${DNATMPDIR_2}
fi

DATE=`date`

# determine the host type - and confirm that this
# is a Linux box
SYS_TYPE=`uname -a | gawk '{print $1}'`
SYS_HOSTNAME=`uname -a | gawk '{print $2}'`
SYS_DNA_NAME=`uname -a | sed 's/\./\ /' | gawk '{print $2}'`


if [ "$SYS_TYPE" != "Linux" ]; then
    echo "System is not linux - contact program authors for support"
    echo "for system ${SYS_TYPE}"
    exit
fi

echo "The name \"${SYS_DNA_NAME}\" will be used to identify this system"

DNANAME=${SYS_DNA_NAME}

SHELL_SETUPDIR="${DNA_DEVDIR}/scripts/"
SHELL_SETUPNAME="dna_setup_${SYS_DNA_NAME}.sh"
echo "Where to put the setup script?"
echo "[${SHELL_SETUPDIR}]"
read m
if [ "${m}" != "" ]; then
    SHELL_SETUPDIR=${m}
fi
SHELL_SETUP=${SHELL_SETUPDIR}/${SHELL_SETUPNAME}

echo "creating ${SHELL_SETUP} ..."

rm -f ${SHELL_SETUP}

echo "# dna_setup configuration file made by " > ${SHELL_SETUP} 
echo "# $0 on ${DATE}" >> ${SHELL_SETUP}

DEST_DIR=${DNA_DEVDIR}

echo "export DNANAME=${DNANAME}" >> ${SHELL_SETUP}

echo "export DNAHOME=${DEST_DIR}" >> ${SHELL_SETUP}
echo "export besthome=${DEST_DIR}/third_party/best_v2.0/" >> ${SHELL_SETUP}
echo "export DNALOGDIR=${DEST_DIR}/logs" >> ${SHELL_SETUP}
echo "export DNATMPDIR=${DNATMPDIR}" >> ${SHELL_SETUP}

echo "export PATH=${DEST_DIR}/scripts:${DEST_DIR}/third_party/mosflm:\${PATH}" >> ${SHELL_SETUP}

echo "export LD_LIBRARY_PATH=${DNAHOME}/scheduler/lib:${DEST_DIR}/ext/lib:\${LD_LIBRARY_PATH}" >> ${SHELL_SETUP}

echo "Making DNA temporary directory ${DNATMPDIR}"

mkdir -p ${DEST_DIR}/logs
mkdir -p ${DNATMPDIR}


echo "Now doing a bit of building"
export DNAHOME=${DEST_DIR}

if [ -z "${DNA_BUILDING}" ]; then
  echo "Do you really want to perform the building steps? y/[n]"
  read DNA_BUILDING
fi


if [ "${DNA_BUILDING}" == "y" ]; then

echo "Building the extension libraries"
cd ${DNAHOME}/ext
bash build

echo "Building third party things"
cd ${DNAHOME}/third_party
bash build.sh
fi
# note that these are hard quoted
echo 'export besthome=${DNAHOME}/third_party/best_v2.1' >> ${SHELL_SETUP}
echo 'export PATH=${besthome}:${PATH}' >> ${SHELL_SETUP}

if [ "${DNA_BUILDING}" == "y" ]; then
echo "Now building Mosflm!"
cd ${DNAHOME}/third_party/mosflm
gunzip < mosflm625.tgz | tar xf -
cd mosflm625_dna
./build > /dev/null
cp bin/ipmosflm ../

echo "Building things that the scheduler needs"
cd ${DNAHOME}/scheduler
bash build

echo "Building the GUI"
cd ${DNAHOME}/gui
make xml >> /dev/null
make >> /dev/null
fi

echo "Now configuring DNA for system ${DNANAME} in ${DNAHOME}/config"
cd ${DNAHOME}/config
cp -r generic ${DNANAME}
cd ${DNANAME}
COMMAND="s/DNAHOME/${DNAHOME//\//\\/}/"
cat system_defaults.xml | sed "s/HOST_NAME/${DNANAME}/" | sed "${COMMAND}" > foo
mv foo system_defaults.xml

if [ "${DNA_BUILDING}" == "y" ]; then

echo "Would you like to get some test data (recommended)? [Y]/[n]"
read TEST_DATA
if [ "$TEST_DATA" == "" ]; then
    TEST_DATA="Y"
fi
if [ "$TEST_DATA" == "y" ]; then
    TEST_DATA="Y"
fi
if [ "$TEST_DATA" == "Y" ]; then
    echo "Getting test data (trypsin) from http://www.dna.ac.uk/release/dna_testdata.tar.gz"
    wget http://www.dna.ac.uk/release/dna_testdata.tar.gz
    echo "Unpacking in ${DEST_DIR}"
    tar xfz dna_testdata.tar.gz -C ${DEST_DIR}
else
    echo "You are not fetching the test data - this means that the DNA "
    echo "default test will not work"
fi
fi

if ! [ -e ${HOME}/.dna/user_defaults.xml ]; then
    echo "Creating ~/.dna/user_defaults.xml"
    mkdir -p ${HOME}/.dna
    echo "<?xml version='1.0'?><user_defaults><default_values><fileinfo><directory>${DNAHOME}/dna_testdata/trypsin</directory><prefix>trypsin</prefix><suffix>img</suffix><run_number>1</run_number></fileinfo><oscillation_sequence><start>1.000000</start><range>1.000000</range><number_of_images>1</number_of_images><exposure_time>1.000000</exposure_time><start_image_number>1</start_image_number><number_of_passes>3</number_of_passes></oscillation_sequence><detector><type>adsc</type></detector><beam><x>94.800000</x><y>92.900000</y></beam><resolution>2.500000</resolution></default_values><index_parameters><warning_index_spot_rms_error>0.200000</warning_index_spot_rms_error><max_index_spot_rms_error>0.400000</max_index_spot_rms_error><warning_beam_shift>0.100000</warning_beam_shift><max_beam_shift>0.200000</max_beam_shift><warning_index_spot_frac_rejected>0.100000</warning_index_spot_frac_rejected><max_index_spot_frac_rejected>0.200000</max_index_spot_frac_rejected><min_threshold_I_sigma>10.000000</min_threshold_I_sigma></index_parameters></user_defaults>" > ${HOME}/.dna/user_defaults.xml
fi

echo "export DNA_SYSTEM_DEFAULTS=${DNAHOME}/config/${DNANAME}/system_defaults.xml" >> ${SHELL_SETUP}
echo "export DNA_USER_DEFAULTS=${HOME}/.dna/user_defaults.xml" >> ${SHELL_SETUP}
echo "export DNAJAVAPROPERTIES=${DNAHOME}/config/${DNANAME}/java.properties" >> ${SHELL_SETUP}
echo "export GUIHOME=${DNAHOME}/gui" >> ${SHELL_SETUP}


echo "export STACDIR=${DNAHOME}/third_party/STAC" >> ${SHELL_SETUP}
echo "export SPECDEF=${STACDIR}/BEAMLINE_DESCR/BCM.dat" >> ${SHELL_SETUP}
echo "export BCMDEF=${STACDIR}/BEAMLINE_DESCR/BCM.dat" >> ${SHELL_SETUP}
echo "export CLASSPATH=${STACDIR}:${STACDIR}/thirdparty/jars/Jama-1.0.1.jar:${STACDIR}/thirdparty/TangoClient/jive-3.0.3.jar:${STACDIR}/thirdparty/TangoClient/TangORB-3.0.3.jar:${GUIHOME}:${GUIHOME}/classes:${DNAHOME}/ext/jars/castor-0.9.3.19-dna.jar:${DNAHOME}/ext/jars/xerces.jar:${DNAHOME}/ext/jars/gnu-regexp-1.1.4.jar:${CLASSPATH}" >> ${SHELL_SETUP}
echo "export STAC_PARAMETERS=\" -DSTACDIR=\"${STACDIR}\" -DSPECDEF=\"${SPECDEF}\" -DBCMDEF=\"${BCMDEF}" >> ${SHELL_SETUP}
echo "export PYTHONPATH=${DNAHOME}/es/src:${DNAHOME}/xsd/python:${DNAHOME}/scheduler/Scheduler/Mosflm:${DNAHOME}/scheduler/DiffractionImage/lib:${DNAHOME}/ext/lib" >> ${SHELL_SETUP}



# convert bash to csh
export SHELL_SETUPCSH="${DNAHOME}/scripts/dna_setup_${SYS_DNA_NAME}.csh"
cat $SHELL_SETUP | sed 's/export/setenv/' | sed 's/=/ /' > $SHELL_SETUPCSH
export SHELL_SETUPDOS="${DNAHOME}/scripts/dna_setup_${SYS_DNA_NAME}.bat"
cat $SHELL_SETUP | sed 's/export/set/' | sed 's/${/%/' | sed 's/}/%/' | sed 's/#/REM/' > $SHELL_SETUPDOS

# add automatic ccp4 installation
echo ". ${CCP4}/include/ccp4.setup-bash" >> ${SHELL_SETUP}
echo "source ${CCP4}/include/ccp4.setup-csh" >> ${SHELL_SETUPCSH}

echo "All done, have a go!"
echo "Try this:"
echo "cd ${DNAHOME}/scripts"
echo ". ${SHELL_SETUP}"
echo "./test_dna komodo eclipse ..."
echo
echo "Or this if you use csh:"
echo "cd ${DNAHOME}/scripts"
echo "source ${SHELL_SETUPCSH}"
echo "./test_dna komodo eclipse ..."

