
import socket, sys, os, os.path, pprint, time

DNAHOME=os.environ[ "DNAHOME" ]
sys.path.append( os.path.join( DNAHOME, "xsd", "python" ))
sys.path.append( os.path.join( DNAHOME, "es", "src" ))


from Debug import *
from XML_utils import *
import XSD


class DNAConfigurator:

    def isSocketFree( _iPortNumber ):
        value = True
        try:
            s = socket.socket()
            s.bind( ( socket.gethostname(), _iPortNumber ) )
            s.close()
        except:
            value = False
        return value
    isSocketFree = staticmethod( isSocketFree )


    def findFreeSocket( _iStartPortNo, _iEndPortNo ):
        iPortNo = _iStartPortNo
        bFoundFlag = False
        while( not bFoundFlag ):
            if DNAConfigurator.isSocketFree( iPortNo ):
                bFoundFlag = True
            else:
                iPortNo += 1
            if iPortNo > _iEndPortNo:
                raise "DNAConfigrator ERROR: no free port found in the range %d to %d!" % \
                      ( _iStartPortNo, _iEndPortNo )
        return iPortNo
    findFreeSocket = staticmethod( findFreeSocket )


    def getUserDefaultsFileName():
        """
        Returns the path to the user defaults XML file.
        """
        strFileName = None
        if "DNA_USER_DEFAULTS" in os.environ.keys():
            strFileName = os.environ["DNA_USER_DEFAULTS"]
        else:
            strFileName = os.path.join(os.environ["HOME"], ".dna", "user_defaults.xml")
            if not os.access(os.path.join(os.environ["HOME"], ".dna"), os.F_OK):
                os.system("mkdir -p %s" % os.path.join(os.environ["HOME"], ".dna"))
        return strFileName
    getUserDefaultsFileName = staticmethod( getUserDefaultsFileName )


    def getUserDefaults():
        """
        Try to read user defaults file.
        """
        oxsdUserDefaults = XSD.User_defaults()
        strFileName = DNAConfigurator.getUserDefaultsFileName()
        if os.access( strFileName, os.F_OK ):
            #
            #print "DNA Configurator: Trying to read user defaults configuration file..."
            try:
                file = open( strFileName )
                user_defaults_xml = file.read()
                Debug.out("In DNAConfig, reading user defaults: %s" % user_defaults_xml, 2)
                oxsdUserDefaults.unmarshal(user_defaults_xml)
                file.close()
            except:
                oxsdUserDefaults = None
                print "DNA Configurator: Error when trying to read user defaults file %s" % strFileName
                raise
        else:
            #
            print "DNA Configurator: No user defaults file exists - creating one!"
            #print "DNA Configurator: Ooops... sorry - not implemented yet..."
            #sys.exit(1)
            user_defaults_xml = """<?xml version="1.0"?>
<user_defaults>
  <default_values>
    <fileinfo>
      <directory>%s</directory>
      <prefix>trypsin</prefix>
      <run_number>1</run_number>
    </fileinfo>
    <oscillation_sequence>
      <start>1.000000</start>
      <range>1.000000</range>
      <number_of_images>1</number_of_images>
      <exposure_time>1.000000</exposure_time>
      <start_image_number>1</start_image_number>
    </oscillation_sequence>
    <detector>
      <type>marccd</type>
    </detector>
    <beam>
      <x>82.090000</x>
      <y>80.640000</y>
    </beam>
    <resolution>2.500000</resolution>
  </default_values>
  <index_parameters>
    <warning_index_spot_rms_error>0.200000</warning_index_spot_rms_error>
    <max_index_spot_rms_error>0.400000</max_index_spot_rms_error>
    <warning_beam_shift>0.200000</warning_beam_shift>
    <max_beam_shift>0.400000</max_beam_shift>
    <warning_index_spot_frac_rejected>0.200000</warning_index_spot_frac_rejected>
    <max_index_spot_frac_rejected>0.400000</max_index_spot_frac_rejected>
    <min_threshold_I_sigma>11.000000</min_threshold_I_sigma>
  </index_parameters>
  <strategy_parameters>
    <overlap_limit>2.000000</overlap_limit>
  </strategy_parameters>
  <server_data>
    <expert_system_host_name>tarzan1</expert_system_host_name>
    <expert_system_port_number>1112</expert_system_port_number>
    <dpm_log_file>/tmp/dna_mosflm_svensson.log</dpm_log_file>
    <mosflm_executable>ipmosflm_rh9.6.2.6b.13jan06</mosflm_executable>
    <bcm_host_name>tarzan1</bcm_host_name>
    <bcm_port_number>51992</bcm_port_number>
    <db_host_name>tarzan1</db_host_name>
    <db_port_number>1111</db_port_number>
    <gui_host_name>tarzan1</gui_host_name>
    <gui_port_number>1113</gui_port_number>
    <timeout_length>999</timeout_length>
  </server_data>
</user_defaults>""" % os.getcwd()
            oxsdUserDefaults.unmarshal(user_defaults_xml)
            #
        return oxsdUserDefaults
    getUserDefaults = staticmethod( getUserDefaults )


    def getSystemDefaults():
        """
        Try to read the system defaults file
        """
        oxsdSystemDefaults = XSD.System_defaults()
        if "DNA_SYSTEM_DEFAULTS" in os.environ.keys():
            strFileName = os.environ["DNA_SYSTEM_DEFAULTS"]
        else:
            strFileName = os.path.join(os.environ[ "DNAHOME" ],
                                       "config",
                                       os.environ["DNANAME"],
                                       "system_defaults.xml" )
        try:
            file = open( strFileName )
            strXMLSystemDefaults = file.read()
            Debug.out("In DNAConfig, reading system defaults: %s" % strXMLSystemDefaults, 2)
            oxsdSystemDefaults.unmarshal( strXMLSystemDefaults )
            file.close()
        except:
            oxsdSystemDefaults = None
            print "DNA Configurator: Error when trying to read system defaults file %s" % strFileName
	    raise
        return oxsdSystemDefaults
    getSystemDefaults = staticmethod( getSystemDefaults )
    

    def getMosflmLogPath():
        """
        Returns a unique path to the MOSFLM log file that is writable.
        """
        strMosflmLogPath = DNAConfigurator.buildMosflmLogPath()
        Debug.out( "DNAConfigurator.getMosflmLogPath: Trying %s" % strMosflmLogPath , 1 )
        if os.path.exists( strMosflmLogPath ):
            #
            # Path already exists - check that we can write to this path
            #
            if not os.access( strMosflmLogPath, os.W_OK ):
                #
                # Probably owned by simeone else! Try again by adding an index.
                #
                iIndex = 1
                bSuccess = False
                while( not bSuccess ):
                    strMosflmLogPath = DNAConfigurator.buildMosflmLogPath( iIndex)
                    Debug.out( "DNAConfigurator.getMosflmLogPath: Trying %s" % strMosflmLogPath , 1 )
                    if not os.path.exists( strMosflmLogPath ):
                        bSuccess = True
                    elif os.access( strMosflmLogPath, os.W_OK ):
                        bSuccess = True
                    else:
                        iIndex += 1
        #
        # We should now have found an unique path.
        # Check hat we can write to it if it doesn't exist.
        #
        if not os.path.exists( strMosflmLogPath ):
            try:
                f = open( strMosflmLogPath, "w" )
                f.write("1")
                f.close()
                os.remove( strMosflmLogPath )
            except:
                raise "ERROR in DNAConfigurator: MOSFLM log file not accessible: %s" % strMosflmLogPath 
        #
        #
        #
        return strMosflmLogPath
    getMosflmLogPath = staticmethod( getMosflmLogPath )


    def buildMosflmLogPath( _iIndex = None ):
        strUser = None
        if "USER" in os.environ.keys():
            strUser = os.environ[ "USER" ]
        strFileName = "dna_mosflm"
        if strUser != None:                             
            strFileName += "_%s" % ( strUser )
        strTime = time.strftime( "_%Y%m%d", time.localtime(time.time() ) )
        strFileName += strTime
        if _iIndex != None:
            strFileName += "_%i" % _iIndex
        strFileName += ".log"
        strMosflmLogPath = os.path.join( "/tmp", strFileName )
        return strMosflmLogPath
    buildMosflmLogPath = staticmethod( buildMosflmLogPath )


    def writeUserDefaults( _oxsdUserDefaults ):
        strFileName = DNAConfigurator.getUserDefaultsFileName()
        file = open( strFileName, "w")
        strXmlUserDefaults = XML_utils.xml_with_indentations( _oxsdUserDefaults.marshal() )
        file.write( strXmlUserDefaults )
        file.close()
    writeUserDefaults = staticmethod( writeUserDefaults )


    def userDefaultsConfigurator():
    
        oxsdUserDefaults   = DNAConfigurator.getUserDefaults()
        if oxsdUserDefaults is None:
            raise "DNAConfigurator.userDefaultsConfigurator: ERROR - cannot read user defaults configuration file."

        oxsdSystemDefaults = DNAConfigurator.getSystemDefaults()
        if oxsdSystemDefaults is None:
            raise "DNAConbfigureator.userDefaultsConfigurator: ERROR - cannot read system defaults configuration file."

        strHostName  = socket.gethostname()

        # Check if run on system_defauls.expert_system_host_name...

        strHostNameES       = oxsdSystemDefaults.getServer_data().getExpert_system_host_name()
        iPortNumberES       = oxsdSystemDefaults.getServer_data().getExpert_system_port_number()
        strHostNameGUI      = oxsdSystemDefaults.getServer_data().getGui_host_name()
        iPortNumberGUI      = oxsdSystemDefaults.getServer_data().getGui_port_number()
        strMosflmLogPath    = DNAConfigurator.getMosflmLogPath()
        strMosflmExecutable = oxsdSystemDefaults.getServer_data().getMosflm_executable()
        strHostNameBCM      = oxsdSystemDefaults.getServer_data().getBcm_host_name()
        iPortNumberBCM      = oxsdSystemDefaults.getServer_data().getBcm_port_number()
        strHostNameDB       = oxsdSystemDefaults.getServer_data().getDb_host_name()
        iPortNumberDB       = oxsdSystemDefaults.getServer_data().getDb_port_number()
        iLengthTimeout      = oxsdSystemDefaults.getServer_data().getTimeout_length()
        
                    
        if strHostName != strHostNameES:

            print "OBS! Not run on host %s - the BCM communication might not work correctly." % strHostNameES

	    if strHostNameES != "localhost":
                strHostNameES  = strHostName
                strHostNameGUI = strHostName
            
            iStartPortNo        = 40000
            iEndPortNo          = 50000

            # First check if ES system_defaults port number is free:

            iPortNumberES = oxsdSystemDefaults.getServer_data().getExpert_system_port_number()
            if not DNAConfigurator.isSocketFree( iPortNumberES ):
                # Not free! Must get another one...
                iPortNumberESOrig = iPortNumberES
                iPortNumberES     = DNAConfigurator.findFreeSocket( iStartPortNo, iEndPortNo )
                iStartPortNo      = iPortNumberES + 1
                print "OBS! ES port number changed from %d to %d - the connection to the BCM might not work correctly!" % \
                  ( iPortNumberESOrig, iPortNumberES )
            
            iPortNumberGUI = oxsdSystemDefaults.getServer_data().getGui_port_number()
            if not DNAConfigurator.isSocketFree( iPortNumberGUI ):
                # Not free! Must get another one...
                iPortNumberGUI      = DNAConfigurator.findFreeSocket( iStartPortNo, iEndPortNo )


        if oxsdUserDefaults.getServer_data() is None:
            oxsdServerData = XSD.Server_data()
        else:
            oxsdServerData = oxsdUserDefaults.getServer_data()
            
        oxsdServerData.setExpert_system_host_name(     strHostNameES )
        oxsdServerData.setExpert_system_port_number(   iPortNumberES )
        oxsdServerData.setDpm_log_file(                strMosflmLogPath )
        oxsdServerData.setMosflm_executable(           strMosflmExecutable )
        oxsdServerData.setBcm_host_name(               strHostNameBCM )
        oxsdServerData.setBcm_port_number(             iPortNumberBCM )
        oxsdServerData.setDb_host_name(                strHostNameDB )
        oxsdServerData.setDb_port_number(              iPortNumberDB )
        oxsdServerData.setGui_host_name(               strHostNameGUI )
        oxsdServerData.setGui_port_number(             iPortNumberGUI )
        oxsdServerData.setTimeout_length(              iLengthTimeout )

        oxsdUserDefaults.setServer_data( oxsdServerData )

        #pprint.pprint( oxsdUserDefaults.toDict() )
        Debug.out( pprint.pformat( oxsdUserDefaults.toDict() ), 1 )

        DNAConfigurator.writeUserDefaults( oxsdUserDefaults )
    userDefaultsConfigurator = staticmethod( userDefaultsConfigurator )




if __name__ == "__main__":

    configurator = DNAConfigurator()
    DNAConfigurator.userDefaultsConfigurator()

    #print "Test 'isSocketFree':"
    #print configurator.isSocketFree( 40001 )

    #print
    #print "Test 'findFreeSocket':"
    #print configurator.findFreeSocket( 40000, 50000 )

    #print
    #print "Test 'getUserDefaults':"
    #oxsdUserDefaults = configurator.getUserDefaults()
    #print oxsdUserDefaults.toDict()

    #print
    #print "Test 'getSystemDefaults':"
    #oxsdSystemDefaults = configurator.getSystemDefaults()
    #print oxsdSystemDefaults.toDict()

    #print
    #print "Test 'getMosflmLogPath':"
    #print configurator.getMosflmLogPath()

    #print
    #print "Test 'userDefaultsConnfigurator':"
