#!/usr/bin/env python
# A script to test if there is an existing GUI already running on this
# machine. This will work by trying to make a connection to the GUI
# (as configured in the system_config file) and returning "ok"
# if that fails or "error" if it succeeds.
# 
#

import socket, os, sys

# check that the DNA environment is configured at start-up

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

dnahome = os.environ['DNAHOME']

if not os.environ.has_key('DNANAME'):
    raise RuntimeError, 'DNANAME not defined'

# add access to xsd

sys.path.append('%s/xsd/python' % dnahome)
import XSD

def connect(host, port):
    '''Attempt to open a new socket connecting to host on port'''

    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.connect((str(host), int(port)))
        s.close()
        return "error"
    except socket.error:
        return "ok"

    # generic exception handling
    except:
        pass

    return

def read_system_defaults():
    '''A routine to pick up the system defaults file'''

    system_defaults = XSD.System_defaults()

    # construct the filename
    system_defaults_filename = '%s/config/%s/system_defaults.xml' % \
                               (os.environ['DNAHOME'],
                                os.environ['DNANAME'])

    # read the file
    system_defaults_xml = open(system_defaults_filename, 'r').read()

    # parse into object
    system_defaults.unmarshal(system_defaults_xml)

    return system_defaults
    
def check_for_running_gui():
    '''check for a running DNA gui on port and host from the
    system_defaults.xml file'''

    # get the system defaults file
    system_defaults = read_system_defaults()

    # from this obtain the gui host/port information
    host = system_defaults.getServer_data().getGui_host_name()
    port = system_defaults.getServer_data().getGui_port_number()
    
    return connect(host, port)

if __name__ == '__main__':
    '''Look for a running GUI on the system here configured'''

    if len(sys.argv) > 1 and \
           sys.argv[1] == '-v':
        sys.stdout.write('Checking for running GUI\n')
        sys.stdout.write('ok -> no running GUI\n')
        sys.stdout.write('error -> GUI already running\n')        
        
    sys.stdout.write('%s\n' % check_for_running_gui())


