      program mtzquery

      implicit none

c     .. parameters ..
      integer maxpar
      parameter (maxpar=200)
      integer mcols
      parameter (mcols=200)
      integer maxsets
      parameter (maxsets=20)
      integer maxsym
      parameter (maxsym=96)

      integer i, j,lentit,mtzerr,mtzin,mtzprt,nlprgi,lenstr,numcol,
     +     nreflx,nspgrp,nsym,nsymp,ndatasets,
     +     inhkl(3),mtzlok(mcols),isets(maxsets)
      real s,fa,sa,rsym(4,4,maxsym),celmtz(6),rngmtz(2,mcols),
     +     recin(mcols),sminwl,smaxwl,
     +     datcell(6,maxsets),datwave(maxsets), dmin, dmax
      logical mtzeof,logmss(mcols)
      character lattyp*1,namspg*10,pgname*10,versnx*10,
     +     ctprgi(mcols)*1,lsprgi(mcols)*30,titin*80,
     +     pname(maxsets)*64,xname(maxsets)*64,dname(maxsets)*64

c parser variables
      character dna_filename*80

      data nlprgi /5/
      data (lsprgi(j),j=1,200) /'H','K','L','F','SIGF',195*' '/
      data (ctprgi(j),j=1,200) /'H','H','H','F','Q',195*' '/
      data mtzlok/5*-1,195*0/

c ccp4 initialisations
      call ccpfyp

      call ugtenv('DNA', dna_filename)
      if (dna_filename .ne. '') then
         call dna_start(dna_filename, 'mtzquery')
      else
         call dna_set_no_output
      end if

      call dna_table_start('header_info')
      call dna_list_start('version_information')
      call dna_character_item('version', 
     +     '$Id: mtzquery.f,v 1.5 2005/11/22 13:38:15 svensson Exp $')
      call dna_list_end
      call dna_table_end

c mtz-specific initialisations
      call mtzini

c open input file
      mtzin = 1
      mtzprt = 0
      mtzerr = 0
      call lropen(mtzin,'HKLIN',mtzprt,mtzerr)

c   get header info
      numcol = mcols
      call lrinfo(mtzin,versnx,numcol,nreflx,rngmtz)
      call lrtitl(mtzin,titin,lentit)
      call lrcell(mtzin,celmtz)
      call lrrsol(mtzin,sminwl,smaxwl)
      call lrsymi(mtzin,nsymp,lattyp,nspgrp,namspg,pgname)
      if (nspgrp.gt.0) then
        call lrsymm(mtzin,nsym,rsym)
      end if
      numcol = mcols
      call lrclab(mtzin, lsprgi, ctprgi, numcol)

c   set up column assignments based on labin
c     call lrassn(mtzin,lsprgi,nlprgi,mtzlok,ctprgi)

c   *** for ccp4 5.0 libraries
c   read in the crystal, project, dataset and set id
c   information, plus the cell parameters and wavelengths,
c   associated with each dataset
      ndatasets = maxsets
      call lridx(mtzin,pname,xname,dname,isets,
     +     datcell,datwave,ndatasets)


      call dna_table_start('column_info')
      do i = 1, numcol
         call dna_ilist_start('column', i)
         call dna_character_item('name', lsprgi(i)(1:lenstr(lsprgi(i))))
         call dna_character_item('type', ctprgi(i))
         call dna_list_end
      end do
      call dna_table_end

      call dna_table_start('reflection_file_info')
      do i = 1, ndatasets
         call dna_ilist_start('dataset_info', i)
         call dna_real_item('a', datcell(1, i))
         call dna_real_item('b', datcell(2, i))
         call dna_real_item('c', datcell(3, i))
         call dna_real_item('alpha', datcell(4, i))
         call dna_real_item('beta', datcell(5, i))
         call dna_real_item('gamma', datcell(6, i))

         call dna_character_item('spacegroup', namspg)
         call dna_real_item('wavelength', datwave(i))
         call dna_list_end
      end do

      call dna_table_end

      dmin = 100.0
      dmax = 0.0

  110 call lrrefl(mtzin,s,recin,mtzeof)
      if (mtzeof) go to 230

      if (sqrt(1.0 / s) .lt. dmin) dmin = sqrt(1.0 / s)
      if (sqrt(1.0 / s) .gt. dmax) dmax = sqrt(1.0 / s)

c check for missing number flags
      call lrrefm(mtzin,logmss)
      if( logmss(mtzlok(4)) .or. logmss(mtzlok(5))) go to 110

c check resolution limits
      if (s.lt.sminwl .or. s.gt.smaxwl) go to 110

c read data
      do 120, i=1,3
         inhkl(i) = nint(recin(i))
 120  continue
      fa = recin(mtzlok(4))
      sa = recin(mtzlok(5))

      go to 110

c end of file
  230 continue

c     resolution limits are only available from actually 
c     reading all of the reflections in the file :o(
c     hence above calculation

      call dna_table_start('resolution_limits')
      call dna_list_start('limits')
      call dna_real_item('min', dmin)
      call dna_real_item('max', dmax)
      call dna_list_end
      call dna_table_end

c close file
      call lrclos(mtzin)

      call dna_end

      call ccperr(0,'normal termination')
      end
