#!/usr/bin/env python
# Outlier.py
# Maintained by G.Winter
# 20th January 2005
# 
# Statistical tests for outliers using StatisticalTools.
# 
# 
# 
# 
# $Id: Outlier.py,v 1.3 2005/11/22 13:38:15 svensson Exp $

have_st = True

import math

# FIXME
# 
# This is a hacky mess to test if the StatisticalTools library is available - 
# if it is not it will just return no answers (e.g. no looking for 
# outliers)
# 
# Need a better way to do this - any ideas?
# 

try:
    import StatisticalTools as st
except:
    have_st = False
    # do this to stop the compilation breaking in this circumstance
    st = math
    
def Outlier(list):
    '''Examine the list of numbers list and return a list of outlier
    positions within this list (confidence level: 0.0001 i.e. 99.99%)'''

    if not have_st:
        # we can't check for outliers
        return []

    N = len(list)
    mean = st.mean(list)
    sd = st.sd(list)
    t = st.t(N, 0.0001)

    outliers = []

    for i in range(N):
        l = list[i]

        if math.fabs((l - mean) / sd) > t:
            outliers.append(i)

    return outliers

if __name__ == '__main__':
    '''Test the outlier rejection'''

    import random

    for length in [100, 1000, 10000]:
        list = []
        for i in range(length):
            list.append(random.random())
        position = int(random.random() * length)
        list[position] = 2.0

        outliers = Outlier(list)
        if len(outliers) == 1:
            print 'Success finding outliers'
            print length, position, outliers[0]
        else:
            print 'Failed to correctly find outliers'
            print length, position, outliers

