#!/usr/bin/env python
# PointlessHelper.py
# Maintained by G.Winter
# 20th July 2005
# 
# Some helper routines for preparing data for pointless. In particular this
# will mostly just reduce the amount of data to about 15 degrees, since this
# seems to be a sensible amount.
# 
# 
# $Id: PointlessHelper.py,v 1.3 2005/11/22 13:38:15 svensson Exp $

import sys, os

if not os.environ.has_key('XIAHOME'):
    raise RuntimeError, 'XIAHOME not defined'

if not os.environ.has_key('CCP4'):
    raise RuntimeError, 'CCP4 not defined'

sys.path.append(os.path.join(os.environ['XIAHOME'],
                             'scheduler',
                             'Scheduler',
                             'CCP4'))

import Rebatch
import Mtzq

def LimitBatches15Deg(hklin, hklout):
    '''Prepare hklin for use with pointless - this will simply limit the
    number of batches to 15 degrees worth. Will return if(changed)'''


    # interrogate the input reflection file

    mtz = Mtzq.Mtzq(hklin)
    
    batch_range = mtz.getBatches()
    rotation_range = mtz.getRotation()

    if batch_range == (-1, -1, -1):
        raise RuntimeError, 'File %s is not unmerged' % hklin

    total_batches = batch_range[2]
    total_rotation = 5.0 * int(rotation_range[2] / 5)
    rotation_per_batch = total_rotation / total_batches
    want_batches = int(15.0 / rotation_per_batch)

    start = batch_range[0]
    end = batch_range[0] + want_batches - 1

    if end > batch_range[1]:
        # we don't need to remove any batches
        return False

    rebatch = Rebatch.Rebatch()

    rebatch.setHklin(hklin)
    rebatch.setHklout(hklout)
    rebatch.range(start, end)
    rebatch.run()

    return True

if __name__ == '__main__':

    if len(sys.argv) < 3:
        raise RuntimeError, '%s hklin hklout' % sys.argv[0]

    hklin = sys.argv[1]
    hklout = sys.argv[2]

    if not hklin[0] == '/' and not hklin[0] == '~':
        hklin = os.path.join(os.getcwd(), hklin)

    if not hklout[0] == '/' and not hklout[0] == '~':
        hklout = os.path.join(os.getcwd(), hklout)

    status = LimitBatches15Deg(hklin, hklout)

    if status:
        print 'performed rebatch'
    else:
        print 'did not perform rebatch'
