#!/usr/bin/env python
# PGInfo.py
# Maintained by G.Winter
# 10th March 2006
# 
# Static pointgroup information derived from the CCP4 symmetry libraries.
# Used for populating the DNA database and other gems.
# 
# 
# 

import os

if not os.environ.has_key('CCP4'):
    raise RuntimeError, 'CCP4 not defined'

ccp4 = os.environ['CCP4']

import os

def init():

    data = { }
    
    for line in open(os.path.join(ccp4,
                                  'lib', 'data',
                                  'symop.lib'), 'r').readlines():
        if not line[0] == ' ':
            list = line.split()
            num = int(list[0])
            spag = list[3]
            point = list[4]
            latt = list[5].lower()

            data[num] = (spag, point, latt)

    return data

class _store:
    def __init__(self):
        self.data = init()

    def get(self, spgnum):
        return self.data[spgnum]

store = _store()

if __name__ == '__main__':
    for i in range(1, 50):
        print '%s %s %s' % store.get(i)

