#################################################################
#
# SchedulerDNAConfig.py
#
# Authors: The DNA team, http://www.dna.ac.uk  
#
# Version: $Id: SchedulerDNAConfig.py,v 1.4 2004/05/25 13:41:46 svensson Exp $
#
#################################################################

import os, os.path, sys, re

from Messenger import *

if not os.environ.has_key('DNAHOME'):
  raise RuntimeError, 'DNAHOME not defined'

dna = os.environ['DNAHOME']
sys.path.append(dna + '/xsd/python')

import XSD
from XML_utils import *

class SchedulerDNAConfig:

  def __init__(self):
    self.ES_host = None
    self.ES_port = None

  # changed this method name to keep in track with Messenger
  def set_host_port(self, ES_host, ES_port):
    self.ES_host = ES_host
    self.ES_port = ES_port

  def getUser_defaults(self):
    if self.ES_host is None:
      return None
    #
    # Read the user defaults configuration file directly from the Executive.
    #
    dna_configuration_request = XSD.Dna_configuration_request()
    xml_message = XML_utils.http_post(self.ES_host, self.ES_port,
                                      "/dna_configuration_request",
                                      dna_configuration_request.marshal())
    dna_configuration_response = XSD.Dna_configuration_response()
    dna_configuration_response.unmarshal(xml_message)
    self.user_defaults = dna_configuration_response.getUser_defaults()
    return self.user_defaults

  def setUser_defaults(self, the_user_defaults):
    self.user_defaults = the_user_defaults
    if self.ES_host is None:
      raise RuntimeError, "ES host not defined in SchedulerDNAConfig!"
    dna_configuration_request = XSD.Dna_configuration_request()
    dna_configuration_request.setUser_defaults(self.user_defaults)
    xml_message = XML_utils.http_post(self.ES_host, self.ES_port,
                                      "/dna_configuration_request",
                                      dna_configuration_request.marshal())
    dna_configuration_response = XSD.Dna_configuration_response()
    dna_configuration_response.unmarshal(xml_message)
    self.user_defaults = dna_configuration_response.getUser_defaults()
  

  def getDna_context(self):
    if self.ES_host is None:
      return None
    #
    # Read the user defaults configuration file directly from the Executive.
    #
    dna_context_request = XSD.Dna_context_request()
    xml_message = XML_utils.http_post(self.ES_host, self.ES_port,
                                      "/dna_context_request",
                                      dna_context_request.marshal())
    dna_context_response = XSD.Dna_context_response()
    dna_context_response.unmarshal(xml_message)
    self.dna_context = dna_context_response.getDna_context()
    return self.dna_context



  def __call__(self):
    return self    

# this is a singleton so create a single instance of this...
SchedulerDNAConfig = SchedulerDNAConfig()




