################################################################
#
# ResultWebPages.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
#################################################################
# this needn't be a class - a set of static methods will be fine

# get access to the Messenger singleton

from Messenger import Messenger
from Somewhere import Somewhere

# regular expressions for handling the templates etc - this could be
# encapsulated elsewhere I guess

import re, shutil, os, sys, math

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

dna = os.environ['DNAHOME']

sys.path.append(dna + '/scheduler/Scheduler/Driver')

import Plotter

def write_index_result(log_dir, index_request, \
                       index_response_1, index_response_2, \
                       index_response):

    # should not be using os.system - I suspect that this is a substantial
    # security hole! -> convert to using the native os interactions
    # done!
  
    directory = "%s/index" % log_dir

    try:
        os.mkdir(directory)
    except:
        # this probably indicates that the directory already exists
        pass

    # Move the jpegs with the diffraction pattern
  
    Messenger.log_write("Making jpeg images in %s" % directory)
    
    # see if we're using prefix or template
    if index_request.getFileinfo().getPrefix():
        # I don't like having 1, 91 hard coded in here...
        # so take that away then!
        image_name_image1 = "%s_%d_%03d" % \
                            (index_request.getFileinfo().getPrefix(), \
                             index_request.getFileinfo().getRun_number(),
                             int(index_request.getImage()[0]))
        image_path_image1 = "%s/%s.%s" % \
                            (index_request.getFileinfo().getDirectory(), \
                             image_name_image1, \
                             index_request.getFileinfo().getSuffix())
        image_name_image2 = "%s_%d_%03d" % \
                            (index_request.getFileinfo().getPrefix(), \
                             index_request.getFileinfo().getRun_number(), \
                             int(index_request.getImage()[1]))
        image_path_image2 = "%s/%s.%s" % \
                            (index_request.getFileinfo().getDirectory(), \
                             image_name_image2,
                             index_request.getFileinfo().getSuffix())
        
    else:
        # we should construct the filenames from the template and so on
        # this will make use of regular expressions...
        
        regexp = re.compile(r'(.*)_(\#*)\.(.*)')
        
        template = index_request.getFileinfo().getTemplate()
        match = regexp.match(template)
        
        prefix = match.group(1)
        indexLength = len(match.group(2))
        extension = match.group(3)
        
        images = index_request.getImage()
        
        image = int(images[0])
        format = '%0' + str(indexLength) + 'd'
        number = format % image
        image_name_image1 = prefix + '_' + number
        image_path_image1 = '%s/%s.%s' % \
                            (index_request.getFileinfo().getDirectory(),
                             image_name_image1,
                             extension)
        
        image = int(images[1])
        format = '%0' + str(indexLength) + 'd'
        number = format % image
        image_name_image2 = prefix + '_' + number
        image_path_image2 = '%s/%s.%s' % \
                            (index_request.getFileinfo().getDirectory(),
                             image_name_image2,
                             extension)
        
        
    dnatmpdir = None
    if "DNATMPDIR" in os.environ.keys():
        dnatmpdir = os.environ["DNATMPDIR"]
    else:
        dnatmpdir = "."
        
    # add the source location of the images
    dnatmpdir += '/autoindex_all'

    # copy the log file over
    try:
        shutil.copyfile('%s/%s' % (dnatmpdir, 'mosflm.log'),
                        '%s/%s' % (directory, 'mosflm.log'))
    except:
        pass
    
    # change os.system() calls to shutil.copyfile() calls
    
    try:
        shutil.copyfile('%s/%s.jpg' % (dnatmpdir, image_name_image1),
                        '%s/%s.jpg' % (directory, image_name_image1))
    except:
        pass
    
    try:
        shutil.copyfile('%s/%s.jpg' % (dnatmpdir, image_name_image2),
                        '%s/%s.jpg' % (directory, image_name_image2))
    except:
        pass
    
    
    try:
        shutil.copyfile('%s/%s_pred.jpg' % \
                        (dnatmpdir, image_name_image1),
                        '%s/%s_pred.jpg' % \
                        (directory, image_name_image1))
    except:
        pass
    
    try:
        shutil.copyfile('%s/%s_pred.jpg' % \
                        (dnatmpdir, image_name_image2),
                        '%s/%s_pred.jpg' % \
                        (directory, image_name_image2))
    except:
        pass
      
      
    try:
        shutil.copyfile('%s/%s_small.jpg' % \
                        (dnatmpdir, image_name_image1),
                        '%s/%s_small.jpg' % \
                        (directory, image_name_image1))
    except:
        pass
    
    try:
        shutil.copyfile('%s/%s_small.jpg' % \
                        (dnatmpdir, image_name_image2),
                        '%s/%s_small.jpg' % \
                        (directory, image_name_image2))
    except:
        pass
    
      
    try:
        shutil.copyfile('%s/%s_pred_small.jpg' % \
                        (dnatmpdir, image_name_image1),
                        '%s/%s_pred_small.jpg' % \
                        (directory, image_name_image1))
    except:
        pass
    
    try:
        shutil.copyfile('%s/%s_pred_small.jpg' % \
                        (dnatmpdir, image_name_image2),
                        '%s/%s_pred_small.jpg' % \
                        (directory, image_name_image2))
    except:
        pass
    
    
    
    # Start writing the web page
    
    webpage = open("%s/index.html" % directory, "w")
    webpage.write("<HTML>\n")
    webpage.write("<HEAD>\n")
    webpage.write("<TITLE>Index results</TITLE>\n")
    webpage.write("</HEAD>\n")
    webpage.write("<BODY BGCOLOR=\"#FFFFFF\">\n")
    webpage.write("<CENTER><H1>Index results</H1></CENTER>\n")
    webpage.write("<H3>Symmetry and refined cell parameters</H3>\n")
    webpage.write("<TABLE WIDTH=100% BORDER=2>\n")
    webpage.write("<TR ALIGN=CENTER>\n")
    webpage.write("  <TD>Image</TD>\n")
    webpage.write("  <TD>Symmetry</TD>\n")
    webpage.write("  <TD>a</TD>\n")
    webpage.write("  <TD>b</TD>\n")
    webpage.write("  <TD>c</TD>\n")
    webpage.write("  <TD>alpha</TD>\n")
    webpage.write("  <TD>beta</TD>\n")
    webpage.write("  <TD>gamma</TD>\n")
    webpage.write("</TR>\n")
    indexing_failed = ''
    try:
        write_html_table_symmetry_cell(webpage, "1", index_response_1)
    except:
        indexing_failed += '<p>Failed for image 1</p>'
    try:
        write_html_table_symmetry_cell(webpage, "2", index_response_2)
    except:
        indexing_failed += '<p>Failed for image 2</p>'
    try:
        write_html_table_symmetry_cell(webpage, "1+2", index_response)
    except:
        indexing_failed += '<p>Failed for image 1 + 2</p>'        
    webpage.write("</TABLE>\n")

    if indexing_failed != '':
        webpage.write('Indexing failed in some cases: %s' % indexing_failed)
    
    webpage.write("<H3>Spots found, rejected, RMS spot deviation, beamcentre shift</H3>\n")
    webpage.write("<TABLE WIDTH=100% BORDER=2>\n")
    webpage.write("<TR ALIGN=CENTER>\n")
    webpage.write("  <TD>Image</TD>\n")
    webpage.write("  <TD>Spots used in refinement</TD>\n")
    webpage.write("  <TD>Spots used in indexing</TD>\n")
    webpage.write("  <TD>Fraction rejected from refinement</TD>\n")
    webpage.write("  <TD>RMS spot deviation</TD>\n")
    webpage.write("  <TD>Beam shift x</TD>\n")
    webpage.write("  <TD>Beam shift y</TD>\n")
    webpage.write("</TR>\n")
    refinement_failed = ''
    try:
        write_html_table_spots(webpage, "1", index_response_1)
    except:
        refinement_failed += '<p>Refinement failed for image 1</p>'
    try:
        write_html_table_spots(webpage, "2", index_response_2)
    except:
        refinement_failed += '<p>Refinement failed for image 2</p>'
    try:        
        write_html_table_spots(webpage, "1+2", index_response)
    except:
        refinement_failed += '<p>Refinement failed for image 1 + 2</p>'

    webpage.write("</TABLE>\n")

    if refinement_failed != '':
        webpage.write('Refinement failed %s' % refinement_failed)
    
    webpage.write("<H3>Image 1: %s</H3>\n" % str(image_path_image1))
    webpage.write("<A HREF=\"image1.html\"><IMG SRC=\"%s_small.jpg\"></A>\n" % 
                  str(image_name_image1))
    webpage.write("<H3>Image 2: %s</H3>\n" % str(image_path_image2))
    webpage.write("<A HREF=\"image2.html\"><IMG SRC=\"%s_small.jpg\"></A>\n" % \
                  str(image_name_image2))
    webpage.write("<H3>Image 1 with predictions</H3>\n")
    webpage.write("<A HREF=\"image1_pred.html\"><IMG SRC=\"%s_pred_small.jpg\"></A>\n" % \
                  str(image_name_image1))
    webpage.write("<H3>Image 2 with predictions</H3>\n")
    webpage.write("<A HREF=\"image2_pred.html\"><IMG SRC=\"%s_pred_small.jpg\"></A>\n" % \
                  str(image_name_image2))


    webpage.write("<p>The following comments were " + \
                  "recorded by the Expert system:</p>")
    
    webpage.write(Messenger.web())

    webpage.write("<p>End of comments</p>")

    webpage.write("<A HREF=\"dpm_log.html\"><H3>Data Processing Module Log</H3></A>\n")    
    

    webpage.write("<A HREF=\"../integrate/index.html\"><H3>Integration Results</H3></A>\n")

    webpage.write("<A HREF=\"../strategy_results/index.html\"><H3>Strategy Results - will not work until you have run STRATEGY!</H3></A>\n")

    webpage.write("</BODY>\n")    
    webpage.write("</HTML>")
    webpage.close()
    
    webpage = open("%s/dpm_log.html" % directory, "w")    
    webpage.write("<HTML>\n")
    webpage.write("<HEAD>\n")
    webpage.write("<TITLE>Data Processing Module Log</TITLE>\n")
    webpage.write("</HEAD>\n")
    webpage.write("<BODY BGCOLOR=\"#FFFFFF\">\n")
    webpage.write("<H3>Data Processing Module Log  - " + \
                  "<A HREF=\"index.html\">Back to the index " + \
                  "result page</A></H3>\n")
    webpage.write("<PRE>\n")

    for line in open('%s/%s' % (directory, 'mosflm.log'), 'r').readlines():
        webpage.write(line)

    webpage.write("</PRE>\n")
    webpage.write("<CENTER><H3><A HREF=\"index.html\">Back to " + \
                  "the index result page</A></H3></CENTER>\n")
    webpage.write("</BODY>\n")    
    webpage.write("</HTML>")
    webpage.close()
    
    write_full_image_page(directory, "image1.html", \
                          image_name_image1, "")
    write_full_image_page(directory, "image2.html", \
                          image_name_image2, "")
    write_full_image_page(directory, "image1_pred.html", \
                          image_name_image1, "_pred")
    write_full_image_page(directory, "image2_pred.html", \
                          image_name_image2, "_pred")

    return

def write_failed_index_result(log_dir,
                              index_request):
    '''Write out a "results" page for failure - which will just
    have the images (as jpeg) and some comments.'''

    directory = "%s/index" % log_dir

    try:
        os.mkdir(directory)
    except:
        # this probably indicates that the directory already exists
        pass

    # Move the jpegs with the diffraction pattern
  
    Messenger.log_write("Making jpeg images in %s" % directory, 2)

    # we should construct the filenames from the template and so on
    # this will make use of regular expressions...
    
    regexp = re.compile(r'(.*)_(\#*)\.(.*)')
    
    template = index_request.getFileinfo().getTemplate()
    match = regexp.match(template)
    
    prefix = match.group(1)
    indexLength = len(match.group(2))
    extension = match.group(3)
    
    images = index_request.getImage()
        
    image = int(images[0])
    format = '%0' + str(indexLength) + 'd'
    number = format % image
    image_name_image1 = prefix + '_' + number
    image_path_image1 = '%s/%s.%s' % \
                        (index_request.getFileinfo().getDirectory(),
                         image_name_image1,
                         extension)
    
    image = int(images[1])
    format = '%0' + str(indexLength) + 'd'
    number = format % image
    image_name_image2 = prefix + '_' + number
    image_path_image2 = '%s/%s.%s' % \
                        (index_request.getFileinfo().getDirectory(),
                         image_name_image2,
                         extension)
    
    dnatmpdir = None
    if "DNATMPDIR" in os.environ.keys():
        dnatmpdir = os.environ["DNATMPDIR"]
    else:
        dnatmpdir = "."
        
    # add the source location of the images
    dnatmpdir += '/failure'

    # copy the files across ...

    try:
        shutil.copyfile('%s/%s_small.jpg' % \
                        (dnatmpdir, image_name_image1),
                        '%s/%s_small.jpg' % \
                        (directory, image_name_image1))
    except:
        pass
    
    try:
        shutil.copyfile('%s/%s_small.jpg' % \
                        (dnatmpdir, image_name_image2),
                        '%s/%s_small.jpg' % \
                        (directory, image_name_image2))
    except:
        pass

    try:
        shutil.copyfile('%s/%s.jpg' % (dnatmpdir, image_name_image1),
                        '%s/%s.jpg' % (directory, image_name_image1))
    except:
        pass
    
    try:
        shutil.copyfile('%s/%s.jpg' % (dnatmpdir, image_name_image2),
                        '%s/%s.jpg' % (directory, image_name_image2))
    except:
        pass
    
    # now start the HTML output

    webpage = open("%s/index.html" % directory, "w")
    webpage.write('<html><head><title>Index Results</title></head>')
    webpage.write('<body><h3>Image display following indexing failure</h3>')
    webpage.write('<h3>Image 1: %s</h3>\n' % str(image_path_image1))
    webpage.write('<a href="image1.html"><img src="%s_small.jpg"></A>\n' % 
                  str(image_name_image1))
    webpage.write('<H3>Image 2: %s</H3>\n' % str(image_path_image2))
    webpage.write('<A HREF="image2.html"><IMG SRC="%s_small.jpg"></A>\n' % \
                  str(image_name_image2))

    # write the "pages" for the full images
    write_full_image_page(directory, "image1.html", \
                          image_name_image1, "")
    write_full_image_page(directory, "image2.html", \
                          image_name_image2, "")
    
    # next write the "expert system" output

    webpage.write("<p>The following comments were " + \
                  "recorded by the Expert system:</p>")
    
    webpage.write(Messenger.web())

    webpage.write("<p>End of comments</p>")

    webpage.write('</body></html>')

    webpage.close()

    

def write_full_image_page(directory, page_name, \
                          image_name, suffix):
    webpage = open("%s/%s" % (directory, page_name), "w")
    webpage.write("<HTML>\n")
    webpage.write("<HEAD>\n")
    webpage.write("<TITLE>Image %s </TITLE>\n" % image_name)
    webpage.write("</HEAD>\n")
    webpage.write("<BODY BGCOLOR=\"#FFFFFF\">\n")
    webpage.write("<CENTER><H1>Image %s</H1></CENTER>\n" % image_name)
    webpage.write("<IMG SRC=\"%s%s.jpg\">\n" % (image_name, suffix) )
    webpage.write("<CENTER><H3><A HREF=\"index.html\">Back to the index result page</A></H3></CENTER>\n")
    webpage.write("</BODY>\n")    
    webpage.write("</HTML>")    
    webpage.close()
    return 

def write_html_table_symmetry_cell(fileobject, \
                                   image, index_response):
    solution = index_response.getSolution()
    cell = solution.getOrientation().getCell()
    fileobject.write("<TR ALIGN=CENTER>\n")
    fileobject.write("  <TD>%s</TD>\n" % (image))
    fileobject.write("  <TD>%s</TD>\n" % (solution.getSymmetry()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getA()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getB()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getC()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getAlpha()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getBeta()))
    fileobject.write("  <TD>%8.3f</TD>\n" % (cell.getGamma()))
    fileobject.write("</TR>\n")
    return 

def write_html_table_spots(fileobject, \
                           image, index_response):
    solution = index_response.getSolution()
    refinement = solution.getRefinement()
    if refinement:
        reflections = refinement.getReflections()
        spots = index_response.getSpot_search_response()
        deltabeam = solution.getRefinement().getBeam_shift().getShift()
        fileobject.write("<TR ALIGN=CENTER>\n")
        fileobject.write("  <TD>%s</TD>\n" % image )
        fileobject.write("  <TD>%d</TD>\n" % reflections.getUsed() )
        fileobject.write("  <TD>%d</TD>\n" % reflections.getUsed_in_indexing())
        fileobject.write("  <TD>%8.3f</TD>\n" % \
                         (1.0 - 1.0* reflections.getUsed() / \
                          reflections.getUsed_in_indexing()) )
        fileobject.write("  <TD>%8.3f</TD>\n" % (solution.getSpot_deviation()))
        fileobject.write("  <TD>%8.3f</TD>\n" % (deltabeam.getX()))
        fileobject.write("  <TD>%8.3f</TD>\n" % (deltabeam.getY()))
        fileobject.write("</TR>\n")
    else:

        fileobject.write("<P><B>Warning! There is no refinement information ")
        fileobject.write("- the refinement probably failed!</B></P>")
    
    return 


def write_single_integrate_result(log_dir,
                                  single_integrate_request,
                                  integrate_response):

    directory = '%s/integrate' % log_dir

    try:
        os.mkdir(directory)
    except:
        pass

    fileinfo = single_integrate_request.getFileinfo()

    # construct some filenames
    regexp = re.compile(r'(.*)_(\#*)\.(.*)')
    
    template = fileinfo.getTemplate()
    match = regexp.match(template)
    
    prefix = match.group(1)
    indexLength = len(match.group(2))
    extension = match.group(3)
    format = '%0' + str(indexLength) + 'd'

    images = single_integrate_request.getImage()

    filenames = []

    for image in images:
        number = format % int(image)
        filenames.append(prefix + '_' + number + '.' + extension)

    webpage = open('%s/index.html' % directory, 'w')
    webpage.write('<html>\n')
    webpage.write('<head>\n')
    webpage.write('<title>Single Image Integration Results</title>\n')
    webpage.write('</head>\n')
    webpage.write('<body>\n')
    webpage.write('<h3>The following images were integrated:</h3>\n')
    for filename in filenames:
        webpage.write('<p>%s</p>\n' % filename)


    webpage.write('<h3>The results from integration were:</h3>\n')

    if not integrate_response.getIntegrated_image():

        webpage.write('No images were integrated!!!')
        webpage.write('<a href="%s/index/index.html"><h3>Back to index results</h3</a>' % log_dir)
        
        webpage.write('</body>\n')
        webpage.write('</html>\n')
        return
        
    for integrated_image in integrate_response.getIntegrated_image():
        number = format % int(integrated_image.getImage())
        filename = prefix + '_' + number + '.' + extension
        webpage.write('<p>%s</p>' % filename)
        resolutions = []
        signals = { }
        bins = integrated_image.getIntegration_bin()
        for b in bins:
            r = b.getResolution()
            u = r.getUpper()
            l = r.getLower()
            m = b.getMeasured_spots_summation()
            f = m.getFull().getSignal_to_noise()
            p = m.getPartial().getSignal_to_noise()
            
            if u != 'overall':
                resolutions.append(float(u))
                signals[float(u)] = float(f)

        resolutions.sort()
        s = []
        x = []
        y = []
        for r in resolutions:
            if math.fabs(r) > 0.01:
                # webpage.write('<p>%f -&gt; %f</p>' % (r, signals[r])) 
                x.append(1.0 / (r * r))
                y.append(signals[r])

        g = Plotter.Plotter()
        g.setLegend('Image %s' % filename,
                    '1/d^2', 'I/sigma')
        g.setData('%s/gnu.tmp' % directory)
        g.setX(x)
        g.setY(y)
        g.setGraph('%s/graph%d.png' % (directory, integrated_image.getImage()))
        g.plot()

        webpage.write('<img src="graph%d.gif">\n' % integrated_image.getImage())
    for integrated_image in integrate_response.getIntegrated_image():
        number = format % int(integrated_image.getImage())
        filename = prefix + '_' + number + '.' + extension
        webpage.write('<p>%s</p>' % filename)
        resolutions = []
        signals = { }
        bins = integrated_image.getIntegration_bin()
        for b in bins:
            r = b.getResolution()
            u = r.getUpper()
            l = r.getLower()
            m = b.getMeasured_spots_summation()
            f = m.getFull().getSignal_to_noise()
            p = m.getPartial().getSignal_to_noise()
            
            if u != 'overall':
                resolutions.append(float(u))
                signals[float(u)] = float(f)

        resolutions.sort()
        s = []
        x = []
        y = []
        for r in resolutions:
            if math.fabs(r) > 0.01:
                # webpage.write('<p>%f -&gt; %f</p>' % (r, signals[r])) 
                x.append(r)
                y.append(signals[r])

        g = Plotter.Plotter()
        g.setLegend('Image %s' % filename,
                    'd', 'I/sigma')
        g.setData('%s/gnu.tmp' % directory)
        g.setX(x)
        g.setY(y)
        g.setGraph('%s/graph2%d.png' % (directory, integrated_image.getImage()))
        g.plot()

        webpage.write('<img src="graph2%d.gif">\n' % integrated_image.getImage())

    webpage.write('<a href="%s/index/index.html"><h3>Back to index results</h3</a>' % log_dir)

    webpage.write('</body>\n')
    webpage.write('</html>\n')
    

def write_basic_strategy(log_dir,
                         strategy_request,
                         strategy_response):
    '''Write out the basic strategy information to a web page'''

    directory = '%s/strategy_results' % log_dir

    try:
        os.mkdir(directory)
    except:
        # assume that it was already made
        pass

    # ok so I want to open a file in directory and make sure that I can
    # write to it, then start to write the results of the strategy
    # calculation

    webpage = open('%s/index.html' % directory, 'w')

    webpage.write('<html><head><title>Strategy Results</title></head>')
    webpage.write('<body>')
    webpage.write('<h1>Strategy Input Requirements</h1>')
    if strategy_request.getSymmetry():
        webpage.write('<p>Spacegroup: %s</p>' % strategy_request.getSymmetry())
    else:
        webpage.write('<p>Using spacegroup from automatic indexing</p>')
    strategy_settings = strategy_request.getStrategy_settings()

    if strategy_settings:
        resolution = strategy_settings.getResolution()
        overlap_limit = strategy_settings.getOverlap_limit()

        if resolution:
            webpage.write('<p>Resolution limit: %f</p>' % \
                          float(resolution.getUpper()))
        if overlap_limit:
            webpage.write('<p>Overlap limit: %f</p>' % \
                          float(overlap_limit))

    webpage.write('<h1>Strategy Results</h1>')

    # check that the strategy worked properly!

    if strategy_response.getStatus().getCode() == 'error':
        # then something went wrong

        webpage.write('<p>The strategy calculation failed with the ')
        webpage.write('message %s</p>' % \
                      strategy_response.getStatus().getMessage())

        webpage.write('</body></html>')
        webpage.close()

        return

    # ok we got this far which means that we have a result to be
    # presenting

    # next check to see if there are any warnings to be presenting

    if strategy_response.getStatus().getCode() == 'warning':
        # we have a warning message to write

        webpage.write('<p>WARNING!!! %s</p>' % \
                      strategy_response.getStatus().getMessage())

    # ok time to eat through the strategy_response properly

    webpage.write('<p>Completeness %f</p>' % float(
        strategy_response.getCompleteness().getStandard()))

    oscillations = strategy_response.getStrategy_interpretation(
        ).getOscillation_sequence()[0]

    webpage.write('<p>Start %f</p>' % float(
        oscillations.getStart()))

    if oscillations.getEnd():

        webpage.write('<p>End %f</p>' % float(
            oscillations.getEnd()))

    else:
        webpage.write('<p>End %f</p>' % \
                      (float(oscillations.getStart()) + \
                       (float(oscillations.getRange()) * \
                        float(oscillations.getNumber_of_images()))))

    webpage.write('<p>Width %f</p>' % float(
        oscillations.getRange()))

    if oscillations.getExposure_time():
        webpage.write('<p>Exposure time %f</p>' % float(
            oscillations.getExposure_time()))
    else:
        webpage.write('<p>No exposure time calculated</p>')
        
        
    # now look and see if there are BEST results to be had

    output = Somewhere.get('BEST_output')

    if output:

        webpage.write('<h3>Predicted statistics</h3>')
        
        # write the results from the strategy statistics calculation
        # to the output web page as a graph?

        bins = []
        for j in output.searchforlist('statistical_prediction', \
                                      'resolution_bin_'):
            i = int(j)
            bins.append(i)
            
        bins.sort()

        # take off the last bin
        bin = bins[-1]
        bins = bins[0:-1]

        # these information need to be stored in such a way that the
        # results can be recovered for writing on a web page - and
        # making graphs of.

        mins = []
        maxs = []
        isigs = []
        rs = []
        overloads = []

        if 1 == 2:
            webpage.write('<table>')
            webpage.write('<tr><td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td></tr>' %
                          ('Min', 'Max', 'I/sig', 'R', 'Overload'))
        for i in bins:
            if 1 == 2:
                webpage.write( 
                    '<tr><td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td></tr>' % \
                    (output.get('statistical_prediction', \
                                'resolution_bin_%d' % i, 'min_resolution')[0],
                     output.get('statistical_prediction', \
                                'resolution_bin_%d' % i, 'max_resolution')[0],
                     output.get('statistical_prediction', \
                                'resolution_bin_%d' % i, \
                                'average_i_over_sigma')[0],
                     output.get('statistical_prediction', \
                                'resolution_bin_%d' % i, 'R_factor')[0],
                     output.get('statistical_prediction', \
                                'resolution_bin_%d' % i, 'fract_overload')[0]))
            mins.append(float(output.get('statistical_prediction', \
                                         'resolution_bin_%d' % i, \
                                         'min_resolution')[0]))
            maxs.append(float(output.get('statistical_prediction', \
                                         'resolution_bin_%d' % i, \
                                         'max_resolution')[0]))
            isigs.append(float(output.get('statistical_prediction', \
                                          'resolution_bin_%d' % i, \
                                          'average_i_over_sigma')[0]))
            rs.append(float(output.get('statistical_prediction', \
                                       'resolution_bin_%d' % i, \
                                       'R_factor')[0]))
            overloads.append(float(output.get('statistical_prediction', \
                                              'resolution_bin_%d' % i, \
                                              'fract_overload')[0]))
        if 1 == 2:
            webpage.write('</table>')
                    
        # next draw a couple of graphs with the numbers I have just pulled
        # from the data

        x = []

        yi = []
        yr = []
        yo = []

        # double up the numbers to give nice step function graphs
        
        for i in range(len(mins)):
            x.append(mins[i])
            x.append(maxs[i])
            yi.append(isigs[i])
            yi.append(isigs[i])
            yr.append(rs[i])
            yr.append(rs[i])
            yo.append(overloads[i])
            yo.append(overloads[i])
            
        # now make the graphs as needed
        g = Plotter.Plotter()
        g.setLegend('Predicted Intensities', 'Resolution', 'I/sigma')
        g.setData('%s/gnu.tmp' % directory)
        g.setX(x)
        g.setY(yi)
        g.setGraph('%s/intensity.png' % directory)
        g.plot()

        g = Plotter.Plotter()
        g.setLegend('Predicted R Factor', 'Resolution', 'R factor')
        g.setData('%s/gnu.tmp' % directory)
        g.setX(x)
        g.setY(yr)
        g.setGraph('%s/rfactor.png' % directory)
        g.plot()

        g = Plotter.Plotter()
        g.setLegend('Predicted Overloads', 'Resolution', 'Overloads')
        g.setData('%s/gnu.tmp' % directory)
        g.setX(x)
        g.setY(yo)
        g.setGraph('%s/overloads.png' % directory)
        g.plot()

        webpage.write('<h3>Graphs</h3>')
        
        webpage.write('<p><img src="intensity.gif"></p>\n')
        webpage.write('<p><img src="rfactor.gif"></p>\n')
        webpage.write('<p><img src="overloads.gif"></p>\n')
        
        webpage.write('<h3>Overall</h3>')
        webpage.write('<table>')
        webpage.write('<tr><td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td></tr>' %
                      ('Min', 'Max', 'I/sig', 'R', 'Overload'))
        i = bin
        webpage.write(
            '<tr><td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td></tr>' % \
            (output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'min_resolution')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'max_resolution')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, \
                        'average_i_over_sigma')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'R_factor')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'fract_overload')[0]))
        webpage.write('</table>')

    # ok that's enough to be getting on with tidy up

    webpage.write('<a href="../index/index.html">Back to the indexing...</a>')

    webpage.write('</body></html>')

    webpage.close()

    return
            

