#!/usr/bin/env python
############################################################
# ProcessorBits.py
# Maintained by G.Winter
# 5th January 2005
# 
# Small bits which are part of the "Processor.py" toolshed.
# 
# 
# 
# 
# $Id: ProcessorBits.py,v 1.3 2005/11/22 13:38:15 svensson Exp $
############################################################

import re, string, os

def untangle_image(image):
    regexp = re.compile(r'(.*)/(.*)_([0-9]*)\.(.*)')
    match = regexp.match(image)
    if match:
        directory = match.group(1)
        prefix = match.group(2)
        number = match.group(3)
        extension = match.group(4)
        for d in string.digits:
            number = number.replace(d, '#')
        template = prefix + '_' + number + '.' + extension
        return directory, template
    else:
        # perhaps there was no directory in the expression - try without
        directory = os.getcwd()
        regexp = re.compile(r'(.*)_([0-9]*)\.(.*)')
        match = regexp.match(image)
        prefix = match.group(1)
        number = match.group(2)
        extension = match.group(3)
        for d in string.digits:
            number = number.replace(d, '#')
        template = prefix + '_' + number + '.' + extension
        return directory, template

def get_images(template, directory):
    files = os.listdir(directory)
    images = []
    
    expression = template.replace('#', '([0-9]*)', 1)
    expression = expression.replace('#', '')
    regexp = re.compile(expression)
    
    for file in files:
        match = regexp.match(file)
        if match:
            images.append(int(match.group(1)))

    return images
