#################################################################
#
# Messenger.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: Messenger.py,v 1.5 2005/11/22 13:38:15 svensson Exp $
#
#################################################################

import sys, pprint, os, time
import XSD
from XML_utils import *

here = os.getcwd()

class Messenger:

    def __init__(self):
        self.ES_host = None
        self.ES_port = None
        self.start_time = time.time()
        self.comments = []

        self.logfile = None

    def __call__(self):
        return self
    
    def set_host_port(self, ES_host, ES_port):
        self.ES_host = ES_host
        self.ES_port = ES_port

    def send_dna_message(self, type, message_text, level):
        if not self.ES_host is None:
            dna_message = XSD.Dna_message()
            dna_message.setType(type)
            dna_message.setMessage(message_text)
            if not level is None:
                dna_message.setLevel(level)
            tmp = XML_utils.http_post(self.ES_host, self.ES_port, \
                                      "/dna_message", dna_message.marshal())

        else:
            if level < 2:
                print "Message (%5d): %s" % \
                      (int(time.time() - self.start_time),
                       message_text)
                if not self.logfile:
                    self.logfile = open('%s/messenger.log' % here, 'w')
                self.logfile.write("Message (%5d): %s\n" % \
                                   (int(time.time() - self.start_time),
                                    message_text))
                
                self.logfile.flush()                 
            
    def log_write(self, message_text, level=None):
        type = "scheduler log"
        self.send_dna_message(type, message_text, level)
        self.comment(message_text)

    def debug_write(self, message_text, level=None):
        type = "scheduler debug"
        self.send_dna_message(type, message_text, level)


    def error_write(self, message_text, level=None):
        type = "scheduler error"
        self.send_dna_message(type, message_text, level)


    def comment(self, comment):
        self.comments.append(comment)

    def clear(self):
        self.comments = []

    def web(self):
        # return the comments in HTML form
        result = ''
        result += '<ul>'
        for comment in self.comments:
            result += '<li>' + str(comment) + '</li>'
        result += '</ul>'

        return result

        

Messenger = Messenger()
