#!/usr/bin/env python
############################################################
# Config.py
# A configuration handler for the Mosflm Scheduler module.
# 20th May 2004
# 
# This is designed to be called once to obtain parameters
# like the time out etc.
# 
# 
# $Id: Config.py,v 1.1 2004/05/20 08:48:33 gwin Exp $
# 
############################################################

import os, sys

# configure access to DNA

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'
dna = os.environ['DNAHOME']

sys.path.append('%s/xsd/python' % dna)

import XSD

# access all of the singletons

from SchedulerDNAConfig import SchedulerDNAConfig
from Messenger import Messenger

defaults = { }
defaults['timeout'] = 120

def get(item):
    global defaults

    if not defaults.has_key(item):
        return None
    else:
        return defaults[item]

def init():

    global defaults
    
    dna_configuration = SchedulerDNAConfig.read_configuration()
    if dna_configuration:
        Messenger.log_write('Obtained the dna configuration')
        defaults['timeout'] = 120
    else:
        # try to obtain the parameters from the user config file

        try:
            user_defaults = XSD.User_defaults()
            user_defaults_xml = open(os.environ['HOME'] + \
                                     '/.dna/user_defaults.xml').read()
            user_defaults.unmarshal(user_defaults_xml)
            Messenger.log_write('Picked up used defaults from ' + \
                                '%s/.dna/user_defaults.xml' % \
                                os.environ['HOME'])
        except:

            Messenger.log_write('No user defaults found in ' + \
                                '~/.dna/user_defaults.xml')
        
    
