#!/usr/bin/env python
# Bits.py
# Maintained by G.Winter
# 30th January 2003
# 
# A component of the new scheduler - this is odds and ends.
# 
# 
# 
# 
# $Id: Bits.py,v 1.2 2004/06/03 12:37:58 gwin Exp $


import re

def Pad(number, space):
    format = '%0' + str(space) + 'd'
    return format % number

def UnTemplate(template):
    expression = r'(.*)_(\#*)\.(.*)'
    regexp = re.compile(expression)
    match = regexp.match(template)
    prefix = match.group(1)
    hash = match.group(2)
    extension = match.group(3)

    return prefix, hash, extension

def Image(fileinfo, image):
    directory = fileinfo.getDirectory()
    template = fileinfo.getTemplate()
    
    expression = r'(.*)_(\#*)\.(.*)'
    regexp = re.compile(expression)
    match = regexp.match(template)
    prefix = match.group(1)
    extension = match.group(3)
    length = len(match.group(2))
    
    format = '%0' + str(length) + 'd'
    
    number = format % image
    filename = directory + '/' + prefix + '_' + number + '.' + extension

    return filename
