#!/usr/bin/env python
# Beamline.py
# Maintained by G.Winter
# 26th January 2004
# 
# A fake beamline, to test Mosflm.py
# 
# 
# 
# 
# $Id: Beamline.py,v 1.1 2004/01/26 15:33:19 gwin Exp $

import time
import re
import shutil

template = 'trypsin_1_###.img'
index = 'ref-'
postref = 'postref-'
integrate = ''

index_images = [1, 91]
postref_images = [1, 2, 3, 45, 46, 47]
integrate_images = [1, 91]

source = '/data/graeme/source'
destination = '/data/graeme/images'

exposure = 10

expression = r'(.*)_(\#*)\.(.*)'
regexp = re.compile(expression)
match = regexp.match(template)
prefix = match.group(1)
extension = match.group(3)
length = len(match.group(2))

format = '%0' + str(length) + 'd'

for i in index_images:
    time.sleep(exposure)
    number = format % i
    filename = prefix + '_' + number + '.' + extension
    print index + filename
    shutil.copyfile(source + '/' + filename,
                    destination + '/' + index + filename)

for i in postref_images:
    time.sleep(exposure)
    number = format % i
    filename = prefix + '_' + number + '.' + extension
    print postref + filename
    shutil.copyfile(source + '/' + filename,
                    destination + '/' + postref + filename)

for i in range(integrate_images[0], integrate_images[1] + 1):
    time.sleep(exposure)
    number = format % i
    filename = prefix + '_' + number + '.' + extension
    print integrate + filename
    shutil.copyfile(source + '/' + filename,
                    destination + '/' + integrate + filename)
