#!/usr/bin/env python
############################################################
# BEST.py
# Maintained by G.Winter
# 19th April 2004
# 
# A wrapper for the strategy program BEST (Popov & Bourenkov. 2003)
# 
# 
# $Id: BEST.py,v 1.26 2006/02/23 12:06:04 gwin Exp $
# 
############################################################

# generic includes

import os, sys

# check the DNA set up

if os.environ.has_key('DNAHOME'):
    dna = os.environ['DNAHOME']
else:
    raise RuntimeError, 'DNAHOME not configured'

sys.path.append(dna + '/scheduler/Scheduler/Driver')

import Driver, Output

sys.path.append(dna + '/xsd/python')
import XSD

# access a few singleton classes
from Somewhere import Somewhere
from Messenger import Messenger

# how to run BEST
# best -f adsc -t 1 -mos -dna foo.dna ../autoindex_1/bestfile.dat 
# ../integrate_1/bestfile.par ../integrate_1/bestfile.hkl
# < phi start end
# < width dphi
# < constant sig dphi time

# this will be written a lot by Olof at the ESRF and people at other places!

def GetDetectorName():
    if False and os.environ['DNANAME'] == 'id29':
        return 'd-id29'
    # add more here for other beamlines
    else:
        if not os.environ.has_key('DNA_DETECTOR_NAME'):
            return None

    detector = os.environ['DNA_DETECTOR_NAME']

    return detector

class BEST(Driver.Driver):

    def __init__(self):
        Driver.Driver.__init__(self)

        self.setExecutable('best')

        self.resolution = None
        self.detector = 'adsc'
        self.exposure_time = 1.0
        self.dat = ''
        self.par = ''
        self.hkl = []
        self.segments = None
        self.interactive = False
        self.strategy = None
        self.diameter = None

    def setStrategy(self, start, end, width, time):
        self.strategy = (start, end, width, time)
        self.interactive = True

    def setSegments(self, segments):
        self.segments = segments

    def addHkl(self, hkl):
        self.hkl.append(hkl)

    def setPar(self, par):
        self.par = par

    def setDat(self, dat):
        self.dat = dat

    def setExposure_time(self, time):
        self.exposure_time = time

    def setDetector(self, detector, diameter = None):
        self.detector = detector
        self.diameter = diameter

        if diameter and detector == 'mar':
            intdiameter = int(10 * diameter)
            self.detector = self.detector + str(intdiameter)

        if GetDetectorName():
            self.detector = GetDetectorName()
            Messenger.log_write('Using DNANAME %s detector is %s' \
                                % (os.environ['DNANAME'], self.detector), 2)
        else:
            Messenger.log_write('Detector type for best is %s' %
                                self.detector, 2)

    def setResolution(self, resolution):
        self.resolution = resolution

    def run(self):

        # check here

        # next determine the correct detector type based on the
        # frame itself - e.g. by inspection...

        # delete any BEST strategy stuff in Somewhere
        Somewhere.store('BEST_output', None)


        # look at the environment for a DNA_DETECTOR_NAME

        if os.environ.has_key('DNA_DETECTOR_NAME'):
            old_detector = self.detector
            
            self.detector = os.environ['DNA_DETECTOR_NAME']

            Messenger.log_write('Obtained detector name %s' % \
                                self.detector, 2)
            Messenger.log_write('Overridden from %s' % old_detector, 2)
            
        elif GetDetectorName():
            self.detector = GetDetectorName()
        command = '-f %s -t %s ' % (self.detector, self.exposure_time)
        if (self.resolution):
            command += '-r %f ' % self.resolution
        if self.segments:
            command += '-e %s ' % (str(self.segments))
        if self.interactive:
            command += '-i '
        command += '-mos -dna best.stf %s %s ' % (self.dat, self.par)
        for hkl in self.hkl:
            command += '%s ' % hkl

        self.start(command)

        if (self.strategy):
            # self.resolution = 1.5
            self.input('phi %s %s' % (str(self.strategy[0]), \
                                      str(self.strategy[1])))
            self.input('width %s' % (str(self.strategy[2])))
            if self.diameter:
                self.input('constant %s %s %s %f' % \
                           (str(self.resolution), str(self.strategy[2]),
                            str(self.strategy[3]), self.diameter))
            else:
                self.input('constant %s %s %s' % \
                           (str(self.resolution), str(self.strategy[2]),
                            str(self.strategy[3])))
            self.input('stats')

        self.close()


        while 1:
            line = self.output()

            if not line:
                break


        self.kill()

        # parse and gather up the output...

        if not self.getWorkingDirectory():
            output = Output.Output('best.stf')
        else:
            output = Output.Output(self.getWorkingDirectory() + '/best.stf')

        if not self.strategy:
            for j in output.searchforlist('general_inform', 'short_range_'):
                i = int(j)

        # do not want to print this since it is misleading!
        if 1 == 2:
            if 1 == 2:
                Messenger.log_write('Data collection %d start %s end %s' % \
                                    (i, output.get('general_inform',
                                                   'short_range_%d' % i,
                                                   'phi_start')[0],
                                     output.get('general_inform',
                                                'short_range_%d' % i,
                                                'phi_end')[0]))

        Messenger.log_write('Summary of statistics')

        if not self.strategy:
            Messenger.log_write(
                'Fraction of achievable reflections measured: %s%%' % \
                (output.get('general_inform', 'rel_achievable_refl_1', \
                            'fraction_achievable_%')[0]))
            
        else:
            Messenger.log_write(
                'Fraction of achievable reflections measured: %s%%' % \
                (output.get('statistical_prediction',
                            'user_data_collection_strategy_1',
                            'completeness')[0]))
            
        # bug 821 reported by gleb
        # this only works if using BEST strategy else need above change!
        # output.get('general_inform', 'rel_achievable_refl_1', \
        # 'fraction_achievable_%')[0])


        if not self.strategy:
            Messenger.log_write('Redundancy: %s' %
                                (output.get('data_collection_strategy',
                                            'summary_1', 'redundancy')[0]))
        else:
            Messenger.log_write('Redundancy: %s' %
                                (output.get('statistical_prediction',
                                            'user_data_collection_strategy_1',
                                            'redundancy')[0]))

        if not self.strategy:
            Messenger.log_write('Data collection run info')
            line = '----------------------------------------'
            Messenger.log_write(line)
            Messenger.log_write('Enter this information to use the BEST ' + \
                                'strategy')
            Messenger.log_write('Start   Width   Time    Number  1st Image')

        runs = []
        if not self.strategy:
            for j in output.searchforlist('data_collection_strategy',
                                          'collection_run_'):
                i = int(j)
                runs.append(i)
            
            runs.sort()

            Somewhere.store('BEST exposure time', \
                            output.get('data_collection_strategy', \
                                       'collection_run_%d' % i, \
                                       'exposure_time')[0])
        
            for i in runs:
                Messenger.log_write(
                    '%8s%8s%8s%8s    1' % \
                    (output.get('data_collection_strategy',
                                'collection_run_%d' % i, 'phi_start')[0],
                     output.get('data_collection_strategy',
                                'collection_run_%d' % i, 'phi_width')[0],
                     output.get('data_collection_strategy',
                                'collection_run_%d' % i, 'exposure_time')[0],
                     output.get('data_collection_strategy',
                                'collection_run_%d' % i, \
                                'number_of_images')[0]))
                    
            Messenger.log_write(line)
            
        bins = []
        for j in output.searchforlist('statistical_prediction', \
                                      'resolution_bin_'):
            i = int(j)
            bins.append(i)
            
        bins.sort()

        # take off the last bin
        bin = bins[-1]
        bins = bins[0:-1]

        # these information need to be stored in such a way that the
        # results can be recovered for writing on a web page - and
        # making graphs of.
        
        Messenger.log_write('%s\t%s\t%s\t%s\t%s' %
                            ('Min', 'Max', 'I/sig', 'R', 'Overload'), 2)
        for i in bins:
            Messenger.log_write(
                '%s\t%s\t%s\t%s\t%s' % \
                (output.get('statistical_prediction', \
                            'resolution_bin_%d' % i, 'min_resolution')[0],
                 output.get('statistical_prediction', \
                            'resolution_bin_%d' % i, 'max_resolution')[0],
                 output.get('statistical_prediction', \
                            'resolution_bin_%d' % i, \
                            'average_i_over_sigma')[0],
                 output.get('statistical_prediction', \
                            'resolution_bin_%d' % i, 'R_factor')[0],
                 output.get('statistical_prediction', \
                            'resolution_bin_%d' % i, 'fract_overload')[0]), 2)
                
        Messenger.log_write('Overall')
        Messenger.log_write('%s\t%s\t%s\t%s\t%s' %
                            ('Min', 'Max', 'I/sig', 'R', 'Overload'))
        i = bin
        Messenger.log_write(
            '%s\t%s\t%s\t%s\t%s' % \
            (output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'min_resolution')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'max_resolution')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, \
                        'average_i_over_sigma')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'R_factor')[0],
             output.get('statistical_prediction', \
                        'resolution_bin_%d' % i, 'fract_overload')[0]))

        Somewhere.store('BEST_output', output)

        return Strategy_response(output)

def Strategy_response(output):
    '''Convert an output best.stf file into DNA'''

    # check for overloaded reflections in the strategy - if there are 
    # overloaded reflectiosn then we need to reduce the exposure time
    # - maybe by a factor of two...

    bins = []
    for j in output.searchforlist('statistical_prediction', \
                                  'resolution_bin_'):
        i = int(j)
        bins.append(i)
        
    bins.sort()
        
    # take off the last bin
    bin = bins[-1]
    overload = float(output.get('statistical_prediction', \
                                'resolution_bin_%d' % bins[0], \
                                'fract_overload')[0])

    # this is in percent!
    if overload > 1.00:
        strategy_response = XSD.Strategy_response()
        status = XSD.Status()
        status.setCode('error')
        status.setMessage('Detector overloaded %f' % overload)
        strategy_response.setStatus(status)
        return strategy_response


    strategy_response = XSD.Strategy_response()
    status = XSD.Status()
    status.setCode('ok')
    strategy_response.setStatus(status)
    completeness = XSD.Completeness()
    completeness.setStandard(output.get('general_inform', \
                                        'rel_achievable_refl_1', \
                                        'fraction_achievable_%')[0])
    strategy_response.setCompleteness(completeness)

    runs = []

    for j in output.searchforlist('data_collection_strategy',
                                  'collection_run_'):
        i = int(j)
        runs.append(i)
            
    runs.sort()

    # we should have exactly one "run" at the moment!
    if len(runs) > 0:
        i = runs[0]
        start = float(output.get('data_collection_strategy',
                                 'collection_run_%d' % i, 'phi_start')[0])
        # this is really an int but...
        number = float(output.get('data_collection_strategy',
                                  'collection_run_%d' % i, 'number_of_images')[0])
        width = float(output.get('data_collection_strategy',
                                 'collection_run_%d' % i, 'phi_width')[0])
    else:
        # we put in a strategy
        start = float(output.get('statistical_prediction',
                                 'user_data_collection_strategy_1', \
                                 'phi_start')[0])
        number = float(output.get('statistical_prediction',
                                  'user_data_collection_strategy_1', \
                                  'number_of_images')[0])
        end = float(output.get('statistical_prediction',
                               'user_data_collection_strategy_1', \
                               'phi_end')[0])
        width = (end - start) / number

    end = start + (number * width)

    strategy_summary = XSD.Strategy_summary()
    strategy_summary.setNumber_of_segments(1)
    segment = XSD.Segment()
    oscillation = XSD.Oscillation_sequence()
    prediction = XSD.Predicted_spots()

    oscillation.setStart(start)
    oscillation.setRange(end - start)
    oscillation.setNumber_of_images(number)

    # this is in the statistics... maybe I should get it
    prediction.setFull(0.0)
    prediction.setOverlap(0.0)
    
    segment.setPredicted_spots(prediction)
    segment.setOscillation_sequence(oscillation)
    
    strategy_response.addSegment(segment)
    strategy_summary.addSegment(segment)
    strategy_response.addStrategy_summary(strategy_summary)

    return strategy_response

if __name__ == '__main__':

    Check()

    argv = sys.argv

    if len(argv) == 1:

        print 'Testing with default settings'
        
        b = BEST()
        
        hkl1 = '/tmp/beer/integrate_1/bestfile.hkl'
        hkl91 = '/tmp/beer/integrate_91/bestfile.hkl'
        par = '/tmp/beer/integrate_1/bestfile.par'
        dat = '/tmp/beer/autoindex_1/bestfile.dat'
        
        b.setDat(dat)
        b.setPar(par)
        b.addHkl(hkl1)
        b.addHkl(hkl91)
        
        b.run()

        b.setResolution(1.5)
        b.setStrategy(0, 360, 0.1)
        
        b.run()

    else:
        print 'Now testing interactive'
        
        b = BEST()

        hkl1 = '/tmp/beer/integrate_1/bestfile.hkl'
        hkl91 = '/tmp/beer/integrate_91/bestfile.hkl'
        par = '/tmp/beer/integrate_1/bestfile.par'
        dat = '/tmp/beer/autoindex_1/bestfile.dat'
        
        b.setDat(dat)
        b.setPar(par)
        b.addHkl(hkl1)
        b.addHkl(hkl91)
        
        b.setSegments(int(argv[1]))
        
        b.run()
