#!/usr/bin/env python
############################################################ 
# LABELITInterface.py
# Maintained by G.Winter
# 2nd August 2004
# 
# A wrapper for some of the functions offered by the 
# LABELIT indexing toolbox, to provide these functions
# to DNA.
# 
# $Id: LABELITInterface.py,v 1.2 2004/08/02 14:52:26 gwin Exp $
############################################################

# Note Well - this does not directly interface with LABELIT, rather it will
# run labelit.screen as an external process and record the results.
# this will be run in the directory "labelit"

import os, sys

if os.environ.has_key('DNAHOME'):
    dna = os.environ['DNAHOME']
else:
    raise RuntimeError, 'DNAHOME not defined'

# access the messenger singleton

sys.path.append(dna + '/scheduler/Scheduler/Mosflm')
sys.path.append(dna + '/xsd/python')

from Messenger import Messenger
import XSD

# a global LABELIT

import LABELIT
labelit = LABELIT.LABELIT()

def SetWorkingDirectory(newDir):
    labelit.setWorkingDirectory(newDir)
    labelit.path = newDir

def do_index_request(index_request, jpeg = 0):
    Messenger.log_write('Now indexing with LABELIT')

    if index_request.name != 'index_request':
        raise RuntimeError, 'request type is not index_request'

    index_response = labelit.autoindex(index_request)

    return index_response

if __name__ == '__main__':

    index_request = XSD.Index_request()

    fileinfo = XSD.Fileinfo()

    fileinfo.setTemplate('trypsin_1_###.img')
    fileinfo.setDirectory('/data/graeme/images')

    index_request.setFileinfo(fileinfo)

    index_request.addImage(1)
    index_request.addImage(91)

    index_response = do_index_request(index_request)

    print index_response.marshal()
    
