#!/usr/bin/env python
############################################################
# HTML.py
# The HTMLification singleton - used for turning DNA python
# objects into "nice" HTML.
# 
# 
# 
# 
# 
# 
# $id$
############################################################

import os, sys

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

dna = os.environ['DNAHOME']

sys.path.append('%s/xsd/python' % dna)

import XSD

class HTML:

    def __init__(self):
        self.types = ['status', 'fileinfo', 'beam', 'cell',
                      'matrix', 'spacegroup', 'resolution']

    def start(self):
        return '<html><head><title>Automatic HTML Generation</title>' + \
               '</head><body>'

    def end(self):
        return '</body></html>'

    def htmlize(self, object):
        if not hasattr(object, 'name'):
            raise RuntimeError, 'object has no name %s' % str(object)

        if not object.name in self.types:
            raise RuntimeError, 'object name %s not recognised' % object.name

        method = getattr(self, 'render_%s' % object.name)

        return method(object)

    def render_status(self, status):
        if status.getMessage() != '':
            return '<p>Status code = %s</p><p>Status message = %s</p>' % \
                   (status.getCode(),
                    status.getMessage())
        else:
            return '<p>Status code = %s</p>' % status.getCode()

    def render_cell(self, cell):
        html = '<table border="1">'
        html += '<tr><th colspan="3">Unit Cell</th></tr>'
        html += '<tr>'
        html += '<th width="33%">a</th>'
        html += '<th width="33%">b</th>'
        html += '<th width="33%">c</th>'
        html += '</tr>'
        html += '<tr align="right">'
        html += '<td>%3.2f</td>' % cell.getA()
        html += '<td>%3.2f</td>' % cell.getB()
        html += '<td>%3.2f</td>' % cell.getC()
        html += '</tr>'
        html += '<tr>'
        html += '<th>alpha</th>'
        html += '<th>beta</th>'
        html += '<th>gamma</th>'
        html += '</tr>'
        html += '<tr align="right">'
        html += '<td>%3.2f</td>' % cell.getAlpha()
        html += '<td>%3.2f</td>' % cell.getBeta()
        html += '<td>%3.2f</td>' % cell.getGamma()
        html += '</tr>'
        html += '</table>'
        return html
        
    def render_fileinfo(self, fileinfo):
        html = '<table border="1">'
        html += '<tr><th colspan="2">File information</th></td>'
        if fileinfo.getPrefix():
            html += '<tr><td>Prefix</td><td>%s</td></tr>' % \
                    fileinfo.getPrefix()
        if fileinfo.getSuffix():
            html += '<tr><td>Suffix</td><td>%s</td></tr>' % \
                    fileinfo.getSuffix()
        if fileinfo.getTemplate():
            html += '<tr><td>Template</td><td>%s</td></tr>' % \
                    fileinfo.getTemplate()
        if fileinfo.getDirectory():
            html += '<tr><td>Directory</td><td>%s</td></tr>' % \
                    fileinfo.getDirectory()
        if fileinfo.getRun_number():
            html += '<tr><td>Run</td><td>%d</td><tr>' % \
                    fileinfo.getRun_number()

        html += '</table>'

        return html

        
HTML = HTML()

if __name__ == '__main__':

    print HTML.start()

    object = XSD.Status()
    object.setCode('ok')
    object.setMessage('no message')

    print HTML.htmlize(object)

    object = XSD.Cell()
    object.setA(45.0)
    object.setB(55.0)
    object.setC(65.0)
    object.setAlpha(90.0)
    object.setBeta(90.0)
    object.setGamma(90.0)

    print HTML.htmlize(object)

    object = XSD.Fileinfo()
    object.setTemplate('run_1_###.img')
    object.setDirectory('/home/graeme/data')

    print HTML.htmlize(object)

    print HTML.end()

    
