#!/usr/bin/env python
# Scheduler.py
# Maintained by G.Winter
# 26th January 2004
# 
# A system which will allocate processor resources on a first come, first 
# served basis.
# 
# The "processors" are kept within a queue
# 
# $Id: Scheduler.py,v 1.3 2004/05/18 11:32:15 svensson Exp $

import Queue

import os

if os.environ.has_key('DNA_PROCESSORS'):
    processors = int(os.environ['DNA_PROCESSORS'])
else:
    # assume uniprocessor machines
    processors = 1

processor_stack = Queue.Queue()
for i in range(processors):
    processor_stack.put(0)

def grab():
    return processor_stack.get()

def release():
    processor_stack.put(0)



 
