#!/usr/bin/env python
############################################################
# Plotter.py
# Maintained by G.Winter
# 11th May 2004
# 
# A wrapper for gnuplot, to create graphical output.
# 
# 
# $Id: Plotter.py,v 1.4 2004/08/26 13:02:20 gwin Exp $
# 
############################################################

# generic includes

import os, sys, string

# check the DNA set up

if os.environ.has_key('DNAHOME'):
    dna = os.environ['DNAHOME']
else:
    raise RuntimeError, 'DNAHOME not configured'

sys.path.append(dna + '/scheduler/Scheduler/Driver')

import Driver

class Plotter(Driver.Driver):

    def __init__(self):
        Driver.Driver.__init__(self)


        self.setExecutable('gnuplot')
        self.data = None
        self.graph = 'graph.png'
        self.format = 'png'
        self.command = 'plot "%s" using 1:2 with lines'

        self.title = None
        self.xLabel = None
        self.yLabel = None

        self.x = None
        self.y = None

        self.yrange = None

    def setLegend(self, title, xLabel, yLabel):
        self.title = title
        self.xLabel = xLabel
        self.yLabel = yLabel

    def setData(self, data):
        self.data = data

    def setX(self, x):
        self.x = x

    def setY(self, y):
        self.y = y

    def setYrange(self, lower = None, upper = None):
        if not lower and not upper:
            self.yrange = None
        else:
            self.yrange = (lower, upper)

    def setGraph(self, graph):
        self.graph = graph

    def setFormat(self, format):
        self.format = format

    def setCommand(self, command):
        self.command = command

    def plot(self):

        if not self.command:
            raise Driver.DriverException, \
                  'this requires a command to plot with'
        
        if not self.data:
            raise Driver.DriverException, \
                  'this requires an input data file'

        if not self.format or not self.graph:
            raise Driver.DriverException, \
                  'this requires a format and output file'

        if self.x and self.y:
            # write the data file
            out = open(self.data, 'w')
            for i in range(len(self.x)):
                out.write('%f %f\n' % (float(self.x[i]), float(self.y[i])))
            out.close()

        
        self.start()
        self.input('set term %s' % self.format)
        # default size is "small" :o)
        self.input('set size 0.5,0.5')
        self.input('set output "%s"' % self.graph)

        # only do this if the scale is increasing!
        # don't want resolutions reversed!
        if float(self.x[-1]) > float(self.x[0]):
            self.input('set xrange [%f:%f]' % (float(self.x[0]),
                                               float(self.x[-1])))

        if self.yrange:
            self.input('set yrange [%f:%f]' % (float(self.yrange[0]),
                                               float(self.yrange[1])))
        if self.title:
            self.input('set title "%s"' % self.title)
        if self.xLabel:
            self.input('set xlabel "%s"' % self.xLabel)
        if self.yLabel:
            self.input('set ylabel "%s"' % self.yLabel)
        self.input('set nokey')
        self.input(self.command % self.data)
        self.close()

        while 1:
            line = self.output()

            if not line:
                break


        self.kill()

        newfile = string.replace(self.graph, '.' + self.format, '.gif')

        os.system('convert %s gif:%s' % (self.graph, newfile))

        return newfile

if __name__ == '__main__':

    import math

    g = Plotter()

    # make a temp file

    outfile = open('testgnu.tmp', 'w')
    x = []
    y = []
    for i in range(0, 1000):
        r = 0.01 * i
        s = math.sin(r)
        c = math.cos(r)
        x.append(r)
        y.append(c)
        outfile.write('%f %f\n' % (r, s))

    outfile.close()

    g.setData('testgnu.tmp')
    g.setGraph('testgnu.png')
    g.setFormat('png')


    print g.plot()

    g.setData('testgnu2.tmp')
    g.setGraph('testgnu2.png')
    g.setX(x)
    g.setY(y)
    g.setLegend('pointless', 'edge', 'hgnome')

    g.plot()
