#!/usr/bin/env python
# Output.py
# Maintained by G.Winter
# 19th January 2004
# A part of the second version of the scheduler.
# 
# This component is a wrapper for the output 'barney' files.
# 
# 
# 
# $Id: Output.py,v 1.16 2006/06/01 12:04:46 gwin Exp $

import xml.parsers.expat, string, types, thread

# this is now irrelevant - oh well!

import sys, os, copy

# insist that DNAHOME is defined - so that the rest of DNA should work
# properly
if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

dna = os.environ['DNAHOME']
# no longer any need to pollute the path, since this is now in the
# "driver" directory. Except I need the Messenger now...
sys.path.append(dna + '/scheduler/Scheduler/Mosflm')

# obtain access to the DriverException class
import Driver
from Messenger import Messenger

# import access to the mutex locks, which are used in here to help
# with the passing of XML, because using expat requires that we have
# global variables. :o(
import thread

parsingMutex = thread.allocate_lock()

# initialise the few dumb variables which I use to keep track of the data
# structures in the XML document.
table = ''
list = ''
item = ''
image = 0

# this is a temporary structure where I keep all of the results
dictionary = { }

# the following methods are not intended for external use, so are
# poorly documented!
# 
# However, for developers, the following brief instructions are given.
# The functions start(), character() and end() are called when the appropriate
# XML elements are reached - the start of an element, the "contents" of the
# element (i.e. the text) and the end of the element. The start also contains
# the attribute dictionary, which may be used for passing information.


def start(name, attrs):
    global table, list, item, image, dictionary

    if name == 'table':
        table = attrs['name'].encode('ascii')
        if attrs.has_key('image'):
            image = int(attrs['image'])
        else:
            image = 0
        if not dictionary.has_key(table):
            dictionary[table] = { }
            dictionary[table]['__count__'] = 1
        else:
            dictionary[table]['__count__'] += 1

    elif name == 'list':
        list = attrs['name'].encode('ascii')
        if attrs.has_key('index'):
            list += '_' + string.strip(attrs['index'].encode('ascii'))
        if not dictionary[table].has_key(list):
            dictionary[table][list] = { }
            dictionary[table][list]['__count__'] = 1
        else:
            dictionary[table][list]['__count__'] += 1

    elif name == 'item':
        item = attrs['name'].encode('ascii')
        if not dictionary[table][list].has_key(item):
            dictionary[table][list][item] = { }

def character(str):
    global table, list, item, image, dictionary
    str = string.strip(str)
    str = str.encode('ascii')
    if len(str) == 0:
        return
    if dictionary.has_key(table):
        if dictionary[table].has_key(list):
            if dictionary[table][list].has_key(item):
                dictionary[table][list][item][image] = str
                return
            
    raise Driver.DriverException, 'invalid key sequence'

def end(name):
    if name == 'item':
        item = ''
    elif name == 'list':
        list = ''
    elif name == 'table':
        table = ''

# this function uses the above three to parse an XML document into a
# python dictionary, to hold the information in a more convenient format.
# note well that this is very inflexible, and will handle poorly general
# XML documents.
        
def parse(document):
    global dictionary, table, list, item, image
    parsingMutex.acquire()

    table = ''
    list = ''
    item = ''
    image = 0
    dictionary = { }

    p = xml.parsers.expat.ParserCreate()
    p.StartElementHandler = start
    p.EndElementHandler = end
    p.CharacterDataHandler = character

    try:
        p.Parse(document)
    except:
        parsingMutex.release()
        raise
    # Driver.DriverException, 'error parsing XML document'

    # return a deep copy of the dictionary - this is so that if another
    # XML document is parsed the results from the previous parsing will
    # survive, since the dictionary is a mutable type.

    d = copy.deepcopy(dictionary)
    parsingMutex.release()

    return d


# This is the real bit which should be exposed from this file - the class
# which is designed to represent the XML document.
# 
# This is simply a wrapper for the dictionary at the moment, but in the future
# could benefit from a little more functionality, for instance being able to 
# search the hierarchy, for instance with regular expressions.
# 
# This does however add the functionality that the different elements of the 
# XML document can be accessed as a given type, for instance getInt. This
# will save lots of typing in the client code (no pun intended!)

# a recursive function to merge dictionaries

def merge_dictionaries(one, two):
    three = copy.deepcopy(one)
    for key in two.keys():
        if type(two[key]) == type({}):
            if three.has_key(key):
                three[key] = merge_dictionaries(three[key], two[key])
            else:
                three[key] = copy.deepcopy(two[key])
        else:
            three[key] = copy.deepcopy(two[key])
    return three

class Output:
    '''A class to represent the output "barney" files from programs'''

    def __init__(self, filename = None):
        if filename == None:
            self.data = { }
        else:
            # print 'Initialising from file ' + filename

            Messenger.log_write('Reading stf file: %s' % filename)
            
            try:
                document = open(filename, 'r').read()
            except:
                raise Driver.DriverException, 'error reading input file: ' + \
                      filename
            self.data = parse(document)

    def append(self, filename):
        '''add some more data to the output object'''
        try:
            document = open(filename, 'r').read()
        except:
            raise Driver.DriverException, 'error reading input file: ' + \
                  filename
        data = parse(document)
        self.data = merge_dictionaries(self.data, data)

    def key(self, table = None, list = None, item = None, image = None):
        if self.data.has_key(table):
            if not list:
                return 1

        return 0

    def get(self, table = None, list = None, item = None, image = None):
        if not self.data:
            raise Driver.DriverException, 'no stored self.data'
        if table:
            if not self.data.has_key(table):
                raise Driver.DriverException, 'table not found ' + str(table)
            if list:
                if not self.data[table].has_key(list):
                    raise Driver.DriverException, 'list not found ' + str(list)
                if item:
                    if not self.data[table][list].has_key(item):
                        raise Driver.DriverException, 'item not found' + \
                              str(item)
                    if image:
                        if not self.data[table][list][item].has_key(image):
                            raise Driver.DriverException, \
                                  'image not found %d' % int(image)
                        return self.data[table][list][item][image]
                    else:
                        keys = self.data[table][list][item].keys()
                        if len(keys) == -1:
                            return self.data[table][list][item][keys[0]]
                        return self.data[table][list][item]
                else:
                    return self.data[table][list]
            else:
                return self.data[table]
        else:
            return self.data

    def getInt(self, table = None, list = None, item = None, image = None):
        result = self.get(table, list, item, image)
        return int(result)

    def getFloat(self, table = None, list = None, item = None, image = None):
        result = self.get(table, list, item, image)
        return float(result)

    def getString(self, table = None, list = None, item = None, image = None):
        result = self.get(table, list, item, image)
        return str(result)

    def searchfortable(self, table):
        table_keys = []
        for key in self.data.keys():
            if table in key:
                table_keys.append(str(string.replace(key, table, '')))

        return table_keys

    def searchforlist(self, table, list):
        list_keys = []
        if not self.data.has_key(table):
            return []
        for key in self.data[table].keys():
            if list in key:
                list_keys.append(str(string.replace(key, list, '')))

        return list_keys

if __name__ == '__main__':
    o = Output('best.stf')
    
