#!/usr/bin/env python
# Exist.py
# Maintained by G.Winter
# 26th January 2004
# 
# A section of the second generation scheduler. This will check to see if 
# files specified by a fileinfo and a list of integers exist, and will return
# 1 if they do exist and 0 if they do not.
# 
# There will also be routines in here which check for the direct existance
# of the files
# 
# $Id: Exist.py,v 1.6 2005/11/22 13:38:15 svensson Exp $

import sys, os

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'
dna = os.environ['DNAHOME']

sys.path.append(dna + '/xsd/python')
import XSD
import Driver

import re

def Fileinfo(fileinfo, images):
    if fileinfo.name != 'fileinfo':
        raise Driver.DriverException, 'bad input type'

    directory = fileinfo.getDirectory()
    template = fileinfo.getTemplate()

    expression = r'(.*)_(\#*)\.(.*)'
    regexp = re.compile(expression)
    match = regexp.match(template)
    prefix = match.group(1)
    extension = match.group(3)
    length = len(match.group(2))

    format = '%0' + str(length) + 'd'

    for image in images:
        number = format % image
        filename = prefix + '_' + number + '.' + extension

        # try:
        # f = open(directory + '/' + filename, 'r')
        # f.close()
        # except:
        # return 0

        if not os.access('%s/%s' % (directory, filename),
                         os.F_OK):
            return 0

    return 1

if __name__ == '__main__':
    fileinfo = XSD.Fileinfo()

    fileinfo.setDirectory('/data/graeme/images')
    fileinfo.setTemplate('trypsin_1_###.img')

    if Fileinfo(fileinfo, [1, 2, 3]) == 1:
        print 'files exist'
    else:
        print 'files do not exist'


