#!/usr/bin/env python
# Background.py
# Maintained by G.Winter
# Part of scheduler v 1.1
# 19th January 2004
# 
# A class to enable the background operation of a task.
# 
# 
# 
# $Id: Background.py,v 1.8 2005/11/22 13:38:15 svensson Exp $

# threading supplies the core information about the Thread class
import threading, os, sys, exceptions

# this contains the DriverException, which I will use for any lower
# level exceptions
import Driver

# tie in the DNA messenger - this is a temporary measure
# if not os.environ.has_key('DNAHOME'):
#     raise RuntimeError, 'DNAHOME not defined'
#
# dna = os.environ['DNAHOME']
# sys.path.append(dna + '/scheduler/Scheduler/Mosflm')
# from Messenger import Messenger

class Background(threading.Thread):
    '''A class to enable background (i.e. threaded) operation'''

    def __init__(self, obj, method, args):
        '''Create a backgrounding object'''

        # the parent's constructor
        threading.Thread.__init__(self)

        # check that obj has a method named appropriately
        if not hasattr(obj, method):
            raise Driver.DriverException, 'object has no method ' + str(method)

        # store these properties - so that the task can be started later
        # on - I could contain a pointer to the function in here if I
        # so desired, but I prefer to store the core details
        self.obj = obj
        self.method = method
        self.args = args
        self.ok = True

    def run(self):
        '''This method is called by the start() method from threading.Thread'''
        
        # wouldn't it be a good idea to wrap this in a try/except structure?
        task = getattr(self.obj, self.method)

        # Messenger.log_write('Starting task in background')
        # Messenger.log_write(str(self.obj) + ' ' + str(self.method) + ' ' + \
        # str(self.args))
        
        try:
            task(self.args)
            self.ok = True
            self.__message__ = 'ok!'
        except exceptions.Exception, e:
            self.ok = False
            self.__message__ = e

    def stop(self):
        '''This is to rejoin the thread post processing, and will block until
        the processing is completed'''
        
        self.join()
        if self.ok:
            pass
        else:
            raise Driver.DriverException, self.__message__

    
if __name__ == '__main__':

    import time
    
    class foo:
        def __init__(self):
            self.bar = 40

        def go(self, start):
            for i in range(start, self.bar):
                print i

    for k in range(100000):

        print 'k = ' + str(k)

        f = foo()
        b = Background(f, 'go', 30)
        b.start()
        for i in range(10):
            print 'sleep'

        b.stop()
    
