#!/usr/bin/env python
# Sortmtz.py
# Maintained by G.Winter
# 26th January 2004
# A part of the second generation scheduler.
# 
# This is a wrapper for the CCP4 program sortmtz, which will sort 
# the reflections in a file by the H K L etc values and may be used
# to merge a number of MTZ files into a single file, prior to scaling.
# 
# $Id: Sortmtz.py,v 1.7 2005/11/22 13:38:15 svensson Exp $

import os

if not os.environ.has_key('CCP4'):
    raise RuntimeError, 'CCP4 not found'
if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

import sys

dna = os.environ['DNAHOME']

sys.path.append(dna + '/xsd/python')
sys.path.append(dna + '/scheduler/Scheduler/Driver')

import Driver
import Output
import Exist
import CCP4
import XSD
import CCP4Translation

class Sortmtz(Driver.Driver):
    '''A class to execute sortmtz'''

    def __init__(self, input = None):
        Driver.Driver.__init__(self)
        self.setExecutable('sortmtz')
        self.hklout = ''
        self.hklin = []
        self.order = 'H K L M/ISYM BATCH'

    def setHklout(self, hklout):
        self.hklout = hklout

    def addHklin(self, hklin):
        self.hklin.append(hklin)

    def clearHklin(self):
        self.hklin = []

    def setHklin(self, hklin):
        self.hklin = [hklin]

    def setOrder(self, order):
        self.order = order

    def sort(self, input = None):

        if input:
            if input.getSort_key():
                self.order = input.getSort_key()
            for hklin in input.getInput_reflections().getHklin():
                self.addHklin(hklin)
            self.setHklout(input.getOutput_reflections().getHklout())


        order = self.order
        

        if not self.hklout:
            raise CCP4.CCP4Exception, 'no HKLOUT specified'

        if len(self.hklin) == 0:
            raise CCP4.CCP4Exception, 'no HKLIN specified'

        for hklin in self.hklin:
            # check to see if the input file exists
            pass

        # should this stuff be here? I don't think so!!!
        if self.getWorkingDirectory() == '':
            here = Driver.getcwd()
        else:
            here = self.getWorkingDirectory()

        workingDirectory = here + '/sort'
        self.setWorkingDirectory(workingDirectory)

        try:
            os.mkdir(workingDirectory)
        except:
            pass


        self.start('DNA sortmtz.stf HKLOUT ' + self.hklout)
        self.input(order)
        for hklin in self.hklin:
            self.input(hklin)

        self.close()

        while 1:
            try:
                line = self.output()
            except DriverException, e:
                raise CCP4.CCP4Exception, e

            if not line:
                break

        self.kill()

        # pick up and parse the "sortmtz.stf" file
        if self.getWorkingDirectory():
            self.result = Output.Output(self.getWorkingDirectory() + '/sortmtz.stf')
        else:
            self.result = Output.Output('sortmtz.stf')

        self.dnaResult = CCP4Translation.Sort_reflections_response(self.result)

        self.setWorkingDirectory(here)
        return self.dnaResult

if __name__ == '__main__':

    s = Sortmtz()

    s.setHklin('graeme_1_001.mtz')
    s.setHklout('free_beer.mtz')

    result = s.sort()
    
    print result.marshal()
