#!/usr/bin/env python
# Mtzutils.py
# 
# Maintained by G.Winter
# 2nd December 2004
# 
# Some functionality to wrap the MTZUTILS CCP4 program.
# 
# 
# 
# $Id: Mtzutils.py,v 1.3 2005/11/22 13:38:15 svensson Exp $

import os

if not os.environ.has_key('CCP4'):
    raise RuntimeError, 'CCP4 not found'
if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

import sys

dna = os.environ['DNAHOME']
ccp4 = os.environ['CCP4']

sys.path.append(dna + '/scheduler/Scheduler/Driver')

import Driver
import CCP4

from Messenger import Messenger

class Mtzutils(Driver.Driver):
    '''A class to wrap MTZUTILS'''

    def __init__(self):
        Driver.Driver.__init__(self)
        self.setExecutable('mtzutils')

        self.hklin = None
        self.hklout = None
        self.resolution_limit = None

    def setHklin(self, hklin):
        self.hklin = hklin

    def setHklout(self, hklout):
        self.hklout = hklout

    def setResolution_limit(self, resolution_limit):
        self.resolution_limit = resolution_limit

    def run(self):
        self.process()

    def process(self):
        
        if self.hklin == '':
            raise CCP4.CCP4Exception('No HKLIN set')
        if self.hklout == '':
            raise CCP4.CCP4Exception('No HKLOUT set')
        if self.resolution_limit == None:
            raise CCP4.CCP4Exception('No resolution limit set')

        Messenger.log_write('Truncating the resolution limit of a data set')
        Messenger.log_write('%s => [%f] => %s' % \
                            (self.hklin, self.resolution_limit, self.hklout))

        if self.getWorkingDirectory() == '':
            here = Driver.getcwd()
        else:
            here = self.getWorkingDirectory()

        workingDirectory = here + '/reindex'
        self.setWorkingDirectory(workingDirectory)

        try:
            os.mkdir (workingDirectory)
        except:
            pass

        self.start('HKLIN %s HKLOUT %s' % \
                   (self.hklin, self.hklout))
        self.input('RESOLUTION %f %f' % (1000.0, self.resolution_limit))

        self.close()

        while 1:
            try:
                line = self.output()
            except DriverException, e:
                    raise CCP4.CCP4Exception, e

            if not line:
                break

        self.kill()

        self.setWorkingDirectory(here)

        
