#!/usr/bin/env python
# Mtzq.py
# Maintained by G.Winter
# 18th October 2004
# 
# A jiffy a fortran jiffy (mtzq) I wrote to interrogate mtz
# files easily for the wavelength/cell information.
# 
# 
# 
# 
# $Id: Mtzq.py,v 1.5 2005/11/22 13:38:15 svensson Exp $

import os, sys

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME must be defined'

if not os.environ.has_key('CCP4'):
    raise RuntimeError, 'CCP4 must be defined'

dna = os.environ['DNAHOME']
sys.path.append('%s/scheduler/Scheduler/Driver' % dna)
sys.path.append('%s/expertise/python/graeme/Expert' % dna)
import Driver
import Output
import Expert

class Mtzq(Driver.Driver):
    '''A class to wrap the jiffy mtzq'''

    def __init__(self, hklin = None):
        Driver.Driver.__init__(self, 1, 'mtzq')
        self.setExecutable('mtzq')
        self.cell = [0.0, 0.0, 0.0,
                     0.0, 0.0, 0.0]
        self.wavelength = 0.0
        self.spacegroup = None

        self.dmin = 0.0
        self.dmax = 0.0

        if hklin:
            self.mtzq(hklin)

    def mtzq(self, hklin):
        if self.getWorkingDirectory() == '':
            here = Driver.getcwd()
        else:
            here = self.getWorkingDirectory()
            
        workingDirectory = here + '/mtzq'

        self.setWorkingDirectory(workingDirectory)

        try:
            os.mkdir(workingDirectory)
        except:
            pass
       
        
        self.start('DNA mtzq.stf HKLIN %s' % hklin)
        self.close()

        # do this to wait until the program is finished
        while 1:
            line = self.output()
            if not line:
                break

        if self.getWorkingDirectory():
            output = Output.Output(self.getWorkingDirectory() + \
                                        '/mtzq.stf')
        else:
            output = Output.Output('mtzq.stf')

        datasets = output.searchforlist('reflection_file_info',
                                        'dataset_info_')
        
        int_ds = []
        for d in datasets:
            int_ds.append(int(d))
            
        int_ds.sort()
        
        last = int_ds[-1]
        
        self.cell = [float(output.get('reflection_file_info',
                                      'dataset_info_%d' % last, 'a')[0]),
                     float(output.get('reflection_file_info',
                                      'dataset_info_%d' % last, 'b')[0]),
                     float(output.get('reflection_file_info',
                                      'dataset_info_%d' % last, 'c')[0]),
                     float(output.get('reflection_file_info',
                                      'dataset_info_%d' % last, 'alpha')[0]),
                     float(output.get('reflection_file_info',
                                      'dataset_info_%d' % last, 'beta')[0]),
                     float(output.get('reflection_file_info',
                                      'dataset_info_%d' % last, 'gamma')[0])]
        self.wavelength = float(output.get('reflection_file_info',
                                           'dataset_info_%d' % last,
                                           'wavelength')[0])
        self.spacegroup = output.get('reflection_file_info',
                                     'dataset_info_%d' % last,
                                     'spacegroup')[0]

        self.dmin = float(output.get('resolution_limits',
                                     'limits', 'min')[0])

        self.dmax = float(output.get('resolution_limits',
                                     'limits', 'max')[0])

        self.kill()

        self.setWorkingDirectory(here)
        
        return


    def getCell(self):
        return self.cell

    def getWavelength(self):
        return self.wavelength

    def getSpacegroup(self):
        return self.spacegroup

    def getDmin(self):
        return self.dmin
    
    def getDmax(self):
        return self.dmax
    

if __name__ == '__main__':
    hklin = '/tmp/beer/truncate/truncated.mtz'

    if len(sys.argv) > 1:
        hklin = sys.argv[1]

    m = Mtzq(hklin)

    c = m.getCell()
    print 'CELL %f %f %f %f %f %f' % (c[0], c[1], c[2], c[3], c[4], c[5])
    print 'SPAG %s' % Expert.ShortSpacegroupName(m.getSpacegroup())
    # print m.getWavelength()

    

            
