#!/usr/bin/env python
# Matthews_coef.py
# Maintained by G.Winter
# 18th October 2004
# 
# A jiffy to wrap the CCP4 program matthews_coef
# 
# 
# 
# 
# 
# $Id: Matthews_coef.py,v 1.3 2005/11/22 13:38:15 svensson Exp $

import os, sys

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME must be defined'

if not os.environ.has_key('CCP4'):
    raise RuntimeError, 'CCP4 must be defined'

dna = os.environ['DNAHOME']
sys.path.append('%s/scheduler/Scheduler/Driver' % dna)
import Driver

class Matthews_coef(Driver.Driver):
    '''A Class to wrap matthews_coef'''

    def __init__(self):
        Driver.Driver.__init__(self, 1, 'matthews_coef')
        self.setExecutable('matthews_coef')
        self.molweight = 0
        self.cell = [0.0, 0.0, 0.0, 90.0, 90.0, 90.0]
        self.symmetry = 'p1'

    def setSymmetry(self, symmetry):
        self.symmetry = symmetry

    def setMolweight(self, molweight):
        self.molweight = molweight

    def setCell(self, a, b, c, alpha = 90.0, beta = 90.0, gamma = 90.0):
        self.cell = [a, b, c, alpha, beta, gamma]

    def run(self):
        return self.matthews_coef()

    def matthews_coef(self):

        self.start()

        self.input('symm %s' % self.symmetry)
        self.input('cell %f %f %f %f %f %f' % \
                   (self.cell[0],
                    self.cell[1],
                    self.cell[2],
                    self.cell[3],
                    self.cell[4],
                    self.cell[5]))
        self.input('molw %f' % self.molweight)
        self.input('auto')
        self.close()

        start_output = False
        solvent = { }

        while 1:
            line = self.output()
            if not line:
                break

            if start_output:
                if line[:10] == '__________':
                    break
                list = line.split()
                nmol = int(list[0])
                solv = float(list[2])
                solvent[nmol] = 0.01 * solv
            
            if line[:10] == '__________':
                start_output = True
        

        self.kill()
        
        return solvent

if __name__ == '__main__':

    m = Matthews_coef()
    m.setCell(128.5, 80.7, 93.7, 90.0, 93.2, 90.0)
    m.setMolweight(31500.0)
    m.setSymmetry('c2')

    print m.matthews_coef()

    
    
