#!/usr/bin/env python
############################################################
# Comment.py
# Maintained by G.Winter
# 4th January 2004
# 
# Something to see what the expert thinks about an stf file
# from somewhere... this will print all of the *ahem* helpful
# comments.
# 
# $Id: Comment.py,v 1.3 2005/11/22 13:38:15 svensson Exp $
############################################################

import os, sys

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

dna = os.environ['DNAHOME']

sys.path.append(dna + '/xsd/python')
sys.path.append(dna + '/expertise/python/graeme/Expert')
sys.path.append(dna + '/scheduler/Scheduler/Mosflm')
sys.path.append(dna + '/scheduler/Scheduler/Driver')

import Expert
import Output
from Messenger import Messenger

import CCP4Translation
import Expert

if len(sys.argv) < 3:
    raise RuntimeError, '%s -scale stf-file' % sys.argv[0]

stf_file = sys.argv[2]

if sys.argv[1] == '-scale':

    data = CCP4Translation.Scale_reflections_response(Output.Output(stf_file))
    Expert.ConsiderScaleReflectionsResponse(data)
