#!/usr/bin/env python
# CCP4Translation.py
# Maintained by G.Winter
# A component in the revision of the scheduler code - version 1.1
# 19th January 2004
# 
# This component will create DNA result objects and populate them from 
# Output objects derived from '${flintstone}' files.
# 
# 
# $Id: CCP4Translation.py,v 1.11 2005/11/22 13:38:15 svensson Exp $

import os, math

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNA not found'

dna = os.environ['DNAHOME']

import sys
sys.path.append(dna + '/xsd/python')
sys.path.append(dna + '/expertise/python/graeme/Expert')
sys.path.append(dna + '/scheduler/Scheduler/Mosflm')
sys.path.append(dna + '/scheduler/Scheduler/Driver')

import string

import XSD, Expert
from Messenger import Messenger
from Somewhere import Somewhere

def RemovePrefix(list, prefix):
    result = []
    for l in list:
        this = str(l)
        if this != '__count__':
            that = string.replace(this, prefix, '')
            result.append(int(that))

    result.sort()
    return result

def Reindex_reflections_response():
    '''Create an empty response with just a status which says "ok"'''

    reindex_reflections_response = XSD.Reindex_reflections_response()
    status = XSD.Status()

    status.setCode('ok')
    reindex_reflections_response.setStatus(status)

    return reindex_reflections_response

def Sort_reflections_response(output):
    '''Convert an output object into a dna response'''

    sort_reflections_response = XSD.Sort_reflections_response()

    # first check for any errors
    try:
        message = output.get('error', 'error', 'message')[0]
        status = XSD.Status()
        status.setCode('error')
        status.setMessage(str(message))
        sort_reflections_response.setStatus(status)
        return sort_reflections_response
    except:
        # all was well
        pass


    statusCode = int(output.get('status', 'message', 'status')[0])

    if statusCode == 0:
        # all was well
        status = XSD.Status()
        status.setCode('ok')
        sort_reflections_response.setStatus(status)
    else:
        message = output.get('status', 'message', 'message')
        status = XSD.Status()
        status.setCode('error')
        status.setMessage(str(message))
        sort_reflections_response.setStatus(status)

    return sort_reflections_response

def Scale_reflections_response(output):
    scale_reflections_response = XSD.Scale_reflections_response()
    
    try:
        message = output.get('error', 'error', 'message')[0]
        status = XSD.Status()
        status.setCode('error')
        status.setMessage(str(message))
        scale_reflections_response.setStatus(status)
        return scale_reflections_response
    except:
        pass

    # first try to get an idea of the resolution to which the data are
    # complete

    completeness = { }
    resolutions = []

    for shell in output.searchforlist(
        'completeness_multiplicity_vs_resolution', 'shell_'):
        percent_possible = float(output.get(
            'completeness_multiplicity_vs_resolution', 'shell_' + shell,
            'percent_possible')[0])
        resolution = float(output.get(
            'completeness_multiplicity_vs_resolution', 'shell_' + shell,
            'd_min')[0])

        resolutions.append(resolution)
        completeness[resolution] = percent_possible

    resolutions.sort()

    res = 0.0
    for r in resolutions:
        if completeness[r] > 98.0:
            res = r
            break

    Messenger.log_write('Data are 98 percent complete to %f' % res, 2)
    Somewhere.store('Complete resolution', res)

    # if there are no errors in the scaling output, perhaps it
    # should be passed to the Expert for analysis...
    batches = RemovePrefix(output.get('scale_factors_by_batch').keys(), \
                           'batch_')

    # at this stage send the results to an expert to look for
    # systematic absences in the reflections along the axes
    # this should be implemented in a spacegroup dependent way
    # but won't be in the first instance.

    # aha! the output of the axial reflections will not be there *unless*
    # there may be systematic absences...

    # cool

    axial_reflections = { }
    
    axes = output.searchfortable('axial_reflections_')
    for a in axes:
        axial_reflections[a] = { }
        for i in output.searchforlist('axial_reflections_' + a,
                                      'index_'):
            index = int(output.get('axial_reflections_' + a,
                                   'index_' + i, 'index')[0])
            i_over_sig = float(output.get('axial_reflections_' + a,
                                          'index_' + i, 'i_over_sig')[0])
            
            axial_reflections[a][index] = i_over_sig

    screw_axes = Expert.DetectScrewAxes(axial_reflections)
    
    scale_factor_list = XSD.Scale_factor_list()

    # next get the analysis-by-batch information out
    per_batch_results = XSD.Per_batch_results()

    total_reflections = 0

    for b in batches:
        key = 'batch_' + str(b)
        n_ref = int(output.get('scale_factors_by_batch', key, 'n_ref')[0])
        total_reflections += n_ref
        scale = float(output.get('scale_factors_by_batch', key, 'mean_k')[0])
        scale_factor = XSD.Scale_factor()
        scale_factor.setBatch(b)
        scale_factor.setMean_k(scale)
        scale_factor_list.addScale_factor(scale_factor)
        batch_results = XSD.Batch_results()
        batch_results.setBatch(
            int(output.get('scale_factors_by_batch', key, 'batch_number')[0]))
        batch_results.setBfactor(
            float(output.get('scale_factors_by_batch', key, 'b_factor')[0]))
        batch_results.setNumber_rejected(
            int(output.get('scale_factors_by_batch', key, 'n_rejected')[0]))
        batch_results.setRmerge(
            float(output.get('analysis_against_batch', key, 'rmerge')[0]))
        per_batch_results.addBatch_results(batch_results)

    Messenger.log_write('Total reflections scaled %d' % total_reflections)

    scale_reflections_response.setScale_factor_list(scale_factor_list)
    scale_reflections_response.setPer_batch_results(per_batch_results)

    status = XSD.Status()
    status.setCode('ok')
    
    rmerge = float(output.get('summary_data', 'overall', 'rmerge')[0])

    scale_reflections_response.setStatus(status)
    scale_reflections_response.setRmerge(rmerge)

    # next get the standard deviation information out

    standard_deviation_parameters = XSD.Standard_deviation_parameters()
    standard_deviation_parameters.setSdfac_full(float(output.get('analysis_of_standard_deviations', 'run_1', 'sdfac_full')[0]))
    standard_deviation_parameters.setSdadd_full(float(output.get('analysis_of_standard_deviations', 'run_1', 'sdadd_full')[0]))
    standard_deviation_parameters.setSdfac_partial(float(output.get('analysis_of_standard_deviations', 'run_1', 'sdfac_partial')[0]))
    standard_deviation_parameters.setSdadd_partial(float(output.get('analysis_of_standard_deviations', 'run_1', 'sdadd_partial')[0]))
    scale_reflections_response.setStandard_deviation_parameters(standard_deviation_parameters)

    # next get the I/sigma as a function of resolution information
    # this requires a change to the XSD - change done, added something called
    # per_resolution_bin_results and resolution_bin_results

    per_resolution_bin_results = XSD.Per_resolution_bin_results()
    shells = output.searchforlist('analysis_against_resolution', 'shell_')
    int_shells = []
    for s in shells:
        int_shells.append(int(s))
    shells = int_shells
    shells.sort()

    for s in shells:
        resolution_bin_results = XSD.Resolution_bin_results()
        resolution_bin_results.setBin(s)
        resolution = XSD.Resolution()
        resolution.setLower(0.0)
        resolution.setUpper(float(
            output.get('analysis_against_resolution',
                       'shell_%d' % s, 'd_min')[0]))
        resolution_bin_results.setResolution(resolution)
        resolution_bin_results.setRmerge(float(
            output.get('analysis_against_resolution',
                       'shell_%d' % s, 'rmerge')[0]))
        resolution_bin_results.setMean_i_over_sigma(float(
            output.get('analysis_against_resolution',
                       'shell_%d' % s, 'mean_intensity_sigma')[0]))
        resolution_bin_results.setFractional_bias(float(
            output.get('analysis_against_resolution',
                       'shell_%d' % s, 'fractional_bias')[0]))
        per_resolution_bin_results.addResolution_bin_results(
            resolution_bin_results)

    scale_reflections_response.setPer_resolution_bin_results(
        per_resolution_bin_results)

    per_intensity_bin_results = XSD.Per_intensity_bin_results()
    bins = output.searchforlist('standard_deviation_vs_intensity',
                                'intensity_bin_')
    int_bins = []
    for b in bins:
        int_bins.append(int(b))
    int_bins.sort()
    bins = int_bins

    for b in bins:
        intensity_bin_results = XSD.Intensity_bin_results()
        intensity_bin_results.setBin(b)
        intensity_bin_results.setMin_intensity(float(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'min_intensity')[0]))
        intensity_bin_results.setMax_intensity(float(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'max_intensity')[0]))
        intensity_bin_results.setMean_full(float(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'mean_full')[0]))
        intensity_bin_results.setSigma_full(float(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'sigma_full')[0]))
        intensity_bin_results.setN_ref_full(int(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'number_full')[0]))
        intensity_bin_results.setMean_partial(float(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'mean_partial')[0]))
        intensity_bin_results.setSigma_partial(float(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'sigma_partial')[0]))
        intensity_bin_results.setN_ref_partial(int(
            output.get('standard_deviation_vs_intensity',
                       'intensity_bin_%d' % b, 'number_partial')[0]))
        per_intensity_bin_results.addIntensity_bin_results(
            intensity_bin_results)

    scale_reflections_response.setPer_intensity_bin_results(
        per_intensity_bin_results)


    return scale_reflections_response

def Truncate_reflections_response(output):
    truncate_reflections_response = XSD.Truncate_reflections_response()
    status = XSD.Status()
    status.setCode('ok')
    truncate_reflections_response.setStatus(status)
    bfactor = float(output.get('wilson_plot', 'bfactor_info',
                               'bfactor')[0])
    truncate_reflections_response.setBfactor_value(bfactor)

    # should pull out the acentric moments of intensity here
    # to look for twinning, as well as the solvent content of the
    # crystal and other information like that

    truncate_reflections_response.setSolvent_content(1.0 - float(
        output.get('asymmetric_unit_contents', 'general_info',
                   'fraction_volume_atoms')[0]))

    resolution_bins = RemovePrefix(
        output.get('acentric_moments_intensity').keys(), 'moments_')

    resolution_bins.sort()

    acentric_moments = []

    for r in resolution_bins:
        acentric_moments.append(float(
            output.get('acentric_moments_intensity', 'moments_' + str(r),
                       'moment_z2')[0]))

    if len(resolution_bins) > 0:
        twinning = Expert.LookForTwinningAcentric2(acentric_moments)
        truncate_reflections_response.setTwinning(twinning)

    # next perform an analysis of the anisotropy information
    resolution_bins = RemovePrefix(
        output.get('anisotropy_analysis').keys(), 'resolution_bin_')
    resolution_bins.sort()

    aniso_data = { }
    aniso_data['mn_f_d1'] = []
    aniso_data['mn_f_d2'] = []
    aniso_data['mn_f_d3'] = []
    aniso_data['mn_f_overall'] = []
    aniso_data['mn_f_sig_d1'] = []
    aniso_data['mn_f_sig_d2'] = []
    aniso_data['mn_f_sig_d3'] = []
    aniso_data['mn_f_sig_overall'] = []
    aniso_data['resolution'] = []
    for r in resolution_bins:
        for thing in ['mn_f_d1', 'mn_f_d2', 'mn_f_d3', \
                      'mn_f_overall', 'mn_f_sig_d1', 'mn_f_sig_d2', \
                      'mn_f_sig_d3', 'mn_f_sig_overall']:
            aniso_data[thing].append(float(
                output.get('anisotropy_analysis', \
                           'resolution_bin_' + str(r), \
                           thing)[0]))
        resolution = 1.0 / math.sqrt(float(
            output.get('anisotropy_analysis', \
                       'resolution_bin_' + str(r), \
                       'inv_resol_sq')[0]))
        
        aniso_data['resolution'].append(resolution)

    Expert.AnalyseFALLOFF(aniso_data)
                           

    return truncate_reflections_response

if __name__ == '__main__':

    import Output
    
    infile = '/data/graeme/images/scale/scala.stf'

    o = Output.Output(infile)
    
    s = Scale_reflections_response(o)

    print s.marshal()
