#!/usr/bin/env python
############################################################
# CCP4Log.py
# A html log making mechanism for DNA
# 
# Maintained by G.Winter
# 
# 24th August 2004
#
# $Id: CCP4Log.py,v 1.4 2005/11/22 13:38:15 svensson Exp $
# 
############################################################

import os, sys, math

if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined!'

dna = os.environ['DNAHOME']
sys.path.append('%s/xsd/python' % dna)
sys.path.append('%s/scheduler/Scheduler/Mosflm' % dna)

from Messenger import Messenger
from Somewhere import Somewhere

sys.path.append('%s/scheduler/Scheduler/Driver' % dna)

import Plotter

def Scaling(output, directory):
    '''Mark up the output from scala nicely in HTML'''

    try:
        os.mkdir('%s/scaling' % directory)
    except:
        Messenger.log_write('Failed to make directory %s/scaling' % \
                            directory, 2)

    # first get the axial reflection information out

    axial_reflections = { }
    
    axes = output.searchfortable('axial_reflections_')

    # want them in alphabetical order then e.g. h k l
    if len(axes) > 1:
        axes.sort()
        
    for a in axes:
        axial_reflections[a] = { }
        for i in output.searchforlist('axial_reflections_' + a,
                                      'index_'):
            index = int(output.get('axial_reflections_' + a,
                                   'index_' + i, 'index')[0])
            i_over_sig = float(output.get('axial_reflections_' + a,
                                          'index_' + i, 'i_over_sig')[0])
            
            axial_reflections[a][index] = i_over_sig

    html_out = open('%s/scaling/index.html' % directory, 'w')
    html_out.write('<html><head><title>Scaling Results</title>' +
                   '</head><body>')
    html_out.write('<h1>Scaling results</h1>')
    html_out.write('<h3>Scaling graphs</h3>')
    html_out.write('<p>%d axes were measured for axial reflections' %
                   len(axes))
    if len(axes) == 0:
        html_out.write(' so there is no information available.</p>')
    else:
        html_out.write(': ')
        for a in axes:
            html_out.write('%s ' % a)
        html_out.write('</p>')

        # since we have axial reflection information we should generate
        # some graphs of this...

        for a in axes:
            index_list = axial_reflections[a].keys()
            index_list.sort()
            i_over_sig = []
            for i in index_list:
                i_over_sig.append(axial_reflections[a][i])

            # now generate the plot for axis 'a' - called axis_${a}.gif
            plotter = Plotter.Plotter()
            plotter.setLegend('Axial reflections (%s) vs. Index' % a,
                              'Index', 'I/sigma')
            plotter.setData('/tmp/plotter-logger-%s' % os.environ['USER'])
            plotter.setX(index_list)
            plotter.setY(i_over_sig)

            plotter.setGraph('%s/scaling/axial_%s.gif' % \
                             (directory, a))
            plotter.plot()

            html_out.write('<p><img src="%s/scaling/axial_%s.gif"/></p>' % \
                           (directory, a))

    # next get hold of the completeness and multiplicity information
    # as well as some metadata about the point group in which the data
    # was scaled and so on

    completeness = []
    resolutions = []
    multiplicities = []
    shells = output.searchforlist(
        'completeness_multiplicity_vs_resolution', 'shell_')
    shell = []
    for s in shells:
        shell.append(int(s))
    shell.sort()

    for s in shell:
        percent_possible = float(output.get(
            'completeness_multiplicity_vs_resolution', 'shell_%d' % s,
            'percent_possible')[0])
        multiplicity = float(output.get(
            'completeness_multiplicity_vs_resolution', 'shell_%d' % s,
            'multiplicity')[0])
        resolution = float(output.get(
            'completeness_multiplicity_vs_resolution', 'shell_%d' % s,
            'd_min')[0])

        resolutions.append(resolution)
        completeness.append(percent_possible)
        multiplicities.append(multiplicity)
    
    plotter = Plotter.Plotter()

    plotter.setLegend('Completeness vs. Resolution', 'Resolution',
                      'Completeness')
    plotter.setData('/tmp/plotter-logger-%s' % os.environ['USER'])
    plotter.setX(resolutions)
    plotter.setY(completeness)
    plotter.setYrange(0.0, 100.0)
    plotter.setGraph('%s/scaling/completeness.gif' % directory)
    plotter.plot()

    html_out.write('<p><img src="%s/scaling/completeness.gif"/></p>' % \
                   directory)

    # next the multiplicity
    # hmm... should probably encapsulate this stuff with "plotters"
    # this also makes me realise that the "multiplicity" information
    # isn't in there!

    top = int(max(multiplicities)) + 1

    plotter = Plotter.Plotter()
    plotter.setLegend('Multiplicity vs. Resolution', 'Resolution',
                      'Multiplicity')
    plotter.setData('/tmp/plotter-logger-%s' % os.environ['USER'])
    plotter.setX(resolutions)
    plotter.setY(multiplicities)
    plotter.setYrange(0.0, float(top))
    plotter.setGraph('%s/scaling/multiplicity.gif' % directory)
    plotter.plot()

    html_out.write('<p><img src="%s/scaling/multiplicity.gif"/></p>' % \
                   directory)

    mtz_file = Somewhere.get('scaling_mtz')
    mtz_location = mtz_file[:-10]
    html_out.write('<p>Click <a href="%s">here</a> for the' % mtz_file)
    html_out.write(' resulting MTZ file</p>')
    html_out.write('<p>Click <a href="%s/scala.log">here</a> for the' %
                   mtz_location)
    html_out.write(' log file</p>')

    html_out.write('</body></html>')
    
    html_out.close()

                      
            
