#!/home/graeme/bin/python

import DiffractionImage
import time, math

def compare(this, that, fraction):
    if (that == 0):
        if math.fabs(this - that) < fraction:
            return 1
        else:
            return 0
    else:
        if math.fabs((this - that) / that) < fraction:
            return 1

    return 0


d = DiffractionImage.DiffractionImage()

print "test.mccd"

d.load("/home/graeme/CVS/dna_testdata/scheduler/test.mccd")
d.setBeamX(80.66)
d.setBeamY(80.77)
print d.getPixelX(), d.getPixelY()
print d.getWidth() * d.getPixelX()
print d.getHeight() * d.getPixelY()
print 'exposure time %f' % d.getExposureTime()
print d.getDistance()
if compare(d.getDistance(), 200.0, 0.1) == 0:
    print "getDistance() failed"
else:
    print "getDistance() succeeded"

# d.setDistance(100.0)
# print 'new distance is', d.getDistance()

if compare(d.getWavelength(), 0.933, 0.1) == 0:
    print "getWavelength() failed"
else:
    print "getWavelength() succeeded"

print "now testing peak finding"
p = DiffractionImage.PeakList()
print "testing workings"
print p.find(d)
for i in range(100, 110):
    print p[i]
print p.circle()

print "test.adsc"

d.load("/home/graeme/CVS/dna_testdata/scheduler/test.adsc")

print 'exposure time %f' % d.getExposureTime()

if compare(d.getDistance(), 250.0, 0.1) == 0:
    print "getDistance() failed"
else:
    print "getDistance() succeeded"

if compare(d.getWavelength(), 0.934, 0.1) == 0:
    print "getWavelength() failed"
else:
    print "getWavelength() succeeded"

