from distutils.core import setup, Extension
setup(name = "DiffractionImage",
      version = "1.0",
      ext_modules = [Extension(
    "DiffractionImage", [
    "DiffractionImage.cpp",
    "DiffractionImageADSC.cpp",
    "DiffractionImageMarCCD.cpp",
    "DiffractionImageMAR.cpp",
    "DiffractionImageJpeg.cpp",
    "DiffractionImageRaw.cpp",
    "DiffractionImageUtility.cpp",
    "DiffractionImageCalculations.cpp",
    "DiffractionImageCompare.cpp",
    "DiffractionImagePythonInterface.cpp",
    "Peak.cpp",
    "PeakPythonInterface.cpp",
    "dps_peaksearch_cn.c"],
    include_dirs = ["../../../ext/include"],
    library_dirs = ["../../../ext/lib"],
    define_macros = [("INCLUDE_PYTHON", None),
                     ("INCLUDE_JPEG", None),
                     ("INCLUDE_JASPER", None)],
    libraries = ["jasper", "jpeg", "marbits"])])



