#include "Viewer.h"

#include <qpainter.h>

Viewer::Viewer(QWidget * parent,
	       const char * name)
  : QWidget(parent, name)
{
  readImage("test.wax");
}

Viewer::~Viewer(void)
{
  // do nothing
}

#define SCALE 3

void Viewer::readImage(string name)
{
  d.load(name);

  p.clear();
  p.find(&d);

  int width = d.getWidth();
  int height = d.getHeight();

  unsigned short * a, * b;
  unsigned char * c;

  a = d.getImage();
  b = new unsigned short [width * height / (SCALE * SCALE)];
  c = new unsigned char [width * height / (SCALE * SCALE)];

  reduceImage(a, width, height, SCALE, b);
  downSample(b, width / SCALE, height / SCALE, false, c);

  delete [] b;

  uint * scanLine;

  unsigned char pixel;

  setMinimumSize(width / SCALE, height / SCALE);
  setMaximumSize(width / SCALE, height / SCALE);
  resize(width / SCALE, height / SCALE);

  image = QImage(width / SCALE, height / SCALE, 32);

  for (int i = 0; i < height / SCALE; i++)
    {
      scanLine = (uint *) image.scanLine(i);
      for (int j = 0; j < width / SCALE; j++)
	{
	  pixel = 0xff - c[i * width / SCALE + j];
	  scanLine[j] = qRgba(pixel, pixel, pixel, 0);
	}
    }

  // next draw on the spot positions - in red

  for (int i = 0; i < p.length(); i++)
    {
      int x = (int) (p[i].x / SCALE);
      int y = (int) (p[i].y / SCALE);

      for (int _x = -1; _x <= 1; _x ++)
	{
	  scanLine = (uint *) image.scanLine(x + _x);
	  for (int _y = 0; _y <= 1; _y ++)
	    {
	      scanLine[y + _y] = qRgba(0xff, 0, 0, 0);
	    }
	}
    }

  // finally draw on the circles of spots - if found

  // the parameter SIZE will depend on the expected separation of the circles
#define SIZE 2.5

  int spots = p.length();

  int found = 1000;
  int count = 0;

  float beam_x = 0;
  float beam_y = 0;
  int points_used = 0;

  while (found > 100)
    {
      count ++;

      float x, y, r;
      found = p.circle(25000, SIZE, x, y, r);

      if (found > 100)
	{
	  
	  beam_x += found * x;
	  beam_y += found * y;
	  points_used += found;
	  
	  p.remove(SIZE, x, y, r);
	  
	  // draw the circle
	  
	  // scale down
	  x /= SCALE;
	  y /= SCALE;
	  r /= SCALE;
	  
	  for (int i = 0; i < height / SCALE; i++)
	    {
	      scanLine = (uint *) image.scanLine(i);
	      for (int j = 0; j < width / SCALE; j++)
		{
		  if (fabs(sqrt((x - j) * (x - j) + (y - i) * (y - i)) - r) 
		      < 0.707)
		    {
		      scanLine[j] = qRgba(0xff, 0xff, 0, 0);
		    }
		}
	    }
	}
    }

  cout << "beam is " << beam_x / points_used << "\t" << beam_y / points_used
       << endl;

  float _x, _y;

  beam_x /= points_used;
  beam_y /= points_used;

  _x = beam_x / SCALE;
  _y = beam_y / SCALE;

  for (int i = 0; i < height / SCALE; i++)
    {
      scanLine = (uint *) image.scanLine(i);
      for (int j = 0; j < width / SCALE; j++)
	{
	  float dist = sqrt((_x - j) * (_x - j) + (_y - i) * (_y - i));
	  if ((int(dist) % 20) == 0)
	    {
	      scanLine[j] = qRgba(0, 0, 0xff, 0);
	    }
	}
    }  


  delete [] c;

}

void Viewer::paintEvent(QPaintEvent *)
{
  QPainter * painter = new QPainter (this);
  painter->drawImage(0, 0, image);
  delete painter;
}
