// Peak.h
// maintained by G.Winter
// 6th January 2004
// 
// A (more accurately named) replacement for the old SpotSearch classes
// which will be used for interacting with peaks on DiffractionImage's.
// This will be accessible to Python.
// 
// $Id: Peak.h,v 1.8 2004/05/18 11:32:14 svensson Exp $
// 

#ifndef _PEAK_HEADER
#define _PEAK_HEADER

#ifdef INCLUDE_PYTHON
// this is not needed, since it is included in DiffractionImage.h
// #include "Python.h"
#endif

#include "DiffractionImage.h"

// standard templates which I want to use

#include <list>
#include <vector>
using namespace std;

struct Peak {
  float x;
  float y;
  float theta;
  float phi;
  float kappa;
  // reciprocal lattice coordinate
  float p[3];
  float intensity;
};

// a handy typedef
// no longer needed
// typedef list<Peak> __PeakList;

namespace DI
{
  class PeakList
    {
    public:
#ifdef INCLUDE_PYTHON
      PyObject_HEAD;
#endif
      // constructors and destructors
      PeakList(void);

      // this will create a populated peak list
      PeakList(DiffractionImage * diffractionImage);

      // and a copy constructor
      PeakList(const PeakList & peakList);

      ~PeakList(void);

      // things to aid the Python interfacification
      void constructor(void);
      void constructor(DiffractionImage * diffractionImage);
      void constructor(const PeakList & peakList);

      void destructor(void);

      // next the methods

      int length(void);
      void clear(void);
      void add(float x,
	       float y,
	       float intensity);
      void remove(int offset);
      void add(Peak peak);
      
      void find(DiffractionImage * diffractionImage);
      void find(DiffractionImage * diffractionImage,
		int maxPeaks);
      void find(DiffractionImage * diffractionImage,
		int maxPeaks,
		float intensityThreshold);

      // to and from reciprocal lattice coordinates
      void reciprocal(float distance, 
		      float wavelength);
      void detector(float distance, 
		    float wavelength);

      // an array dereference operator and the equivalent method
      Peak & operator[] (int offset);
      Peak & get(int offset);

      // this is get & remove
      Peak pop(int offset);
      
      // this will make a complete copy of the list and return this as a
      // vector - which will be better for performing numerical things
      // with
      vector<Peak> getPeaks(void);
      
      // functional operations - things which actually do something with 
      // the list of spots, other than simply storing them

      // find, using a stochastic process, a circle in the spots - this 
      // will return the most promising candidate.

      // the parameter width determines how close to the arc a spot must be 
      // to be considered as on it - the other parameters are returned.
      // the return value is the number of spots on the best circle found.
      // iterations is the number of times to attempt circle fitting - a
      // relatively large number is probably necessary here, of order
      // 1000 ish.

      int circle(int iterations,
		 float width,
		 float & x,
		 float & y,
		 float & r);

      // this will, coupled with the above, remove those spots which were
      // found to be on the circle. at least - that is what we hope!

      int remove(float width,
		 float x,
		 float y,
		 float r);

    private:
      // __PeakList * _list;
      list<Peak> _list;
      int _length;
      
    };

  // other functions which share the namespace

  int fitCircle(float x0,
		float y0,
		float x1,
		float y1,
		float x2,
		float y2,
		float & x,
		float & y,
		float & r);
		 

};

#endif
